/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.zmq;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.dflib.jjava.shaded.zmq.Command;
import org.dflib.jjava.shaded.zmq.Ctx;
import org.dflib.jjava.shaded.zmq.IMailbox;
import org.dflib.jjava.shaded.zmq.Signaler;
import org.dflib.jjava.shaded.zmq.util.Errno;

public class Mailbox
implements IMailbox {
    private final Deque<Command> cpipe;
    private final Signaler signaler;
    private final String name;
    private final Errno errno;

    public Mailbox(Ctx ctx, String name, int tid) {
        this.errno = ctx.errno();
        this.cpipe = new ConcurrentLinkedDeque<Command>();
        this.signaler = new Signaler(ctx, tid, this.errno);
        this.name = name;
    }

    public SelectableChannel getFd() {
        return this.signaler.getFd();
    }

    @Override
    public void send(Command cmd) {
        this.cpipe.addLast(cmd);
        this.signaler.send();
    }

    @Override
    public Command recv(long timeout) {
        Command cmd = this.cpipe.pollFirst();
        while (cmd == null) {
            boolean rc = this.signaler.waitEvent(timeout);
            if (!rc) {
                assert (this.errno.get() == 35 || this.errno.get() == 4) : this.errno.get();
                break;
            }
            this.signaler.recv();
            if (this.errno.get() == 4) break;
            cmd = this.cpipe.pollFirst();
        }
        return cmd;
    }

    @Override
    public void close() throws IOException {
        this.signaler.close();
    }

    public String toString() {
        return super.toString() + "[" + this.name + "]";
    }
}

