/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.zmq;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dflib.jjava.shaded.zmq.Command;
import org.dflib.jjava.shaded.zmq.Ctx;
import org.dflib.jjava.shaded.zmq.Mailbox;
import org.dflib.jjava.shaded.zmq.SocketBase;
import org.dflib.jjava.shaded.zmq.ZObject;
import org.dflib.jjava.shaded.zmq.poll.IPollEvents;
import org.dflib.jjava.shaded.zmq.poll.Poller;

final class Reaper
extends ZObject
implements IPollEvents,
Closeable {
    private final Mailbox mailbox;
    private final Poller.Handle mailboxHandle;
    private final Poller poller;
    private int socketsReaping = 0;
    private final AtomicBoolean terminating = new AtomicBoolean();

    Reaper(Ctx ctx, int tid) {
        super(ctx, tid);
        String name = "reaper-" + tid;
        this.poller = new Poller(ctx, name);
        this.mailbox = new Mailbox(ctx, name, tid);
        SelectableChannel fd = this.mailbox.getFd();
        this.mailboxHandle = this.poller.addHandle(fd, this);
        this.poller.setPollIn(this.mailboxHandle);
    }

    @Override
    public void close() throws IOException {
        this.poller.destroy();
        this.mailbox.close();
    }

    Mailbox getMailbox() {
        return this.mailbox;
    }

    void start() {
        this.poller.start();
    }

    void stop() {
        if (!this.terminating.get()) {
            this.sendStop();
        }
    }

    @Override
    public void inEvent() {
        Command cmd;
        while ((cmd = this.mailbox.recv(0L)) != null) {
            cmd.process();
        }
    }

    @Override
    protected void processStop() {
        this.terminating.set(true);
        if (this.socketsReaping == 0) {
            this.finishTerminating();
        }
    }

    @Override
    protected void processReap(SocketBase socket) {
        ++this.socketsReaping;
        socket.startReaping(this.poller);
    }

    @Override
    protected void processReaped() {
        --this.socketsReaping;
        if (this.socketsReaping == 0 && this.terminating.get()) {
            this.finishTerminating();
        }
    }

    private void finishTerminating() {
        this.sendDone();
        this.poller.removeHandle(this.mailboxHandle);
        this.poller.stop();
    }
}

