/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.zmq;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.util.concurrent.atomic.AtomicLong;
import org.dflib.jjava.shaded.zmq.Ctx;
import org.dflib.jjava.shaded.zmq.ZError;
import org.dflib.jjava.shaded.zmq.util.Errno;
import org.dflib.jjava.shaded.zmq.util.Utils;

final class Signaler
implements Closeable {
    private final Pipe.SinkChannel w;
    private final Pipe.SourceChannel r;
    private final Selector selector;
    private final ThreadLocal<ByteBuffer> wdummy = ThreadLocal.withInitial(() -> ByteBuffer.allocate(1));
    private final ThreadLocal<ByteBuffer> rdummy = ThreadLocal.withInitial(() -> ByteBuffer.allocate(1));
    private final AtomicLong wcursor = new AtomicLong(0L);
    private long rcursor = 0L;
    private final Errno errno;
    private final int pid;
    private final Ctx ctx;

    Signaler(Ctx ctx, int pid, Errno errno) {
        this.ctx = ctx;
        this.pid = pid;
        this.errno = errno;
        try {
            Pipe pipe = Pipe.open();
            this.r = pipe.source();
            this.w = pipe.sink();
            Utils.unblockSocket(this.w, this.r);
            this.selector = ctx.createSelector();
            this.r.register(this.selector, 1);
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <O> O maksInterrupt(IoOperation<O> operation) throws IOException {
        boolean interrupted = Thread.interrupted();
        while (true) {
            try {
                O o = operation.call();
                return o;
            }
            catch (ClosedByInterruptException e) {
                interrupted = true;
                continue;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    @Override
    public void close() throws IOException {
        IOException exception = null;
        IoOperation<Object> op1 = () -> {
            this.r.close();
            return null;
        };
        IoOperation<Object> op2 = () -> {
            this.w.close();
            return null;
        };
        IoOperation<Object> op3 = () -> {
            this.ctx.closeSelector(this.selector);
            return null;
        };
        for (IoOperation op : new IoOperation[]{op1, op2, op3}) {
            try {
                this.maksInterrupt(op);
            }
            catch (IOException e) {
                if (exception != null) {
                    e.addSuppressed(exception);
                }
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    SelectableChannel getFd() {
        return this.r;
    }

    void send() {
        int nbytes = 0;
        while (nbytes == 0) {
            try {
                this.wdummy.get().clear();
                nbytes = this.maksInterrupt(() -> this.w.write(this.wdummy.get()));
            }
            catch (IOException e) {
                throw new ZError.IOException(e);
            }
        }
        this.wcursor.incrementAndGet();
    }

    boolean waitEvent(long timeout) {
        int rc;
        boolean brc;
        if (Thread.interrupted()) {
            this.errno.set(4);
            return false;
        }
        boolean bl = brc = this.rcursor < this.wcursor.get();
        if (brc) {
            return true;
        }
        try {
            if (timeout == 0L) {
                this.errno.set(35);
                return false;
            }
            rc = timeout < 0L ? this.selector.select(0L) : this.selector.select(timeout);
        }
        catch (ClosedSelectorException e) {
            this.errno.set(4);
            return false;
        }
        catch (IOException e) {
            this.errno.set(ZError.exccode(e));
            return false;
        }
        if (Thread.interrupted() || rc == 0 && timeout <= 0L && !this.selector.keys().isEmpty()) {
            this.errno.set(4);
            return false;
        }
        if (rc == 0) {
            this.errno.set(35);
            return false;
        }
        this.selector.selectedKeys().clear();
        return true;
    }

    void recv() {
        int nbytes = 0;
        while (nbytes == 0) {
            try {
                this.rdummy.get().clear();
                nbytes = this.maksInterrupt(() -> this.r.read(this.rdummy.get()));
            }
            catch (ClosedChannelException e) {
                this.errno.set(4);
                return;
            }
            catch (IOException e) {
                throw new ZError.IOException(e);
            }
        }
        assert (nbytes == 1);
        ++this.rcursor;
    }

    public String toString() {
        return "Signaler[" + this.pid + "]";
    }

    private static interface IoOperation<O> {
        public O call() throws IOException;
    }
}

