/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.zmq.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import org.dflib.jjava.shaded.zmq.Command;
import org.dflib.jjava.shaded.zmq.Ctx;
import org.dflib.jjava.shaded.zmq.Mailbox;
import org.dflib.jjava.shaded.zmq.ZObject;
import org.dflib.jjava.shaded.zmq.poll.IPollEvents;
import org.dflib.jjava.shaded.zmq.poll.Poller;

public class IOThread
extends ZObject
implements IPollEvents,
Closeable {
    private final Mailbox mailbox;
    private final Poller.Handle mailboxHandle;
    private final Poller poller;

    public IOThread(Ctx ctx, int tid) {
        super(ctx, tid);
        String name = "iothread-" + tid;
        this.poller = new Poller(ctx, name);
        this.mailbox = new Mailbox(ctx, name, tid);
        SelectableChannel fd = this.mailbox.getFd();
        this.mailboxHandle = this.poller.addHandle(fd, this);
        this.poller.setPollIn(this.mailboxHandle);
    }

    public void start() {
        this.poller.start();
    }

    @Override
    public void close() throws IOException {
        this.poller.destroy();
        this.mailbox.close();
    }

    public void stop() {
        this.sendStop();
    }

    public Mailbox getMailbox() {
        return this.mailbox;
    }

    public int getLoad() {
        return this.poller.getLoad();
    }

    @Override
    public void inEvent() {
        Command cmd;
        while ((cmd = this.mailbox.recv(0L)) != null) {
            cmd.process();
        }
    }

    Poller getPoller() {
        assert (this.poller != null);
        return this.poller;
    }

    @Override
    protected void processStop() {
        this.poller.removeHandle(this.mailboxHandle);
        this.poller.stop();
    }
}

