/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.zmq.socket.reqrep;

import org.dflib.jjava.shaded.zmq.Ctx;
import org.dflib.jjava.shaded.zmq.Msg;
import org.dflib.jjava.shaded.zmq.Options;
import org.dflib.jjava.shaded.zmq.SocketBase;
import org.dflib.jjava.shaded.zmq.io.IOThread;
import org.dflib.jjava.shaded.zmq.io.SessionBase;
import org.dflib.jjava.shaded.zmq.io.net.Address;
import org.dflib.jjava.shaded.zmq.pipe.Pipe;
import org.dflib.jjava.shaded.zmq.socket.reqrep.Dealer;
import org.dflib.jjava.shaded.zmq.util.Utils;
import org.dflib.jjava.shaded.zmq.util.ValueReference;
import org.dflib.jjava.shaded.zmq.util.Wire;

public class Req
extends Dealer {
    private boolean receivingReply = false;
    private boolean messageBegins = true;
    private final ValueReference<Pipe> replyPipe = new ValueReference();
    private boolean requestIdFramesEnabled;
    private int requestId;
    private boolean strict;

    public Req(Ctx parent, int tid, int sid) {
        super(parent, tid, sid);
        this.options.type = 3;
        this.options.canSendHelloMsg = false;
        this.requestIdFramesEnabled = false;
        this.requestId = Utils.randomInt();
        this.strict = true;
    }

    @Override
    public boolean xsend(Msg msg) {
        boolean rc;
        if (this.receivingReply) {
            if (this.strict) {
                this.errno.set(156384763);
                return false;
            }
            this.receivingReply = false;
            this.messageBegins = true;
        }
        if (this.messageBegins) {
            Msg drop;
            this.replyPipe.set(null);
            if (this.requestIdFramesEnabled) {
                ++this.requestId;
                Msg id = new Msg(4);
                Wire.putUInt32(id.buf(), this.requestId);
                id.setFlags(1);
                rc = super.sendpipe(id, this.replyPipe);
                if (!rc) {
                    return false;
                }
            }
            Msg bottom = new Msg();
            bottom.setFlags(1);
            rc = super.sendpipe(bottom, this.replyPipe);
            if (!rc) {
                return false;
            }
            assert (this.replyPipe.get() != null);
            this.messageBegins = false;
            while ((drop = super.xrecv()) != null) {
            }
        }
        boolean more = msg.hasMore();
        rc = super.xsend(msg);
        if (!rc) {
            return false;
        }
        if (!more) {
            this.receivingReply = true;
            this.messageBegins = true;
        }
        return true;
    }

    @Override
    protected Msg xrecv() {
        Msg msg;
        if (!this.receivingReply) {
            this.errno.set(156384763);
            return null;
        }
        while (this.messageBegins) {
            if (this.requestIdFramesEnabled) {
                msg = this.recvReplyPipe();
                if (msg == null) {
                    return null;
                }
                if (!msg.hasMore() || msg.size() != 4 || msg.getInt(0) != this.requestId) {
                    while (msg.hasMore()) {
                        msg = this.recvReplyPipe();
                        assert (msg != null);
                    }
                    continue;
                }
            }
            if ((msg = this.recvReplyPipe()) == null) {
                return null;
            }
            if (!msg.hasMore() || msg.size() != 0) {
                while (msg.hasMore()) {
                    msg = this.recvReplyPipe();
                    assert (msg != null);
                }
                continue;
            }
            this.messageBegins = false;
        }
        msg = this.recvReplyPipe();
        if (msg == null) {
            return null;
        }
        if (!msg.hasMore()) {
            this.receivingReply = false;
            this.messageBegins = true;
        }
        return msg;
    }

    @Override
    public boolean xhasIn() {
        return this.receivingReply && super.xhasIn();
    }

    @Override
    public boolean xhasOut() {
        return !this.receivingReply && super.xhasOut();
    }

    @Override
    protected boolean xsetsockopt(int option, Object optval) {
        switch (option) {
            case 52: {
                this.requestIdFramesEnabled = Options.parseBoolean(option, optval);
                return true;
            }
            case 53: {
                this.strict = !Options.parseBoolean(option, optval);
                return true;
            }
        }
        return super.xsetsockopt(option, optval);
    }

    @Override
    protected void xpipeTerminated(Pipe pipe) {
        if (this.replyPipe.get() == pipe) {
            this.replyPipe.set(null);
        }
        super.xpipeTerminated(pipe);
    }

    private Msg recvReplyPipe() {
        Msg msg;
        ValueReference<Pipe> pipe;
        do {
            if ((msg = super.recvpipe(pipe = new ValueReference<Pipe>())) != null) continue;
            return null;
        } while (this.replyPipe.get() != null && this.replyPipe.get() != pipe.get());
        return msg;
    }

    public static class ReqSession
    extends SessionBase {
        private State state = State.BOTTOM;

        public ReqSession(IOThread ioThread, boolean connect, SocketBase socket, Options options, Address addr) {
            super(ioThread, connect, socket, options, addr);
        }

        @Override
        public boolean pushMsg(Msg msg) {
            if (msg.isCommand()) {
                return true;
            }
            switch (this.state.ordinal()) {
                case 0: {
                    if (!msg.hasMore()) break;
                    if (msg.size() == 4) {
                        this.state = State.REQUEST_ID;
                        return super.pushMsg(msg);
                    }
                    if (msg.size() != 0) break;
                    this.state = State.BODY;
                    return super.pushMsg(msg);
                }
                case 1: {
                    if (!msg.hasMore() || msg.size() != 0) break;
                    this.state = State.BODY;
                    return super.pushMsg(msg);
                }
                case 2: {
                    if (msg.hasMore()) {
                        return super.pushMsg(msg);
                    }
                    if (msg.flags() != 0) break;
                    this.state = State.BOTTOM;
                    return super.pushMsg(msg);
                }
            }
            this.errno.set(14);
            return false;
        }

        @Override
        public void reset() {
            super.reset();
            this.state = State.BOTTOM;
        }

        static enum State {
            BOTTOM,
            REQUEST_ID,
            BODY;

        }
    }
}

