"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
The MIT License

Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.message
import sys
import temporalio.api.common.v1.message_pb2
import temporalio.api.enums.v1.query_pb2
import temporalio.api.enums.v1.workflow_pb2

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class WorkflowQuery(google.protobuf.message.Message):
    """See https://docs.temporal.io/docs/concepts/queries/"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    QUERY_TYPE_FIELD_NUMBER: builtins.int
    QUERY_ARGS_FIELD_NUMBER: builtins.int
    HEADER_FIELD_NUMBER: builtins.int
    query_type: builtins.str
    """The workflow-author-defined identifier of the query. Typically a function name."""
    @property
    def query_args(self) -> temporalio.api.common.v1.message_pb2.Payloads:
        """Serialized arguments that will be provided to the query handler."""
    @property
    def header(self) -> temporalio.api.common.v1.message_pb2.Header:
        """Headers that were passed by the caller of the query and copied by temporal
        server into the workflow task.
        """
    def __init__(
        self,
        *,
        query_type: builtins.str = ...,
        query_args: temporalio.api.common.v1.message_pb2.Payloads | None = ...,
        header: temporalio.api.common.v1.message_pb2.Header | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "header", b"header", "query_args", b"query_args"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "header",
            b"header",
            "query_args",
            b"query_args",
            "query_type",
            b"query_type",
        ],
    ) -> None: ...

global___WorkflowQuery = WorkflowQuery

class WorkflowQueryResult(google.protobuf.message.Message):
    """Answer to a `WorkflowQuery`"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_TYPE_FIELD_NUMBER: builtins.int
    ANSWER_FIELD_NUMBER: builtins.int
    ERROR_MESSAGE_FIELD_NUMBER: builtins.int
    result_type: temporalio.api.enums.v1.query_pb2.QueryResultType.ValueType
    """Did the query succeed or fail?"""
    @property
    def answer(self) -> temporalio.api.common.v1.message_pb2.Payloads:
        """Set when the query succeeds with the results"""
    error_message: builtins.str
    """Mutually exclusive with `answer`. Set when the query fails."""
    def __init__(
        self,
        *,
        result_type: temporalio.api.enums.v1.query_pb2.QueryResultType.ValueType = ...,
        answer: temporalio.api.common.v1.message_pb2.Payloads | None = ...,
        error_message: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["answer", b"answer"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "answer",
            b"answer",
            "error_message",
            b"error_message",
            "result_type",
            b"result_type",
        ],
    ) -> None: ...

global___WorkflowQueryResult = WorkflowQueryResult

class QueryRejected(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATUS_FIELD_NUMBER: builtins.int
    status: temporalio.api.enums.v1.workflow_pb2.WorkflowExecutionStatus.ValueType
    def __init__(
        self,
        *,
        status: temporalio.api.enums.v1.workflow_pb2.WorkflowExecutionStatus.ValueType = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["status", b"status"]
    ) -> None: ...

global___QueryRejected = QueryRejected
