"""Reference:"""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../../4-11.ipynb.

# %% auto 0
__all__ = ['entanglement_ordered_sampling_protocal']

# %% ../../4-11.ipynb 2
import torch
from ..mps.modules import MPS
from typing import Dict, Any
from tqdm.auto import tqdm

# %% ../../4-11.ipynb 3
def _remove_at(tensor: torch.Tensor, idx: int) -> torch.Tensor:
    return torch.cat([tensor[:idx], tensor[idx + 1 :]])


def entanglement_ordered_sampling_protocal(
    mps: MPS,
    select_feautre_num: int | None = None,
    progress_bar_kwargs: Dict[str, Any] = {},
) -> torch.Tensor:
    if select_feautre_num is None:
        select_feautre_num = mps.length
    else:
        assert 0 < select_feautre_num <= mps.length, (
            "select_feautre_num must be less than or equal to mps.length"
        )

    selected_feature_indices = []
    mps_feature_indices = torch.arange(mps.length)
    current_mps = mps

    for _ in tqdm(range(select_feautre_num), **progress_bar_kwargs):
        if len(mps_feature_indices) == 1:
            selected_feature_indices.append(mps_feature_indices[0].item())
        else:
            current_mps.center_orthogonalization_(0, mode="qr", normalize=True)
            oees = current_mps.entanglement_entropy_onsite_()  # (length of current mps,)
            argmax_idx = oees.argmax().item()
            # map the idx of current mps to that of the original mps
            orginal_mps_idx = mps_feature_indices[argmax_idx].item()
            selected_feature_indices.append(orginal_mps_idx)
            # do projection
            rdm = current_mps.one_body_reduced_density_matrix(
                idx=argmax_idx, do_tracing=True, inplace_mutation=True
            )
            eigvals, eigvecs = torch.linalg.eigh(rdm)
            project_to_state = eigvecs[:, eigvals.argmax()]
            current_mps = current_mps.project_one_qubit(argmax_idx, project_to_state)
            # update mapping from the idx of current mps to that of the original mps, since the current mps is projected, yielding a new mps with one less qubit
            mps_feature_indices = _remove_at(mps_feature_indices, argmax_idx)

    return torch.tensor(selected_feature_indices, dtype=torch.long, device=mps.device)
