from dataclasses import dataclass
from typing import List, Optional


@dataclass
class AffectedVersion:
    version_value: str
    operator: str


@dataclass
class Impact:
    cvss2_score: Optional[float]
    cvss2_severity: Optional[str]
    vector_string: Optional[str]
    av: Optional[str]
    ac: Optional[str]
    pr: Optional[str]
    c: Optional[str]
    i: Optional[str]
    a: Optional[str]
    ui: Optional[str]
    s: Optional[str]
    impact_score: Optional[float]
    exploitability_score: Optional[float]
    cvss3_score: Optional[float]
    cvss3_severity: Optional[str]


@dataclass
class Vulnerability:
    name: str
    cve_id: str
    cwe_id: str
    publish_date: str
    owner: str
    latest_version: str
    language: str
    description: str
    license: str
    repository_summary: str
    repo_url: str
    ochrona_severity_score: float
    found_version: str
    reason: Optional[str]
    affected_versions: List[AffectedVersion]
    references: List[str]
    impact: Impact
