/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.context;

import io.ray.api.id.ActorId;
import io.ray.api.id.JobId;
import io.ray.api.id.TaskId;
import io.ray.api.id.UniqueId;
import io.ray.api.runtimeenv.RuntimeEnv;
import io.ray.runtime.context.WorkerContext;
import io.ray.runtime.generated.Common;
import io.ray.shaded.com.google.protobuf.InvalidProtocolBufferException;
import java.nio.ByteBuffer;

public class NativeWorkerContext
implements WorkerContext {
    private ClassLoader currentClassLoader = null;

    @Override
    public UniqueId getCurrentWorkerId() {
        return UniqueId.fromByteBuffer(NativeWorkerContext.nativeGetCurrentWorkerId());
    }

    @Override
    public JobId getCurrentJobId() {
        return JobId.fromBytes(NativeWorkerContext.nativeGetCurrentJobId());
    }

    @Override
    public ActorId getCurrentActorId() {
        return ActorId.fromByteBuffer(NativeWorkerContext.nativeGetCurrentActorId());
    }

    @Override
    public Common.TaskType getCurrentTaskType() {
        return Common.TaskType.forNumber(NativeWorkerContext.nativeGetCurrentTaskType());
    }

    @Override
    public TaskId getCurrentTaskId() {
        return TaskId.fromByteBuffer(NativeWorkerContext.nativeGetCurrentTaskId());
    }

    @Override
    public Common.Address getRpcAddress() {
        try {
            return Common.Address.parseFrom(NativeWorkerContext.nativeGetRpcAddress());
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RuntimeEnv getCurrentRuntimeEnv() {
        String serialized_runtime_env = NativeWorkerContext.nativeGetSerializedRuntimeEnv();
        if (serialized_runtime_env == null) {
            return null;
        }
        return RuntimeEnv.deserialize(serialized_runtime_env);
    }

    private static native int nativeGetCurrentTaskType();

    private static native ByteBuffer nativeGetCurrentTaskId();

    private static native byte[] nativeGetCurrentJobId();

    private static native ByteBuffer nativeGetCurrentWorkerId();

    private static native ByteBuffer nativeGetCurrentActorId();

    private static native byte[] nativeGetRpcAddress();

    private static native String nativeGetSerializedRuntimeEnv();
}

