# coding: utf-8

"""
    Lambda Cloud API

    API for interacting with the Lambda GPU Cloud  # noqa: E501

    The version of the OpenAPI document: 1.4.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist, constr, validator
from lambda_cloud_client.models.instance_type import InstanceType
from lambda_cloud_client.models.region import Region

class Instance(BaseModel):
    """
    Virtual machine (VM) in Lambda Cloud
    """
    id: StrictStr = Field(..., description="Unique identifier (ID) of an instance")
    name: Optional[constr(strict=True, max_length=64, min_length=1)] = Field(None, description="User-provided name for the instance")
    ip: Optional[StrictStr] = Field(None, description="IPv4 address of the instance")
    status: StrictStr = Field(..., description="The current status of the instance")
    ssh_key_names: conlist(constr(strict=True, max_length=64)) = Field(..., description="Names of the SSH keys allowed to access the instance")
    file_system_names: conlist(StrictStr) = Field(..., description="Names of the file systems, if any, attached to the instance")
    region: Optional[Region] = None
    instance_type: Optional[InstanceType] = None
    hostname: Optional[StrictStr] = Field(None, description="Hostname assigned to this instance, which resolves to the instance's IP.")
    jupyter_token: Optional[StrictStr] = Field(None, description="Secret token used to log into the jupyter lab server hosted on the instance.")
    jupyter_url: Optional[StrictStr] = Field(None, description="URL that opens a jupyter lab notebook on the instance.")
    __properties = ["id", "name", "ip", "status", "ssh_key_names", "file_system_names", "region", "instance_type", "hostname", "jupyter_token", "jupyter_url"]

    @validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('active', 'booting', 'unhealthy', 'terminated'):
            raise ValueError("must be one of enum values ('active', 'booting', 'unhealthy', 'terminated')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Instance:
        """Create an instance of Instance from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of region
        if self.region:
            _dict['region'] = self.region.to_dict()
        # override the default output from pydantic by calling `to_dict()` of instance_type
        if self.instance_type:
            _dict['instance_type'] = self.instance_type.to_dict()
        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if ip (nullable) is None
        # and __fields_set__ contains the field
        if self.ip is None and "ip" in self.__fields_set__:
            _dict['ip'] = None

        # set to None if hostname (nullable) is None
        # and __fields_set__ contains the field
        if self.hostname is None and "hostname" in self.__fields_set__:
            _dict['hostname'] = None

        # set to None if jupyter_token (nullable) is None
        # and __fields_set__ contains the field
        if self.jupyter_token is None and "jupyter_token" in self.__fields_set__:
            _dict['jupyter_token'] = None

        # set to None if jupyter_url (nullable) is None
        # and __fields_set__ contains the field
        if self.jupyter_url is None and "jupyter_url" in self.__fields_set__:
            _dict['jupyter_url'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Instance:
        """Create an instance of Instance from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Instance.parse_obj(obj)

        _obj = Instance.parse_obj({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "ip": obj.get("ip"),
            "status": obj.get("status"),
            "ssh_key_names": obj.get("ssh_key_names"),
            "file_system_names": obj.get("file_system_names"),
            "region": Region.from_dict(obj.get("region")) if obj.get("region") is not None else None,
            "instance_type": InstanceType.from_dict(obj.get("instance_type")) if obj.get("instance_type") is not None else None,
            "hostname": obj.get("hostname"),
            "jupyter_token": obj.get("jupyter_token"),
            "jupyter_url": obj.get("jupyter_url")
        })
        return _obj

