# mypy-boto3-snowball

[![PyPI - mypy-boto3-snowball](https://img.shields.io/pypi/v/mypy-boto3-snowball.svg?color=blue)](https://pypi.org/project/mypy-boto3-snowball)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-snowball.svg?color=blue)](https://pypi.org/project/mypy-boto3-snowball)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.Snowball 1.12.14](https://boto3.amazonaws.com/v1/documentation/api/1.12.14/reference/services/snowball.html#Snowball) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.3](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-snowball](#mypy-boto3-snowball)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `Snowball` service.

```bash
python -m pip install boto3-stubs[mypy-boto3-snowball]
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import snowball
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_snowball as snowball

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("snowball")
client: snowball.SnowballClient = boto3.client("snowball")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: snowball.SnowballClient = session.client("snowball")


# Paginators need type annotation on creation
describe_addresses_paginator: snowball.DescribeAddressesPaginator = client.get_paginator("describe_addresses")
list_cluster_jobs_paginator: snowball.ListClusterJobsPaginator = client.get_paginator("list_cluster_jobs")
list_clusters_paginator: snowball.ListClustersPaginator = client.get_paginator("list_clusters")
list_compatible_images_paginator: snowball.ListCompatibleImagesPaginator = client.get_paginator("list_compatible_images")
list_jobs_paginator: snowball.ListJobsPaginator = client.get_paginator("list_jobs")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.