# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DeploymentArgs', 'Deployment']

@pulumi.input_type
class DeploymentArgs:
    def __init__(__self__, *,
                 deployment_template_id: pulumi.Input[str],
                 elasticsearch: pulumi.Input['DeploymentElasticsearchArgs'],
                 region: pulumi.Input[str],
                 version: pulumi.Input[str],
                 alias: Optional[pulumi.Input[str]] = None,
                 apm: Optional[pulumi.Input['DeploymentApmArgs']] = None,
                 enterprise_search: Optional[pulumi.Input['DeploymentEnterpriseSearchArgs']] = None,
                 integrations_server: Optional[pulumi.Input['DeploymentIntegrationsServerArgs']] = None,
                 kibana: Optional[pulumi.Input['DeploymentKibanaArgs']] = None,
                 migrate_to_latest_hardware: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 observability: Optional[pulumi.Input['DeploymentObservabilityArgs']] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 reset_elasticsearch_password: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 traffic_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Deployment resource.
        :param pulumi.Input[str] deployment_template_id: Deployment template identifier to create the deployment from. See the [full list](https://www.elastic.co/guide/en/cloud/current/ec-regions-templates-instances.html) of regions and deployment templates available in ESS.
        :param pulumi.Input['DeploymentElasticsearchArgs'] elasticsearch: Elasticsearch cluster definition
        :param pulumi.Input[str] region: Elasticsearch Service (ESS) region where the deployment should be hosted. For Elastic Cloud Enterprise (ECE) installations, set to `"ece-region".
        :param pulumi.Input[str] version: Elastic Stack version to use for all of the deployment resources.
        :param pulumi.Input[str] alias: Deployment alias, affects the format of the resource URLs.
        :param pulumi.Input['DeploymentApmArgs'] apm: **DEPRECATED** APM cluster definition. This should only be used for deployments running a version lower than 8.0
        :param pulumi.Input['DeploymentEnterpriseSearchArgs'] enterprise_search: Enterprise Search cluster definition.
        :param pulumi.Input['DeploymentIntegrationsServerArgs'] integrations_server: Integrations Server cluster definition. Integrations Server replaces `apm` in Stack versions > 8.0
        :param pulumi.Input['DeploymentKibanaArgs'] kibana: Kibana cluster definition. > **Note on disabling Kibana** While optional it is recommended deployments specify a Kibana
               block, since not doing so might cause issues when modifying or upgrading the deployment.
        :param pulumi.Input[bool] migrate_to_latest_hardware: When set to true, the deployment will be updated according to the latest deployment template values. > **Note** If the
               <code>instance_configuration_id</code> or <code>instance_configuration_version</code> fields are set for a specific
               topology element, that element will not be updated. > **Note** Hardware migrations are not supported for deployments
               with node types. To use this field, the deployment needs to be migrated to node roles first.
        :param pulumi.Input[str] name: Name for the deployment
        :param pulumi.Input['DeploymentObservabilityArgs'] observability: Observability settings that you can set to ship logs and metrics to a deployment. The target deployment can also be the
               current deployment itself by setting observability.deployment_id to `self`.
        :param pulumi.Input[str] request_id: Request ID to set when you create the deployment. Use it only when previous attempts return an error and `request_id` is
               returned as part of the error.
        :param pulumi.Input[bool] reset_elasticsearch_password: Explicitly resets the elasticsearch_password when true
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Optional map of deployment tags
        :param pulumi.Input[Sequence[pulumi.Input[str]]] traffic_filters: List of traffic filters rule identifiers that will be applied to the deployment.
        """
        pulumi.set(__self__, "deployment_template_id", deployment_template_id)
        pulumi.set(__self__, "elasticsearch", elasticsearch)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "version", version)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if apm is not None:
            pulumi.set(__self__, "apm", apm)
        if enterprise_search is not None:
            pulumi.set(__self__, "enterprise_search", enterprise_search)
        if integrations_server is not None:
            pulumi.set(__self__, "integrations_server", integrations_server)
        if kibana is not None:
            pulumi.set(__self__, "kibana", kibana)
        if migrate_to_latest_hardware is not None:
            pulumi.set(__self__, "migrate_to_latest_hardware", migrate_to_latest_hardware)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if observability is not None:
            pulumi.set(__self__, "observability", observability)
        if request_id is not None:
            pulumi.set(__self__, "request_id", request_id)
        if reset_elasticsearch_password is not None:
            pulumi.set(__self__, "reset_elasticsearch_password", reset_elasticsearch_password)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if traffic_filters is not None:
            pulumi.set(__self__, "traffic_filters", traffic_filters)

    @property
    @pulumi.getter(name="deploymentTemplateId")
    def deployment_template_id(self) -> pulumi.Input[str]:
        """
        Deployment template identifier to create the deployment from. See the [full list](https://www.elastic.co/guide/en/cloud/current/ec-regions-templates-instances.html) of regions and deployment templates available in ESS.
        """
        return pulumi.get(self, "deployment_template_id")

    @deployment_template_id.setter
    def deployment_template_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_template_id", value)

    @property
    @pulumi.getter
    def elasticsearch(self) -> pulumi.Input['DeploymentElasticsearchArgs']:
        """
        Elasticsearch cluster definition
        """
        return pulumi.get(self, "elasticsearch")

    @elasticsearch.setter
    def elasticsearch(self, value: pulumi.Input['DeploymentElasticsearchArgs']):
        pulumi.set(self, "elasticsearch", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        Elasticsearch Service (ESS) region where the deployment should be hosted. For Elastic Cloud Enterprise (ECE) installations, set to `"ece-region".
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        Elastic Stack version to use for all of the deployment resources.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        """
        Deployment alias, affects the format of the resource URLs.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter
    def apm(self) -> Optional[pulumi.Input['DeploymentApmArgs']]:
        """
        **DEPRECATED** APM cluster definition. This should only be used for deployments running a version lower than 8.0
        """
        return pulumi.get(self, "apm")

    @apm.setter
    def apm(self, value: Optional[pulumi.Input['DeploymentApmArgs']]):
        pulumi.set(self, "apm", value)

    @property
    @pulumi.getter(name="enterpriseSearch")
    def enterprise_search(self) -> Optional[pulumi.Input['DeploymentEnterpriseSearchArgs']]:
        """
        Enterprise Search cluster definition.
        """
        return pulumi.get(self, "enterprise_search")

    @enterprise_search.setter
    def enterprise_search(self, value: Optional[pulumi.Input['DeploymentEnterpriseSearchArgs']]):
        pulumi.set(self, "enterprise_search", value)

    @property
    @pulumi.getter(name="integrationsServer")
    def integrations_server(self) -> Optional[pulumi.Input['DeploymentIntegrationsServerArgs']]:
        """
        Integrations Server cluster definition. Integrations Server replaces `apm` in Stack versions > 8.0
        """
        return pulumi.get(self, "integrations_server")

    @integrations_server.setter
    def integrations_server(self, value: Optional[pulumi.Input['DeploymentIntegrationsServerArgs']]):
        pulumi.set(self, "integrations_server", value)

    @property
    @pulumi.getter
    def kibana(self) -> Optional[pulumi.Input['DeploymentKibanaArgs']]:
        """
        Kibana cluster definition. > **Note on disabling Kibana** While optional it is recommended deployments specify a Kibana
        block, since not doing so might cause issues when modifying or upgrading the deployment.
        """
        return pulumi.get(self, "kibana")

    @kibana.setter
    def kibana(self, value: Optional[pulumi.Input['DeploymentKibanaArgs']]):
        pulumi.set(self, "kibana", value)

    @property
    @pulumi.getter(name="migrateToLatestHardware")
    def migrate_to_latest_hardware(self) -> Optional[pulumi.Input[bool]]:
        """
        When set to true, the deployment will be updated according to the latest deployment template values. > **Note** If the
        <code>instance_configuration_id</code> or <code>instance_configuration_version</code> fields are set for a specific
        topology element, that element will not be updated. > **Note** Hardware migrations are not supported for deployments
        with node types. To use this field, the deployment needs to be migrated to node roles first.
        """
        return pulumi.get(self, "migrate_to_latest_hardware")

    @migrate_to_latest_hardware.setter
    def migrate_to_latest_hardware(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "migrate_to_latest_hardware", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for the deployment
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def observability(self) -> Optional[pulumi.Input['DeploymentObservabilityArgs']]:
        """
        Observability settings that you can set to ship logs and metrics to a deployment. The target deployment can also be the
        current deployment itself by setting observability.deployment_id to `self`.
        """
        return pulumi.get(self, "observability")

    @observability.setter
    def observability(self, value: Optional[pulumi.Input['DeploymentObservabilityArgs']]):
        pulumi.set(self, "observability", value)

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> Optional[pulumi.Input[str]]:
        """
        Request ID to set when you create the deployment. Use it only when previous attempts return an error and `request_id` is
        returned as part of the error.
        """
        return pulumi.get(self, "request_id")

    @request_id.setter
    def request_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_id", value)

    @property
    @pulumi.getter(name="resetElasticsearchPassword")
    def reset_elasticsearch_password(self) -> Optional[pulumi.Input[bool]]:
        """
        Explicitly resets the elasticsearch_password when true
        """
        return pulumi.get(self, "reset_elasticsearch_password")

    @reset_elasticsearch_password.setter
    def reset_elasticsearch_password(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reset_elasticsearch_password", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional map of deployment tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="trafficFilters")
    def traffic_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of traffic filters rule identifiers that will be applied to the deployment.
        """
        return pulumi.get(self, "traffic_filters")

    @traffic_filters.setter
    def traffic_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "traffic_filters", value)


@pulumi.input_type
class _DeploymentState:
    def __init__(__self__, *,
                 alias: Optional[pulumi.Input[str]] = None,
                 apm: Optional[pulumi.Input['DeploymentApmArgs']] = None,
                 apm_secret_token: Optional[pulumi.Input[str]] = None,
                 deployment_template_id: Optional[pulumi.Input[str]] = None,
                 elasticsearch: Optional[pulumi.Input['DeploymentElasticsearchArgs']] = None,
                 elasticsearch_password: Optional[pulumi.Input[str]] = None,
                 elasticsearch_username: Optional[pulumi.Input[str]] = None,
                 enterprise_search: Optional[pulumi.Input['DeploymentEnterpriseSearchArgs']] = None,
                 integrations_server: Optional[pulumi.Input['DeploymentIntegrationsServerArgs']] = None,
                 kibana: Optional[pulumi.Input['DeploymentKibanaArgs']] = None,
                 migrate_to_latest_hardware: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 observability: Optional[pulumi.Input['DeploymentObservabilityArgs']] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 reset_elasticsearch_password: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 traffic_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Deployment resources.
        :param pulumi.Input[str] alias: Deployment alias, affects the format of the resource URLs.
        :param pulumi.Input['DeploymentApmArgs'] apm: **DEPRECATED** APM cluster definition. This should only be used for deployments running a version lower than 8.0
        :param pulumi.Input[str] deployment_template_id: Deployment template identifier to create the deployment from. See the [full list](https://www.elastic.co/guide/en/cloud/current/ec-regions-templates-instances.html) of regions and deployment templates available in ESS.
        :param pulumi.Input['DeploymentElasticsearchArgs'] elasticsearch: Elasticsearch cluster definition
        :param pulumi.Input[str] elasticsearch_username: Username for authenticating to the Elasticsearch resource.
        :param pulumi.Input['DeploymentEnterpriseSearchArgs'] enterprise_search: Enterprise Search cluster definition.
        :param pulumi.Input['DeploymentIntegrationsServerArgs'] integrations_server: Integrations Server cluster definition. Integrations Server replaces `apm` in Stack versions > 8.0
        :param pulumi.Input['DeploymentKibanaArgs'] kibana: Kibana cluster definition. > **Note on disabling Kibana** While optional it is recommended deployments specify a Kibana
               block, since not doing so might cause issues when modifying or upgrading the deployment.
        :param pulumi.Input[bool] migrate_to_latest_hardware: When set to true, the deployment will be updated according to the latest deployment template values. > **Note** If the
               <code>instance_configuration_id</code> or <code>instance_configuration_version</code> fields are set for a specific
               topology element, that element will not be updated. > **Note** Hardware migrations are not supported for deployments
               with node types. To use this field, the deployment needs to be migrated to node roles first.
        :param pulumi.Input[str] name: Name for the deployment
        :param pulumi.Input['DeploymentObservabilityArgs'] observability: Observability settings that you can set to ship logs and metrics to a deployment. The target deployment can also be the
               current deployment itself by setting observability.deployment_id to `self`.
        :param pulumi.Input[str] region: Elasticsearch Service (ESS) region where the deployment should be hosted. For Elastic Cloud Enterprise (ECE) installations, set to `"ece-region".
        :param pulumi.Input[str] request_id: Request ID to set when you create the deployment. Use it only when previous attempts return an error and `request_id` is
               returned as part of the error.
        :param pulumi.Input[bool] reset_elasticsearch_password: Explicitly resets the elasticsearch_password when true
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Optional map of deployment tags
        :param pulumi.Input[Sequence[pulumi.Input[str]]] traffic_filters: List of traffic filters rule identifiers that will be applied to the deployment.
        :param pulumi.Input[str] version: Elastic Stack version to use for all of the deployment resources.
        """
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if apm is not None:
            pulumi.set(__self__, "apm", apm)
        if apm_secret_token is not None:
            pulumi.set(__self__, "apm_secret_token", apm_secret_token)
        if deployment_template_id is not None:
            pulumi.set(__self__, "deployment_template_id", deployment_template_id)
        if elasticsearch is not None:
            pulumi.set(__self__, "elasticsearch", elasticsearch)
        if elasticsearch_password is not None:
            pulumi.set(__self__, "elasticsearch_password", elasticsearch_password)
        if elasticsearch_username is not None:
            pulumi.set(__self__, "elasticsearch_username", elasticsearch_username)
        if enterprise_search is not None:
            pulumi.set(__self__, "enterprise_search", enterprise_search)
        if integrations_server is not None:
            pulumi.set(__self__, "integrations_server", integrations_server)
        if kibana is not None:
            pulumi.set(__self__, "kibana", kibana)
        if migrate_to_latest_hardware is not None:
            pulumi.set(__self__, "migrate_to_latest_hardware", migrate_to_latest_hardware)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if observability is not None:
            pulumi.set(__self__, "observability", observability)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if request_id is not None:
            pulumi.set(__self__, "request_id", request_id)
        if reset_elasticsearch_password is not None:
            pulumi.set(__self__, "reset_elasticsearch_password", reset_elasticsearch_password)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if traffic_filters is not None:
            pulumi.set(__self__, "traffic_filters", traffic_filters)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        """
        Deployment alias, affects the format of the resource URLs.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter
    def apm(self) -> Optional[pulumi.Input['DeploymentApmArgs']]:
        """
        **DEPRECATED** APM cluster definition. This should only be used for deployments running a version lower than 8.0
        """
        return pulumi.get(self, "apm")

    @apm.setter
    def apm(self, value: Optional[pulumi.Input['DeploymentApmArgs']]):
        pulumi.set(self, "apm", value)

    @property
    @pulumi.getter(name="apmSecretToken")
    def apm_secret_token(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "apm_secret_token")

    @apm_secret_token.setter
    def apm_secret_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "apm_secret_token", value)

    @property
    @pulumi.getter(name="deploymentTemplateId")
    def deployment_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        Deployment template identifier to create the deployment from. See the [full list](https://www.elastic.co/guide/en/cloud/current/ec-regions-templates-instances.html) of regions and deployment templates available in ESS.
        """
        return pulumi.get(self, "deployment_template_id")

    @deployment_template_id.setter
    def deployment_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_template_id", value)

    @property
    @pulumi.getter
    def elasticsearch(self) -> Optional[pulumi.Input['DeploymentElasticsearchArgs']]:
        """
        Elasticsearch cluster definition
        """
        return pulumi.get(self, "elasticsearch")

    @elasticsearch.setter
    def elasticsearch(self, value: Optional[pulumi.Input['DeploymentElasticsearchArgs']]):
        pulumi.set(self, "elasticsearch", value)

    @property
    @pulumi.getter(name="elasticsearchPassword")
    def elasticsearch_password(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "elasticsearch_password")

    @elasticsearch_password.setter
    def elasticsearch_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elasticsearch_password", value)

    @property
    @pulumi.getter(name="elasticsearchUsername")
    def elasticsearch_username(self) -> Optional[pulumi.Input[str]]:
        """
        Username for authenticating to the Elasticsearch resource.
        """
        return pulumi.get(self, "elasticsearch_username")

    @elasticsearch_username.setter
    def elasticsearch_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elasticsearch_username", value)

    @property
    @pulumi.getter(name="enterpriseSearch")
    def enterprise_search(self) -> Optional[pulumi.Input['DeploymentEnterpriseSearchArgs']]:
        """
        Enterprise Search cluster definition.
        """
        return pulumi.get(self, "enterprise_search")

    @enterprise_search.setter
    def enterprise_search(self, value: Optional[pulumi.Input['DeploymentEnterpriseSearchArgs']]):
        pulumi.set(self, "enterprise_search", value)

    @property
    @pulumi.getter(name="integrationsServer")
    def integrations_server(self) -> Optional[pulumi.Input['DeploymentIntegrationsServerArgs']]:
        """
        Integrations Server cluster definition. Integrations Server replaces `apm` in Stack versions > 8.0
        """
        return pulumi.get(self, "integrations_server")

    @integrations_server.setter
    def integrations_server(self, value: Optional[pulumi.Input['DeploymentIntegrationsServerArgs']]):
        pulumi.set(self, "integrations_server", value)

    @property
    @pulumi.getter
    def kibana(self) -> Optional[pulumi.Input['DeploymentKibanaArgs']]:
        """
        Kibana cluster definition. > **Note on disabling Kibana** While optional it is recommended deployments specify a Kibana
        block, since not doing so might cause issues when modifying or upgrading the deployment.
        """
        return pulumi.get(self, "kibana")

    @kibana.setter
    def kibana(self, value: Optional[pulumi.Input['DeploymentKibanaArgs']]):
        pulumi.set(self, "kibana", value)

    @property
    @pulumi.getter(name="migrateToLatestHardware")
    def migrate_to_latest_hardware(self) -> Optional[pulumi.Input[bool]]:
        """
        When set to true, the deployment will be updated according to the latest deployment template values. > **Note** If the
        <code>instance_configuration_id</code> or <code>instance_configuration_version</code> fields are set for a specific
        topology element, that element will not be updated. > **Note** Hardware migrations are not supported for deployments
        with node types. To use this field, the deployment needs to be migrated to node roles first.
        """
        return pulumi.get(self, "migrate_to_latest_hardware")

    @migrate_to_latest_hardware.setter
    def migrate_to_latest_hardware(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "migrate_to_latest_hardware", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for the deployment
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def observability(self) -> Optional[pulumi.Input['DeploymentObservabilityArgs']]:
        """
        Observability settings that you can set to ship logs and metrics to a deployment. The target deployment can also be the
        current deployment itself by setting observability.deployment_id to `self`.
        """
        return pulumi.get(self, "observability")

    @observability.setter
    def observability(self, value: Optional[pulumi.Input['DeploymentObservabilityArgs']]):
        pulumi.set(self, "observability", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Elasticsearch Service (ESS) region where the deployment should be hosted. For Elastic Cloud Enterprise (ECE) installations, set to `"ece-region".
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> Optional[pulumi.Input[str]]:
        """
        Request ID to set when you create the deployment. Use it only when previous attempts return an error and `request_id` is
        returned as part of the error.
        """
        return pulumi.get(self, "request_id")

    @request_id.setter
    def request_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_id", value)

    @property
    @pulumi.getter(name="resetElasticsearchPassword")
    def reset_elasticsearch_password(self) -> Optional[pulumi.Input[bool]]:
        """
        Explicitly resets the elasticsearch_password when true
        """
        return pulumi.get(self, "reset_elasticsearch_password")

    @reset_elasticsearch_password.setter
    def reset_elasticsearch_password(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reset_elasticsearch_password", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional map of deployment tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="trafficFilters")
    def traffic_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of traffic filters rule identifiers that will be applied to the deployment.
        """
        return pulumi.get(self, "traffic_filters")

    @traffic_filters.setter
    def traffic_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "traffic_filters", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Elastic Stack version to use for all of the deployment resources.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class Deployment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[str]] = None,
                 apm: Optional[pulumi.Input[Union['DeploymentApmArgs', 'DeploymentApmArgsDict']]] = None,
                 deployment_template_id: Optional[pulumi.Input[str]] = None,
                 elasticsearch: Optional[pulumi.Input[Union['DeploymentElasticsearchArgs', 'DeploymentElasticsearchArgsDict']]] = None,
                 enterprise_search: Optional[pulumi.Input[Union['DeploymentEnterpriseSearchArgs', 'DeploymentEnterpriseSearchArgsDict']]] = None,
                 integrations_server: Optional[pulumi.Input[Union['DeploymentIntegrationsServerArgs', 'DeploymentIntegrationsServerArgsDict']]] = None,
                 kibana: Optional[pulumi.Input[Union['DeploymentKibanaArgs', 'DeploymentKibanaArgsDict']]] = None,
                 migrate_to_latest_hardware: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 observability: Optional[pulumi.Input[Union['DeploymentObservabilityArgs', 'DeploymentObservabilityArgsDict']]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 reset_elasticsearch_password: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 traffic_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Basic

        ### With config

        `es.yaml`

        `deployment.tf`:

        ### With autoscaling

        ### With observability

        It is possible to enable observability without using a second deployment, by storing the observability data in the current deployment. To enable this, set `deployment_id` to `self`.

        ### With Cross Cluster Search settings

        ### With Keystore

        ## Import

        ~> **Note on deployment credentials** The `elastic` user credentials are only available whilst creating a deployment. Importing a deployment will not import the `elasticsearch_username` or `elasticsearch_password` attributes.

        ~> **Note on legacy (pre-slider) deployments** Importing deployments created prior to the addition of sliders in ECE or ESS, without being migrated to use sliders, is not supported.

        ~> **Note on pre 6.6.0 deployments** Importing deployments with a version lower than `6.6.0` is not supported.

        ~> **Note on deployments with topology user settings** Only deployments with global user settings (config) are supported. Make sure to migrate to global settings before importing.

        Deployments can be imported using the `id`, for example:

        ```sh
        $ pulumi import ec:index/deployment:Deployment search 320b7b540dfc967a7a649c18e2fce4ed
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alias: Deployment alias, affects the format of the resource URLs.
        :param pulumi.Input[Union['DeploymentApmArgs', 'DeploymentApmArgsDict']] apm: **DEPRECATED** APM cluster definition. This should only be used for deployments running a version lower than 8.0
        :param pulumi.Input[str] deployment_template_id: Deployment template identifier to create the deployment from. See the [full list](https://www.elastic.co/guide/en/cloud/current/ec-regions-templates-instances.html) of regions and deployment templates available in ESS.
        :param pulumi.Input[Union['DeploymentElasticsearchArgs', 'DeploymentElasticsearchArgsDict']] elasticsearch: Elasticsearch cluster definition
        :param pulumi.Input[Union['DeploymentEnterpriseSearchArgs', 'DeploymentEnterpriseSearchArgsDict']] enterprise_search: Enterprise Search cluster definition.
        :param pulumi.Input[Union['DeploymentIntegrationsServerArgs', 'DeploymentIntegrationsServerArgsDict']] integrations_server: Integrations Server cluster definition. Integrations Server replaces `apm` in Stack versions > 8.0
        :param pulumi.Input[Union['DeploymentKibanaArgs', 'DeploymentKibanaArgsDict']] kibana: Kibana cluster definition. > **Note on disabling Kibana** While optional it is recommended deployments specify a Kibana
               block, since not doing so might cause issues when modifying or upgrading the deployment.
        :param pulumi.Input[bool] migrate_to_latest_hardware: When set to true, the deployment will be updated according to the latest deployment template values. > **Note** If the
               <code>instance_configuration_id</code> or <code>instance_configuration_version</code> fields are set for a specific
               topology element, that element will not be updated. > **Note** Hardware migrations are not supported for deployments
               with node types. To use this field, the deployment needs to be migrated to node roles first.
        :param pulumi.Input[str] name: Name for the deployment
        :param pulumi.Input[Union['DeploymentObservabilityArgs', 'DeploymentObservabilityArgsDict']] observability: Observability settings that you can set to ship logs and metrics to a deployment. The target deployment can also be the
               current deployment itself by setting observability.deployment_id to `self`.
        :param pulumi.Input[str] region: Elasticsearch Service (ESS) region where the deployment should be hosted. For Elastic Cloud Enterprise (ECE) installations, set to `"ece-region".
        :param pulumi.Input[str] request_id: Request ID to set when you create the deployment. Use it only when previous attempts return an error and `request_id` is
               returned as part of the error.
        :param pulumi.Input[bool] reset_elasticsearch_password: Explicitly resets the elasticsearch_password when true
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Optional map of deployment tags
        :param pulumi.Input[Sequence[pulumi.Input[str]]] traffic_filters: List of traffic filters rule identifiers that will be applied to the deployment.
        :param pulumi.Input[str] version: Elastic Stack version to use for all of the deployment resources.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Basic

        ### With config

        `es.yaml`

        `deployment.tf`:

        ### With autoscaling

        ### With observability

        It is possible to enable observability without using a second deployment, by storing the observability data in the current deployment. To enable this, set `deployment_id` to `self`.

        ### With Cross Cluster Search settings

        ### With Keystore

        ## Import

        ~> **Note on deployment credentials** The `elastic` user credentials are only available whilst creating a deployment. Importing a deployment will not import the `elasticsearch_username` or `elasticsearch_password` attributes.

        ~> **Note on legacy (pre-slider) deployments** Importing deployments created prior to the addition of sliders in ECE or ESS, without being migrated to use sliders, is not supported.

        ~> **Note on pre 6.6.0 deployments** Importing deployments with a version lower than `6.6.0` is not supported.

        ~> **Note on deployments with topology user settings** Only deployments with global user settings (config) are supported. Make sure to migrate to global settings before importing.

        Deployments can be imported using the `id`, for example:

        ```sh
        $ pulumi import ec:index/deployment:Deployment search 320b7b540dfc967a7a649c18e2fce4ed
        ```

        :param str resource_name: The name of the resource.
        :param DeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[str]] = None,
                 apm: Optional[pulumi.Input[Union['DeploymentApmArgs', 'DeploymentApmArgsDict']]] = None,
                 deployment_template_id: Optional[pulumi.Input[str]] = None,
                 elasticsearch: Optional[pulumi.Input[Union['DeploymentElasticsearchArgs', 'DeploymentElasticsearchArgsDict']]] = None,
                 enterprise_search: Optional[pulumi.Input[Union['DeploymentEnterpriseSearchArgs', 'DeploymentEnterpriseSearchArgsDict']]] = None,
                 integrations_server: Optional[pulumi.Input[Union['DeploymentIntegrationsServerArgs', 'DeploymentIntegrationsServerArgsDict']]] = None,
                 kibana: Optional[pulumi.Input[Union['DeploymentKibanaArgs', 'DeploymentKibanaArgsDict']]] = None,
                 migrate_to_latest_hardware: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 observability: Optional[pulumi.Input[Union['DeploymentObservabilityArgs', 'DeploymentObservabilityArgsDict']]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 reset_elasticsearch_password: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 traffic_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeploymentArgs.__new__(DeploymentArgs)

            __props__.__dict__["alias"] = alias
            __props__.__dict__["apm"] = apm
            if deployment_template_id is None and not opts.urn:
                raise TypeError("Missing required property 'deployment_template_id'")
            __props__.__dict__["deployment_template_id"] = deployment_template_id
            if elasticsearch is None and not opts.urn:
                raise TypeError("Missing required property 'elasticsearch'")
            __props__.__dict__["elasticsearch"] = elasticsearch
            __props__.__dict__["enterprise_search"] = enterprise_search
            __props__.__dict__["integrations_server"] = integrations_server
            __props__.__dict__["kibana"] = kibana
            __props__.__dict__["migrate_to_latest_hardware"] = migrate_to_latest_hardware
            __props__.__dict__["name"] = name
            __props__.__dict__["observability"] = observability
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["request_id"] = request_id
            __props__.__dict__["reset_elasticsearch_password"] = reset_elasticsearch_password
            __props__.__dict__["tags"] = tags
            __props__.__dict__["traffic_filters"] = traffic_filters
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["apm_secret_token"] = None
            __props__.__dict__["elasticsearch_password"] = None
            __props__.__dict__["elasticsearch_username"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apmSecretToken", "elasticsearchPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Deployment, __self__).__init__(
            'ec:index/deployment:Deployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alias: Optional[pulumi.Input[str]] = None,
            apm: Optional[pulumi.Input[Union['DeploymentApmArgs', 'DeploymentApmArgsDict']]] = None,
            apm_secret_token: Optional[pulumi.Input[str]] = None,
            deployment_template_id: Optional[pulumi.Input[str]] = None,
            elasticsearch: Optional[pulumi.Input[Union['DeploymentElasticsearchArgs', 'DeploymentElasticsearchArgsDict']]] = None,
            elasticsearch_password: Optional[pulumi.Input[str]] = None,
            elasticsearch_username: Optional[pulumi.Input[str]] = None,
            enterprise_search: Optional[pulumi.Input[Union['DeploymentEnterpriseSearchArgs', 'DeploymentEnterpriseSearchArgsDict']]] = None,
            integrations_server: Optional[pulumi.Input[Union['DeploymentIntegrationsServerArgs', 'DeploymentIntegrationsServerArgsDict']]] = None,
            kibana: Optional[pulumi.Input[Union['DeploymentKibanaArgs', 'DeploymentKibanaArgsDict']]] = None,
            migrate_to_latest_hardware: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            observability: Optional[pulumi.Input[Union['DeploymentObservabilityArgs', 'DeploymentObservabilityArgsDict']]] = None,
            region: Optional[pulumi.Input[str]] = None,
            request_id: Optional[pulumi.Input[str]] = None,
            reset_elasticsearch_password: Optional[pulumi.Input[bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            traffic_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'Deployment':
        """
        Get an existing Deployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alias: Deployment alias, affects the format of the resource URLs.
        :param pulumi.Input[Union['DeploymentApmArgs', 'DeploymentApmArgsDict']] apm: **DEPRECATED** APM cluster definition. This should only be used for deployments running a version lower than 8.0
        :param pulumi.Input[str] deployment_template_id: Deployment template identifier to create the deployment from. See the [full list](https://www.elastic.co/guide/en/cloud/current/ec-regions-templates-instances.html) of regions and deployment templates available in ESS.
        :param pulumi.Input[Union['DeploymentElasticsearchArgs', 'DeploymentElasticsearchArgsDict']] elasticsearch: Elasticsearch cluster definition
        :param pulumi.Input[str] elasticsearch_username: Username for authenticating to the Elasticsearch resource.
        :param pulumi.Input[Union['DeploymentEnterpriseSearchArgs', 'DeploymentEnterpriseSearchArgsDict']] enterprise_search: Enterprise Search cluster definition.
        :param pulumi.Input[Union['DeploymentIntegrationsServerArgs', 'DeploymentIntegrationsServerArgsDict']] integrations_server: Integrations Server cluster definition. Integrations Server replaces `apm` in Stack versions > 8.0
        :param pulumi.Input[Union['DeploymentKibanaArgs', 'DeploymentKibanaArgsDict']] kibana: Kibana cluster definition. > **Note on disabling Kibana** While optional it is recommended deployments specify a Kibana
               block, since not doing so might cause issues when modifying or upgrading the deployment.
        :param pulumi.Input[bool] migrate_to_latest_hardware: When set to true, the deployment will be updated according to the latest deployment template values. > **Note** If the
               <code>instance_configuration_id</code> or <code>instance_configuration_version</code> fields are set for a specific
               topology element, that element will not be updated. > **Note** Hardware migrations are not supported for deployments
               with node types. To use this field, the deployment needs to be migrated to node roles first.
        :param pulumi.Input[str] name: Name for the deployment
        :param pulumi.Input[Union['DeploymentObservabilityArgs', 'DeploymentObservabilityArgsDict']] observability: Observability settings that you can set to ship logs and metrics to a deployment. The target deployment can also be the
               current deployment itself by setting observability.deployment_id to `self`.
        :param pulumi.Input[str] region: Elasticsearch Service (ESS) region where the deployment should be hosted. For Elastic Cloud Enterprise (ECE) installations, set to `"ece-region".
        :param pulumi.Input[str] request_id: Request ID to set when you create the deployment. Use it only when previous attempts return an error and `request_id` is
               returned as part of the error.
        :param pulumi.Input[bool] reset_elasticsearch_password: Explicitly resets the elasticsearch_password when true
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Optional map of deployment tags
        :param pulumi.Input[Sequence[pulumi.Input[str]]] traffic_filters: List of traffic filters rule identifiers that will be applied to the deployment.
        :param pulumi.Input[str] version: Elastic Stack version to use for all of the deployment resources.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeploymentState.__new__(_DeploymentState)

        __props__.__dict__["alias"] = alias
        __props__.__dict__["apm"] = apm
        __props__.__dict__["apm_secret_token"] = apm_secret_token
        __props__.__dict__["deployment_template_id"] = deployment_template_id
        __props__.__dict__["elasticsearch"] = elasticsearch
        __props__.__dict__["elasticsearch_password"] = elasticsearch_password
        __props__.__dict__["elasticsearch_username"] = elasticsearch_username
        __props__.__dict__["enterprise_search"] = enterprise_search
        __props__.__dict__["integrations_server"] = integrations_server
        __props__.__dict__["kibana"] = kibana
        __props__.__dict__["migrate_to_latest_hardware"] = migrate_to_latest_hardware
        __props__.__dict__["name"] = name
        __props__.__dict__["observability"] = observability
        __props__.__dict__["region"] = region
        __props__.__dict__["request_id"] = request_id
        __props__.__dict__["reset_elasticsearch_password"] = reset_elasticsearch_password
        __props__.__dict__["tags"] = tags
        __props__.__dict__["traffic_filters"] = traffic_filters
        __props__.__dict__["version"] = version
        return Deployment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def alias(self) -> pulumi.Output[str]:
        """
        Deployment alias, affects the format of the resource URLs.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter
    def apm(self) -> pulumi.Output[Optional['outputs.DeploymentApm']]:
        """
        **DEPRECATED** APM cluster definition. This should only be used for deployments running a version lower than 8.0
        """
        return pulumi.get(self, "apm")

    @property
    @pulumi.getter(name="apmSecretToken")
    def apm_secret_token(self) -> pulumi.Output[str]:
        return pulumi.get(self, "apm_secret_token")

    @property
    @pulumi.getter(name="deploymentTemplateId")
    def deployment_template_id(self) -> pulumi.Output[str]:
        """
        Deployment template identifier to create the deployment from. See the [full list](https://www.elastic.co/guide/en/cloud/current/ec-regions-templates-instances.html) of regions and deployment templates available in ESS.
        """
        return pulumi.get(self, "deployment_template_id")

    @property
    @pulumi.getter
    def elasticsearch(self) -> pulumi.Output['outputs.DeploymentElasticsearch']:
        """
        Elasticsearch cluster definition
        """
        return pulumi.get(self, "elasticsearch")

    @property
    @pulumi.getter(name="elasticsearchPassword")
    def elasticsearch_password(self) -> pulumi.Output[str]:
        return pulumi.get(self, "elasticsearch_password")

    @property
    @pulumi.getter(name="elasticsearchUsername")
    def elasticsearch_username(self) -> pulumi.Output[str]:
        """
        Username for authenticating to the Elasticsearch resource.
        """
        return pulumi.get(self, "elasticsearch_username")

    @property
    @pulumi.getter(name="enterpriseSearch")
    def enterprise_search(self) -> pulumi.Output[Optional['outputs.DeploymentEnterpriseSearch']]:
        """
        Enterprise Search cluster definition.
        """
        return pulumi.get(self, "enterprise_search")

    @property
    @pulumi.getter(name="integrationsServer")
    def integrations_server(self) -> pulumi.Output[Optional['outputs.DeploymentIntegrationsServer']]:
        """
        Integrations Server cluster definition. Integrations Server replaces `apm` in Stack versions > 8.0
        """
        return pulumi.get(self, "integrations_server")

    @property
    @pulumi.getter
    def kibana(self) -> pulumi.Output[Optional['outputs.DeploymentKibana']]:
        """
        Kibana cluster definition. > **Note on disabling Kibana** While optional it is recommended deployments specify a Kibana
        block, since not doing so might cause issues when modifying or upgrading the deployment.
        """
        return pulumi.get(self, "kibana")

    @property
    @pulumi.getter(name="migrateToLatestHardware")
    def migrate_to_latest_hardware(self) -> pulumi.Output[Optional[bool]]:
        """
        When set to true, the deployment will be updated according to the latest deployment template values. > **Note** If the
        <code>instance_configuration_id</code> or <code>instance_configuration_version</code> fields are set for a specific
        topology element, that element will not be updated. > **Note** Hardware migrations are not supported for deployments
        with node types. To use this field, the deployment needs to be migrated to node roles first.
        """
        return pulumi.get(self, "migrate_to_latest_hardware")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name for the deployment
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def observability(self) -> pulumi.Output[Optional['outputs.DeploymentObservability']]:
        """
        Observability settings that you can set to ship logs and metrics to a deployment. The target deployment can also be the
        current deployment itself by setting observability.deployment_id to `self`.
        """
        return pulumi.get(self, "observability")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Elasticsearch Service (ESS) region where the deployment should be hosted. For Elastic Cloud Enterprise (ECE) installations, set to `"ece-region".
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> pulumi.Output[str]:
        """
        Request ID to set when you create the deployment. Use it only when previous attempts return an error and `request_id` is
        returned as part of the error.
        """
        return pulumi.get(self, "request_id")

    @property
    @pulumi.getter(name="resetElasticsearchPassword")
    def reset_elasticsearch_password(self) -> pulumi.Output[Optional[bool]]:
        """
        Explicitly resets the elasticsearch_password when true
        """
        return pulumi.get(self, "reset_elasticsearch_password")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Optional map of deployment tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="trafficFilters")
    def traffic_filters(self) -> pulumi.Output[Sequence[str]]:
        """
        List of traffic filters rule identifiers that will be applied to the deployment.
        """
        return pulumi.get(self, "traffic_filters")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Elastic Stack version to use for all of the deployment resources.
        """
        return pulumi.get(self, "version")

