# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide6.QtQuick, except for defaults which are replaced by "...".
"""

# Module PySide6.QtQuick
import PySide6
import typing
from PySide6.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

from shiboken6 import Shiboken
Shiboken.Object = Object

import PySide6.QtQuick


class QQuickAsyncImageProvider(PySide6.QtQuick.QQuickImageProvider):

    def __init__(self) -> None: ...

    def requestImageResponse(self, id: str, requestedSize: PySide6.QtCore.QSize) -> PySide6.QtQuick.QQuickImageResponse: ...


class QQuickFramebufferObject(PySide6.QtQuick.QQuickItem):

    class Renderer(Shiboken.Object):

        def __init__(self) -> None: ...

        def invalidateFramebufferObject(self) -> None: ...
        def render(self) -> None: ...
        def synchronize(self, arg__1: PySide6.QtQuick.QQuickFramebufferObject) -> None: ...
        def update(self) -> None: ...

    def __init__(self, parent: Optional[PySide6.QtQuick.QQuickItem] = ...) -> None: ...

    def createRenderer(self) -> PySide6.QtQuick.QQuickFramebufferObject.Renderer: ...
    def geometryChange(self, newGeometry: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], oldGeometry: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    def isTextureProvider(self) -> bool: ...
    def mirrorVertically(self) -> bool: ...
    def releaseResources(self) -> None: ...
    def setMirrorVertically(self, enable: bool) -> None: ...
    def setTextureFollowsItemSize(self, follows: bool) -> None: ...
    def textureFollowsItemSize(self) -> bool: ...
    def textureProvider(self) -> PySide6.QtQuick.QSGTextureProvider: ...
    def updatePaintNode(self, arg__1: PySide6.QtQuick.QSGNode, arg__2: PySide6.QtQuick.QQuickItem.UpdatePaintNodeData) -> PySide6.QtQuick.QSGNode: ...


class QQuickImageProvider(PySide6.QtQml.QQmlImageProviderBase):

    def __init__(self, type: PySide6.QtQml.QQmlImageProviderBase.ImageType, flags: PySide6.QtQml.QQmlImageProviderBase.Flags = ...) -> None: ...

    def flags(self) -> PySide6.QtQml.QQmlImageProviderBase.Flags: ...
    def imageType(self) -> PySide6.QtQml.QQmlImageProviderBase.ImageType: ...
    def requestImage(self, id: str, size: PySide6.QtCore.QSize, requestedSize: PySide6.QtCore.QSize) -> PySide6.QtGui.QImage: ...
    def requestPixmap(self, id: str, size: PySide6.QtCore.QSize, requestedSize: PySide6.QtCore.QSize) -> PySide6.QtGui.QPixmap: ...
    def requestTexture(self, id: str, size: PySide6.QtCore.QSize, requestedSize: PySide6.QtCore.QSize) -> PySide6.QtQuick.QQuickTextureFactory: ...


class QQuickImageResponse(PySide6.QtCore.QObject):

    def __init__(self) -> None: ...

    def cancel(self) -> None: ...
    def errorString(self) -> str: ...
    def textureFactory(self) -> PySide6.QtQuick.QQuickTextureFactory: ...


class QQuickItem(PySide6.QtCore.QObject, PySide6.QtQml.QQmlParserStatus):
    ItemClipsChildrenToShape : QQuickItem.Flag = ... # 0x1
    ItemAcceptsInputMethod   : QQuickItem.Flag = ... # 0x2
    ItemIsFocusScope         : QQuickItem.Flag = ... # 0x4
    ItemHasContents          : QQuickItem.Flag = ... # 0x8
    ItemAcceptsDrops         : QQuickItem.Flag = ... # 0x10
    ItemChildAddedChange     : QQuickItem.ItemChange = ... # 0x0
    ItemChildRemovedChange   : QQuickItem.ItemChange = ... # 0x1
    ItemSceneChange          : QQuickItem.ItemChange = ... # 0x2
    ItemVisibleHasChanged    : QQuickItem.ItemChange = ... # 0x3
    ItemParentHasChanged     : QQuickItem.ItemChange = ... # 0x4
    ItemOpacityHasChanged    : QQuickItem.ItemChange = ... # 0x5
    ItemActiveFocusHasChanged: QQuickItem.ItemChange = ... # 0x6
    ItemRotationHasChanged   : QQuickItem.ItemChange = ... # 0x7
    ItemAntialiasingHasChanged: QQuickItem.ItemChange = ... # 0x8
    ItemDevicePixelRatioHasChanged: QQuickItem.ItemChange = ... # 0x9
    ItemEnabledHasChanged    : QQuickItem.ItemChange = ... # 0xa
    TopLeft                  : QQuickItem.TransformOrigin = ... # 0x0
    Top                      : QQuickItem.TransformOrigin = ... # 0x1
    TopRight                 : QQuickItem.TransformOrigin = ... # 0x2
    Left                     : QQuickItem.TransformOrigin = ... # 0x3
    Center                   : QQuickItem.TransformOrigin = ... # 0x4
    Right                    : QQuickItem.TransformOrigin = ... # 0x5
    BottomLeft               : QQuickItem.TransformOrigin = ... # 0x6
    Bottom                   : QQuickItem.TransformOrigin = ... # 0x7
    BottomRight              : QQuickItem.TransformOrigin = ... # 0x8

    class Flag(Shiboken.Enum):
        ItemClipsChildrenToShape : QQuickItem.Flag = ... # 0x1
        ItemAcceptsInputMethod   : QQuickItem.Flag = ... # 0x2
        ItemIsFocusScope         : QQuickItem.Flag = ... # 0x4
        ItemHasContents          : QQuickItem.Flag = ... # 0x8
        ItemAcceptsDrops         : QQuickItem.Flag = ... # 0x10

    class Flags(object): ...

    class ItemChange(Shiboken.Enum):
        ItemChildAddedChange     : QQuickItem.ItemChange = ... # 0x0
        ItemChildRemovedChange   : QQuickItem.ItemChange = ... # 0x1
        ItemSceneChange          : QQuickItem.ItemChange = ... # 0x2
        ItemVisibleHasChanged    : QQuickItem.ItemChange = ... # 0x3
        ItemParentHasChanged     : QQuickItem.ItemChange = ... # 0x4
        ItemOpacityHasChanged    : QQuickItem.ItemChange = ... # 0x5
        ItemActiveFocusHasChanged: QQuickItem.ItemChange = ... # 0x6
        ItemRotationHasChanged   : QQuickItem.ItemChange = ... # 0x7
        ItemAntialiasingHasChanged: QQuickItem.ItemChange = ... # 0x8
        ItemDevicePixelRatioHasChanged: QQuickItem.ItemChange = ... # 0x9
        ItemEnabledHasChanged    : QQuickItem.ItemChange = ... # 0xa

    class TransformOrigin(Shiboken.Enum):
        TopLeft                  : QQuickItem.TransformOrigin = ... # 0x0
        Top                      : QQuickItem.TransformOrigin = ... # 0x1
        TopRight                 : QQuickItem.TransformOrigin = ... # 0x2
        Left                     : QQuickItem.TransformOrigin = ... # 0x3
        Center                   : QQuickItem.TransformOrigin = ... # 0x4
        Right                    : QQuickItem.TransformOrigin = ... # 0x5
        BottomLeft               : QQuickItem.TransformOrigin = ... # 0x6
        Bottom                   : QQuickItem.TransformOrigin = ... # 0x7
        BottomRight              : QQuickItem.TransformOrigin = ... # 0x8

    class UpdatePaintNodeData(Shiboken.Object):

        def __init__(self, UpdatePaintNodeData: PySide6.QtQuick.QQuickItem.UpdatePaintNodeData) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    def __init__(self, parent: Optional[PySide6.QtQuick.QQuickItem] = ...) -> None: ...

    def acceptHoverEvents(self) -> bool: ...
    def acceptTouchEvents(self) -> bool: ...
    def acceptedMouseButtons(self) -> PySide6.QtCore.Qt.MouseButtons: ...
    def activeFocusOnTab(self) -> bool: ...
    def antialiasing(self) -> bool: ...
    def baselineOffset(self) -> float: ...
    def boundingRect(self) -> PySide6.QtCore.QRectF: ...
    def childAt(self, x: float, y: float) -> PySide6.QtQuick.QQuickItem: ...
    def childItems(self) -> List[PySide6.QtQuick.QQuickItem]: ...
    def childMouseEventFilter(self, arg__1: PySide6.QtQuick.QQuickItem, arg__2: PySide6.QtCore.QEvent) -> bool: ...
    def childrenRect(self) -> PySide6.QtCore.QRectF: ...
    def classBegin(self) -> None: ...
    def clip(self) -> bool: ...
    def clipRect(self) -> PySide6.QtCore.QRectF: ...
    def componentComplete(self) -> None: ...
    def containmentMask(self) -> PySide6.QtCore.QObject: ...
    def contains(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> bool: ...
    def cursor(self) -> PySide6.QtGui.QCursor: ...
    def dragEnterEvent(self, arg__1: PySide6.QtGui.QDragEnterEvent) -> None: ...
    def dragLeaveEvent(self, arg__1: PySide6.QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, arg__1: PySide6.QtGui.QDragMoveEvent) -> None: ...
    def dropEvent(self, arg__1: PySide6.QtGui.QDropEvent) -> None: ...
    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    def filtersChildMouseEvents(self) -> bool: ...
    def flags(self) -> PySide6.QtQuick.QQuickItem.Flags: ...
    def focusInEvent(self, arg__1: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, arg__1: PySide6.QtGui.QFocusEvent) -> None: ...
    @typing.overload
    def forceActiveFocus(self) -> None: ...
    @typing.overload
    def forceActiveFocus(self, reason: PySide6.QtCore.Qt.FocusReason) -> None: ...
    def geometryChange(self, newGeometry: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], oldGeometry: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    def grabMouse(self) -> None: ...
    @typing.overload
    def grabToImage(self, callback: Union[PySide6.QtQml.QJSValue, PySide6.QtQml.QJSValue.SpecialValue, bool, str, bytes, float, int], targetSize: PySide6.QtCore.QSize = ...) -> bool: ...
    @typing.overload
    def grabToImage(self, targetSize: PySide6.QtCore.QSize = ...) -> Tuple[PySide6.QtQuick.QQuickItemGrabResult]: ...
    def grabTouchPoints(self, ids: Sequence[int]) -> None: ...
    def hasActiveFocus(self) -> bool: ...
    def hasFocus(self) -> bool: ...
    def height(self) -> float: ...
    def heightValid(self) -> bool: ...
    def hoverEnterEvent(self, event: PySide6.QtGui.QHoverEvent) -> None: ...
    def hoverLeaveEvent(self, event: PySide6.QtGui.QHoverEvent) -> None: ...
    def hoverMoveEvent(self, event: PySide6.QtGui.QHoverEvent) -> None: ...
    def implicitHeight(self) -> float: ...
    def implicitWidth(self) -> float: ...
    def inputMethodEvent(self, arg__1: PySide6.QtGui.QInputMethodEvent) -> None: ...
    def inputMethodQuery(self, query: PySide6.QtCore.Qt.InputMethodQuery) -> Any: ...
    def isAncestorOf(self, child: PySide6.QtQuick.QQuickItem) -> bool: ...
    def isComponentComplete(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isFocusScope(self) -> bool: ...
    def isTextureProvider(self) -> bool: ...
    def isUnderMouse(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def itemTransform(self, arg__1: PySide6.QtQuick.QQuickItem) -> Tuple[PySide6.QtGui.QTransform, bool]: ...
    def keepMouseGrab(self) -> bool: ...
    def keepTouchGrab(self) -> bool: ...
    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, event: PySide6.QtGui.QKeyEvent) -> None: ...
    def mapFromGlobal(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    def mapFromItem(self, item: PySide6.QtQuick.QQuickItem, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    def mapFromScene(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    def mapRectFromItem(self, item: PySide6.QtQuick.QQuickItem, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtCore.QRectF: ...
    def mapRectFromScene(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtCore.QRectF: ...
    def mapRectToItem(self, item: PySide6.QtQuick.QQuickItem, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtCore.QRectF: ...
    def mapRectToScene(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtCore.QRectF: ...
    def mapToGlobal(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    def mapToItem(self, item: PySide6.QtQuick.QQuickItem, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    def mapToScene(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    def mouseDoubleClickEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseUngrabEvent(self) -> None: ...
    def nextItemInFocusChain(self, forward: bool = ...) -> PySide6.QtQuick.QQuickItem: ...
    def opacity(self) -> float: ...
    def parentItem(self) -> PySide6.QtQuick.QQuickItem: ...
    def polish(self) -> None: ...
    def position(self) -> PySide6.QtCore.QPointF: ...
    def releaseResources(self) -> None: ...
    def resetAntialiasing(self) -> None: ...
    def resetHeight(self) -> None: ...
    def resetWidth(self) -> None: ...
    def rotation(self) -> float: ...
    def scale(self) -> float: ...
    def scopedFocusItem(self) -> PySide6.QtQuick.QQuickItem: ...
    def setAcceptHoverEvents(self, enabled: bool) -> None: ...
    def setAcceptTouchEvents(self, accept: bool) -> None: ...
    def setAcceptedMouseButtons(self, buttons: PySide6.QtCore.Qt.MouseButtons) -> None: ...
    def setActiveFocusOnTab(self, arg__1: bool) -> None: ...
    def setAntialiasing(self, arg__1: bool) -> None: ...
    def setBaselineOffset(self, arg__1: float) -> None: ...
    def setClip(self, arg__1: bool) -> None: ...
    def setContainmentMask(self, mask: PySide6.QtCore.QObject) -> None: ...
    def setCursor(self, cursor: Union[PySide6.QtGui.QCursor, PySide6.QtCore.Qt.CursorShape, PySide6.QtGui.QPixmap]) -> None: ...
    def setEnabled(self, arg__1: bool) -> None: ...
    def setFiltersChildMouseEvents(self, filter: bool) -> None: ...
    def setFlag(self, flag: PySide6.QtQuick.QQuickItem.Flag, enabled: bool = ...) -> None: ...
    def setFlags(self, flags: PySide6.QtQuick.QQuickItem.Flags) -> None: ...
    @typing.overload
    def setFocus(self, arg__1: bool) -> None: ...
    @typing.overload
    def setFocus(self, focus: bool, reason: PySide6.QtCore.Qt.FocusReason) -> None: ...
    def setHeight(self, arg__1: float) -> None: ...
    def setImplicitHeight(self, arg__1: float) -> None: ...
    def setImplicitSize(self, arg__1: float, arg__2: float) -> None: ...
    def setImplicitWidth(self, arg__1: float) -> None: ...
    def setKeepMouseGrab(self, arg__1: bool) -> None: ...
    def setKeepTouchGrab(self, arg__1: bool) -> None: ...
    def setOpacity(self, arg__1: float) -> None: ...
    def setParentItem(self, parent: PySide6.QtQuick.QQuickItem) -> None: ...
    def setPosition(self, arg__1: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setRotation(self, arg__1: float) -> None: ...
    def setScale(self, arg__1: float) -> None: ...
    def setSize(self, size: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize]) -> None: ...
    def setSmooth(self, arg__1: bool) -> None: ...
    def setState(self, arg__1: str) -> None: ...
    def setTransformOrigin(self, arg__1: PySide6.QtQuick.QQuickItem.TransformOrigin) -> None: ...
    def setTransformOriginPoint(self, arg__1: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setVisible(self, arg__1: bool) -> None: ...
    def setWidth(self, arg__1: float) -> None: ...
    def setX(self, arg__1: float) -> None: ...
    def setY(self, arg__1: float) -> None: ...
    def setZ(self, arg__1: float) -> None: ...
    def size(self) -> PySide6.QtCore.QSizeF: ...
    def smooth(self) -> bool: ...
    def stackAfter(self, arg__1: PySide6.QtQuick.QQuickItem) -> None: ...
    def stackBefore(self, arg__1: PySide6.QtQuick.QQuickItem) -> None: ...
    def state(self) -> str: ...
    def textureProvider(self) -> PySide6.QtQuick.QSGTextureProvider: ...
    def touchEvent(self, event: PySide6.QtGui.QTouchEvent) -> None: ...
    def touchUngrabEvent(self) -> None: ...
    def transformOrigin(self) -> PySide6.QtQuick.QQuickItem.TransformOrigin: ...
    def transformOriginPoint(self) -> PySide6.QtCore.QPointF: ...
    def ungrabMouse(self) -> None: ...
    def ungrabTouchPoints(self) -> None: ...
    def unsetCursor(self) -> None: ...
    def update(self) -> None: ...
    def updateInputMethod(self, queries: PySide6.QtCore.Qt.InputMethodQueries = ...) -> None: ...
    def updatePaintNode(self, arg__1: PySide6.QtQuick.QSGNode, arg__2: PySide6.QtQuick.QQuickItem.UpdatePaintNodeData) -> PySide6.QtQuick.QSGNode: ...
    def updatePolish(self) -> None: ...
    def wheelEvent(self, event: PySide6.QtGui.QWheelEvent) -> None: ...
    def width(self) -> float: ...
    def widthValid(self) -> bool: ...
    def window(self) -> PySide6.QtQuick.QQuickWindow: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...


class QQuickItemGrabResult(PySide6.QtCore.QObject):
    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    def image(self) -> PySide6.QtGui.QImage: ...
    def saveToFile(self, fileName: str) -> bool: ...
    def url(self) -> PySide6.QtCore.QUrl: ...


class QQuickPaintedItem(PySide6.QtQuick.QQuickItem):
    FastFBOResizing          : QQuickPaintedItem.PerformanceHint = ... # 0x1
    Image                    : QQuickPaintedItem.RenderTarget = ... # 0x0
    FramebufferObject        : QQuickPaintedItem.RenderTarget = ... # 0x1
    InvertedYFramebufferObject: QQuickPaintedItem.RenderTarget = ... # 0x2

    class PerformanceHint(Shiboken.Enum):
        FastFBOResizing          : QQuickPaintedItem.PerformanceHint = ... # 0x1

    class PerformanceHints(object): ...

    class RenderTarget(Shiboken.Enum):
        Image                    : QQuickPaintedItem.RenderTarget = ... # 0x0
        FramebufferObject        : QQuickPaintedItem.RenderTarget = ... # 0x1
        InvertedYFramebufferObject: QQuickPaintedItem.RenderTarget = ... # 0x2

    def __init__(self, parent: Optional[PySide6.QtQuick.QQuickItem] = ...) -> None: ...

    def antialiasing(self) -> bool: ...
    def contentsBoundingRect(self) -> PySide6.QtCore.QRectF: ...
    def contentsScale(self) -> float: ...
    def contentsSize(self) -> PySide6.QtCore.QSize: ...
    def fillColor(self) -> PySide6.QtGui.QColor: ...
    def isTextureProvider(self) -> bool: ...
    def mipmap(self) -> bool: ...
    def opaquePainting(self) -> bool: ...
    def paint(self, painter: PySide6.QtGui.QPainter) -> None: ...
    def performanceHints(self) -> PySide6.QtQuick.QQuickPaintedItem.PerformanceHints: ...
    def releaseResources(self) -> None: ...
    def renderTarget(self) -> PySide6.QtQuick.QQuickPaintedItem.RenderTarget: ...
    def resetContentsSize(self) -> None: ...
    def setAntialiasing(self, enable: bool) -> None: ...
    def setContentsScale(self, arg__1: float) -> None: ...
    def setContentsSize(self, arg__1: PySide6.QtCore.QSize) -> None: ...
    def setFillColor(self, arg__1: Union[PySide6.QtGui.QColor, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    def setMipmap(self, enable: bool) -> None: ...
    def setOpaquePainting(self, opaque: bool) -> None: ...
    def setPerformanceHint(self, hint: PySide6.QtQuick.QQuickPaintedItem.PerformanceHint, enabled: bool = ...) -> None: ...
    def setPerformanceHints(self, hints: PySide6.QtQuick.QQuickPaintedItem.PerformanceHints) -> None: ...
    def setRenderTarget(self, target: PySide6.QtQuick.QQuickPaintedItem.RenderTarget) -> None: ...
    def setTextureSize(self, size: PySide6.QtCore.QSize) -> None: ...
    def textureProvider(self) -> PySide6.QtQuick.QSGTextureProvider: ...
    def textureSize(self) -> PySide6.QtCore.QSize: ...
    @typing.overload
    def update(self) -> None: ...
    @typing.overload
    def update(self, rect: PySide6.QtCore.QRect = ...) -> None: ...
    def updatePaintNode(self, arg__1: PySide6.QtQuick.QSGNode, arg__2: PySide6.QtQuick.QQuickItem.UpdatePaintNodeData) -> PySide6.QtQuick.QSGNode: ...


class QQuickRenderControl(PySide6.QtCore.QObject):

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def beginFrame(self) -> None: ...
    def endFrame(self) -> None: ...
    def initialize(self) -> bool: ...
    def invalidate(self) -> None: ...
    def polishItems(self) -> None: ...
    def prepareThread(self, targetThread: PySide6.QtCore.QThread) -> None: ...
    def render(self) -> None: ...
    def renderWindow(self, offset: PySide6.QtCore.QPoint) -> PySide6.QtGui.QWindow: ...
    @staticmethod
    def renderWindowFor(win: PySide6.QtQuick.QQuickWindow, offset: Optional[PySide6.QtCore.QPoint] = ...) -> PySide6.QtGui.QWindow: ...
    def samples(self) -> int: ...
    def setSamples(self, sampleCount: int) -> None: ...
    def sync(self) -> bool: ...
    def window(self) -> PySide6.QtQuick.QQuickWindow: ...


class QQuickTextDocument(PySide6.QtCore.QObject):

    def __init__(self, parent: PySide6.QtQuick.QQuickItem) -> None: ...

    def textDocument(self) -> PySide6.QtGui.QTextDocument: ...


class QQuickTextureFactory(PySide6.QtCore.QObject):

    def __init__(self) -> None: ...

    def createTexture(self, window: PySide6.QtQuick.QQuickWindow) -> PySide6.QtQuick.QSGTexture: ...
    def image(self) -> PySide6.QtGui.QImage: ...
    def textureByteCount(self) -> int: ...
    @staticmethod
    def textureFactoryForImage(image: Union[PySide6.QtGui.QImage, str]) -> PySide6.QtQuick.QQuickTextureFactory: ...
    def textureSize(self) -> PySide6.QtCore.QSize: ...


class QQuickTransform(PySide6.QtCore.QObject):

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def appendToItem(self, arg__1: PySide6.QtQuick.QQuickItem) -> None: ...
    def applyTo(self, matrix: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform]) -> None: ...
    def prependToItem(self, arg__1: PySide6.QtQuick.QQuickItem) -> None: ...
    def update(self) -> None: ...


class QQuickView(PySide6.QtQuick.QQuickWindow):
    SizeViewToRootObject     : QQuickView.ResizeMode = ... # 0x0
    SizeRootObjectToView     : QQuickView.ResizeMode = ... # 0x1
    Null                     : QQuickView.Status = ... # 0x0
    Ready                    : QQuickView.Status = ... # 0x1
    Loading                  : QQuickView.Status = ... # 0x2
    Error                    : QQuickView.Status = ... # 0x3

    class ResizeMode(Shiboken.Enum):
        SizeViewToRootObject     : QQuickView.ResizeMode = ... # 0x0
        SizeRootObjectToView     : QQuickView.ResizeMode = ... # 0x1

    class Status(Shiboken.Enum):
        Null                     : QQuickView.Status = ... # 0x0
        Ready                    : QQuickView.Status = ... # 0x1
        Loading                  : QQuickView.Status = ... # 0x2
        Error                    : QQuickView.Status = ... # 0x3

    @typing.overload
    def __init__(self, engine: PySide6.QtQml.QQmlEngine, parent: PySide6.QtGui.QWindow) -> None: ...
    @typing.overload
    def __init__(self, parent: Optional[PySide6.QtGui.QWindow] = ...) -> None: ...
    @typing.overload
    def __init__(self, source: Union[PySide6.QtCore.QUrl, str], parent: Optional[PySide6.QtGui.QWindow] = ...) -> None: ...
    @typing.overload
    def __init__(self, source: Union[PySide6.QtCore.QUrl, str], renderControl: PySide6.QtQuick.QQuickRenderControl) -> None: ...

    def engine(self) -> PySide6.QtQml.QQmlEngine: ...
    def errors(self) -> List[PySide6.QtQml.QQmlError]: ...
    def initialSize(self) -> PySide6.QtCore.QSize: ...
    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent) -> None: ...
    def resizeMode(self) -> PySide6.QtQuick.QQuickView.ResizeMode: ...
    def rootContext(self) -> PySide6.QtQml.QQmlContext: ...
    def rootObject(self) -> PySide6.QtQuick.QQuickItem: ...
    def setContent(self, url: Union[PySide6.QtCore.QUrl, str], component: PySide6.QtQml.QQmlComponent, item: PySide6.QtCore.QObject) -> None: ...
    def setInitialProperties(self, initialProperties: Dict[str, Any]) -> None: ...
    def setResizeMode(self, arg__1: PySide6.QtQuick.QQuickView.ResizeMode) -> None: ...
    def setSource(self, arg__1: Union[PySide6.QtCore.QUrl, str]) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def source(self) -> PySide6.QtCore.QUrl: ...
    def status(self) -> PySide6.QtQuick.QQuickView.Status: ...
    def timerEvent(self, arg__1: PySide6.QtCore.QTimerEvent) -> None: ...


class QQuickWindow(PySide6.QtGui.QWindow):
    TextureHasAlphaChannel   : QQuickWindow.CreateTextureOption = ... # 0x1
    TextureHasMipmaps        : QQuickWindow.CreateTextureOption = ... # 0x2
    TextureOwnsGLTexture     : QQuickWindow.CreateTextureOption = ... # 0x4
    TextureCanUseAtlas       : QQuickWindow.CreateTextureOption = ... # 0x8
    TextureIsOpaque          : QQuickWindow.CreateTextureOption = ... # 0x10
    BeforeSynchronizingStage : QQuickWindow.RenderStage = ... # 0x0
    AfterSynchronizingStage  : QQuickWindow.RenderStage = ... # 0x1
    BeforeRenderingStage     : QQuickWindow.RenderStage = ... # 0x2
    AfterRenderingStage      : QQuickWindow.RenderStage = ... # 0x3
    AfterSwapStage           : QQuickWindow.RenderStage = ... # 0x4
    NoStage                  : QQuickWindow.RenderStage = ... # 0x5
    ContextNotAvailable      : QQuickWindow.SceneGraphError = ... # 0x1
    QtTextRendering          : QQuickWindow.TextRenderType = ... # 0x0
    NativeTextRendering      : QQuickWindow.TextRenderType = ... # 0x1

    class CreateTextureOption(Shiboken.Enum):
        TextureHasAlphaChannel   : QQuickWindow.CreateTextureOption = ... # 0x1
        TextureHasMipmaps        : QQuickWindow.CreateTextureOption = ... # 0x2
        TextureOwnsGLTexture     : QQuickWindow.CreateTextureOption = ... # 0x4
        TextureCanUseAtlas       : QQuickWindow.CreateTextureOption = ... # 0x8
        TextureIsOpaque          : QQuickWindow.CreateTextureOption = ... # 0x10

    class CreateTextureOptions(object): ...

    class RenderStage(Shiboken.Enum):
        BeforeSynchronizingStage : QQuickWindow.RenderStage = ... # 0x0
        AfterSynchronizingStage  : QQuickWindow.RenderStage = ... # 0x1
        BeforeRenderingStage     : QQuickWindow.RenderStage = ... # 0x2
        AfterRenderingStage      : QQuickWindow.RenderStage = ... # 0x3
        AfterSwapStage           : QQuickWindow.RenderStage = ... # 0x4
        NoStage                  : QQuickWindow.RenderStage = ... # 0x5

    class SceneGraphError(Shiboken.Enum):
        ContextNotAvailable      : QQuickWindow.SceneGraphError = ... # 0x1

    class TextRenderType(Shiboken.Enum):
        QtTextRendering          : QQuickWindow.TextRenderType = ... # 0x0
        NativeTextRendering      : QQuickWindow.TextRenderType = ... # 0x1

    @typing.overload
    def __init__(self, parent: Optional[PySide6.QtGui.QWindow] = ...) -> None: ...
    @typing.overload
    def __init__(self, renderControl: PySide6.QtQuick.QQuickRenderControl) -> None: ...

    def accessibleRoot(self) -> PySide6.QtGui.QAccessibleInterface: ...
    def activeFocusItem(self) -> PySide6.QtQuick.QQuickItem: ...
    def beginExternalCommands(self) -> None: ...
    def closeEvent(self, arg__1: PySide6.QtGui.QCloseEvent) -> None: ...
    def color(self) -> PySide6.QtGui.QColor: ...
    def contentItem(self) -> PySide6.QtQuick.QQuickItem: ...
    @typing.overload
    def createTextureFromImage(self, image: Union[PySide6.QtGui.QImage, str]) -> PySide6.QtQuick.QSGTexture: ...
    @typing.overload
    def createTextureFromImage(self, image: Union[PySide6.QtGui.QImage, str], options: PySide6.QtQuick.QQuickWindow.CreateTextureOptions) -> PySide6.QtQuick.QSGTexture: ...
    def effectiveDevicePixelRatio(self) -> float: ...
    def endExternalCommands(self) -> None: ...
    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    def exposeEvent(self, arg__1: PySide6.QtGui.QExposeEvent) -> None: ...
    def focusInEvent(self, arg__1: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusObject(self) -> PySide6.QtCore.QObject: ...
    def focusOutEvent(self, arg__1: PySide6.QtGui.QFocusEvent) -> None: ...
    def grabWindow(self) -> PySide6.QtGui.QImage: ...
    @staticmethod
    def hasDefaultAlphaBuffer() -> bool: ...
    def hideEvent(self, arg__1: PySide6.QtGui.QHideEvent) -> None: ...
    def incubationController(self) -> PySide6.QtQml.QQmlIncubationController: ...
    def isPersistentGraphics(self) -> bool: ...
    def isPersistentSceneGraph(self) -> bool: ...
    def isSceneGraphInitialized(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None: ...
    def mouseDoubleClickEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseGrabberItem(self) -> PySide6.QtQuick.QQuickItem: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def releaseResources(self) -> None: ...
    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent) -> None: ...
    @staticmethod
    def sceneGraphBackend() -> str: ...
    def scheduleRenderJob(self, job: PySide6.QtCore.QRunnable, schedule: PySide6.QtQuick.QQuickWindow.RenderStage) -> None: ...
    def setColor(self, color: Union[PySide6.QtGui.QColor, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    @staticmethod
    def setDefaultAlphaBuffer(useAlpha: bool) -> None: ...
    def setPersistentGraphics(self, persistent: bool) -> None: ...
    def setPersistentSceneGraph(self, persistent: bool) -> None: ...
    @staticmethod
    def setSceneGraphBackend(backend: str) -> None: ...
    @staticmethod
    def setTextRenderType(renderType: PySide6.QtQuick.QQuickWindow.TextRenderType) -> None: ...
    def showEvent(self, arg__1: PySide6.QtGui.QShowEvent) -> None: ...
    def tabletEvent(self, arg__1: PySide6.QtGui.QTabletEvent) -> None: ...
    @staticmethod
    def textRenderType() -> PySide6.QtQuick.QQuickWindow.TextRenderType: ...
    def update(self) -> None: ...
    def wheelEvent(self, arg__1: PySide6.QtGui.QWheelEvent) -> None: ...


class QSGBasicGeometryNode(PySide6.QtQuick.QSGNode):

    def __init__(self, type: PySide6.QtQuick.QSGNode.NodeType) -> None: ...

    def clipList(self) -> PySide6.QtQuick.QSGClipNode: ...
    def geometry(self) -> PySide6.QtQuick.QSGGeometry: ...
    def matrix(self) -> PySide6.QtGui.QMatrix4x4: ...
    def setGeometry(self, geometry: PySide6.QtQuick.QSGGeometry) -> None: ...
    def setRendererClipList(self, c: PySide6.QtQuick.QSGClipNode) -> None: ...
    def setRendererMatrix(self, m: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform]) -> None: ...


class QSGClipNode(PySide6.QtQuick.QSGBasicGeometryNode):

    def __init__(self) -> None: ...

    def clipRect(self) -> PySide6.QtCore.QRectF: ...
    def isRectangular(self) -> bool: ...
    def setClipRect(self, arg__1: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    def setIsRectangular(self, rectHint: bool) -> None: ...


class QSGDynamicTexture(PySide6.QtQuick.QSGTexture):

    def __init__(self) -> None: ...

    def updateTexture(self) -> bool: ...


class QSGGeometry(Shiboken.Object):
    UnknownAttribute         : QSGGeometry.AttributeType = ... # 0x0
    PositionAttribute        : QSGGeometry.AttributeType = ... # 0x1
    ColorAttribute           : QSGGeometry.AttributeType = ... # 0x2
    TexCoordAttribute        : QSGGeometry.AttributeType = ... # 0x3
    TexCoord1Attribute       : QSGGeometry.AttributeType = ... # 0x4
    TexCoord2Attribute       : QSGGeometry.AttributeType = ... # 0x5
    AlwaysUploadPattern      : QSGGeometry.DataPattern = ... # 0x0
    StreamPattern            : QSGGeometry.DataPattern = ... # 0x1
    DynamicPattern           : QSGGeometry.DataPattern = ... # 0x2
    StaticPattern            : QSGGeometry.DataPattern = ... # 0x3
    DrawPoints               : QSGGeometry.DrawingMode = ... # 0x0
    DrawLines                : QSGGeometry.DrawingMode = ... # 0x1
    DrawLineLoop             : QSGGeometry.DrawingMode = ... # 0x2
    DrawLineStrip            : QSGGeometry.DrawingMode = ... # 0x3
    DrawTriangles            : QSGGeometry.DrawingMode = ... # 0x4
    DrawTriangleStrip        : QSGGeometry.DrawingMode = ... # 0x5
    DrawTriangleFan          : QSGGeometry.DrawingMode = ... # 0x6
    ByteType                 : QSGGeometry.Type = ... # 0x1400
    UnsignedByteType         : QSGGeometry.Type = ... # 0x1401
    ShortType                : QSGGeometry.Type = ... # 0x1402
    UnsignedShortType        : QSGGeometry.Type = ... # 0x1403
    IntType                  : QSGGeometry.Type = ... # 0x1404
    UnsignedIntType          : QSGGeometry.Type = ... # 0x1405
    FloatType                : QSGGeometry.Type = ... # 0x1406
    Bytes2Type               : QSGGeometry.Type = ... # 0x1407
    Bytes3Type               : QSGGeometry.Type = ... # 0x1408
    Bytes4Type               : QSGGeometry.Type = ... # 0x1409
    DoubleType               : QSGGeometry.Type = ... # 0x140a

    class Attribute(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, Attribute: PySide6.QtQuick.QSGGeometry.Attribute) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        @staticmethod
        def create(pos: int, tupleSize: int, primitiveType: int, isPosition: bool = ...) -> PySide6.QtQuick.QSGGeometry.Attribute: ...
        @staticmethod
        def createWithAttributeType(pos: int, tupleSize: int, primitiveType: int, attributeType: PySide6.QtQuick.QSGGeometry.AttributeType) -> PySide6.QtQuick.QSGGeometry.Attribute: ...

    class AttributeSet(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, AttributeSet: PySide6.QtQuick.QSGGeometry.AttributeSet) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class AttributeType(Shiboken.Enum):
        UnknownAttribute         : QSGGeometry.AttributeType = ... # 0x0
        PositionAttribute        : QSGGeometry.AttributeType = ... # 0x1
        ColorAttribute           : QSGGeometry.AttributeType = ... # 0x2
        TexCoordAttribute        : QSGGeometry.AttributeType = ... # 0x3
        TexCoord1Attribute       : QSGGeometry.AttributeType = ... # 0x4
        TexCoord2Attribute       : QSGGeometry.AttributeType = ... # 0x5

    class ColoredPoint2D(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, ColoredPoint2D: PySide6.QtQuick.QSGGeometry.ColoredPoint2D) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def set(self, nx: float, ny: float, nr: int, ng: int, nb: int, na: int) -> None: ...

    class DataPattern(Shiboken.Enum):
        AlwaysUploadPattern      : QSGGeometry.DataPattern = ... # 0x0
        StreamPattern            : QSGGeometry.DataPattern = ... # 0x1
        DynamicPattern           : QSGGeometry.DataPattern = ... # 0x2
        StaticPattern            : QSGGeometry.DataPattern = ... # 0x3

    class DrawingMode(Shiboken.Enum):
        DrawPoints               : QSGGeometry.DrawingMode = ... # 0x0
        DrawLines                : QSGGeometry.DrawingMode = ... # 0x1
        DrawLineLoop             : QSGGeometry.DrawingMode = ... # 0x2
        DrawLineStrip            : QSGGeometry.DrawingMode = ... # 0x3
        DrawTriangles            : QSGGeometry.DrawingMode = ... # 0x4
        DrawTriangleStrip        : QSGGeometry.DrawingMode = ... # 0x5
        DrawTriangleFan          : QSGGeometry.DrawingMode = ... # 0x6

    class Point2D(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, Point2D: PySide6.QtQuick.QSGGeometry.Point2D) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def set(self, nx: float, ny: float) -> None: ...

    class TexturedPoint2D(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, TexturedPoint2D: PySide6.QtQuick.QSGGeometry.TexturedPoint2D) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def set(self, nx: float, ny: float, ntx: float, nty: float) -> None: ...

    class Type(Shiboken.Enum):
        ByteType                 : QSGGeometry.Type = ... # 0x1400
        UnsignedByteType         : QSGGeometry.Type = ... # 0x1401
        ShortType                : QSGGeometry.Type = ... # 0x1402
        UnsignedShortType        : QSGGeometry.Type = ... # 0x1403
        IntType                  : QSGGeometry.Type = ... # 0x1404
        UnsignedIntType          : QSGGeometry.Type = ... # 0x1405
        FloatType                : QSGGeometry.Type = ... # 0x1406
        Bytes2Type               : QSGGeometry.Type = ... # 0x1407
        Bytes3Type               : QSGGeometry.Type = ... # 0x1408
        Bytes4Type               : QSGGeometry.Type = ... # 0x1409
        DoubleType               : QSGGeometry.Type = ... # 0x140a

    def __init__(self, attribs: PySide6.QtQuick.QSGGeometry.AttributeSet, vertexCount: int, indexCount: int = ..., indexType: int = ...) -> None: ...

    def allocate(self, vertexCount: int, indexCount: int = ...) -> None: ...
    def attributeCount(self) -> int: ...
    def attributes(self) -> PySide6.QtQuick.QSGGeometry.Attribute: ...
    @staticmethod
    def defaultAttributes_ColoredPoint2D() -> PySide6.QtQuick.QSGGeometry.AttributeSet: ...
    @staticmethod
    def defaultAttributes_Point2D() -> PySide6.QtQuick.QSGGeometry.AttributeSet: ...
    @staticmethod
    def defaultAttributes_TexturedPoint2D() -> PySide6.QtQuick.QSGGeometry.AttributeSet: ...
    def drawingMode(self) -> int: ...
    def indexCount(self) -> int: ...
    def indexData(self) -> int: ...
    def indexDataAsUInt(self) -> List[int]: ...
    def indexDataAsUShort(self) -> List[int]: ...
    def indexDataPattern(self) -> PySide6.QtQuick.QSGGeometry.DataPattern: ...
    def indexType(self) -> int: ...
    def lineWidth(self) -> float: ...
    def markIndexDataDirty(self) -> None: ...
    def markVertexDataDirty(self) -> None: ...
    def setDrawingMode(self, mode: int) -> None: ...
    def setIndexDataPattern(self, p: PySide6.QtQuick.QSGGeometry.DataPattern) -> None: ...
    def setLineWidth(self, w: float) -> None: ...
    def setVertexDataPattern(self, p: PySide6.QtQuick.QSGGeometry.DataPattern) -> None: ...
    def sizeOfIndex(self) -> int: ...
    def sizeOfVertex(self) -> int: ...
    @staticmethod
    def updateColoredRectGeometry(g: PySide6.QtQuick.QSGGeometry, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @staticmethod
    def updateRectGeometry(g: PySide6.QtQuick.QSGGeometry, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @staticmethod
    def updateTexturedRectGeometry(g: PySide6.QtQuick.QSGGeometry, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], sourceRect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    def vertexCount(self) -> int: ...
    def vertexData(self) -> int: ...
    def vertexDataAsColoredPoint2D(self) -> PySide6.QtQuick.QSGGeometry.ColoredPoint2D: ...
    def vertexDataAsPoint2D(self) -> PySide6.QtQuick.QSGGeometry.Point2D: ...
    def vertexDataAsTexturedPoint2D(self) -> PySide6.QtQuick.QSGGeometry.TexturedPoint2D: ...
    def vertexDataPattern(self) -> PySide6.QtQuick.QSGGeometry.DataPattern: ...


class QSGGeometryNode(PySide6.QtQuick.QSGBasicGeometryNode):

    def __init__(self) -> None: ...

    def inheritedOpacity(self) -> float: ...
    def renderOrder(self) -> int: ...
    def setInheritedOpacity(self, opacity: float) -> None: ...
    def setRenderOrder(self, order: int) -> None: ...


class QSGMaterialType(Shiboken.Object):

    def __init__(self) -> None: ...


class QSGNode(Shiboken.Object):
    DirtyUsePreprocess       : QSGNode.DirtyStateBit = ... # 0x2
    DirtySubtreeBlocked      : QSGNode.DirtyStateBit = ... # 0x80
    DirtyMatrix              : QSGNode.DirtyStateBit = ... # 0x100
    DirtyNodeAdded           : QSGNode.DirtyStateBit = ... # 0x400
    DirtyNodeRemoved         : QSGNode.DirtyStateBit = ... # 0x800
    DirtyGeometry            : QSGNode.DirtyStateBit = ... # 0x1000
    DirtyMaterial            : QSGNode.DirtyStateBit = ... # 0x2000
    DirtyOpacity             : QSGNode.DirtyStateBit = ... # 0x4000
    DirtyForceUpdate         : QSGNode.DirtyStateBit = ... # 0x8000
    DirtyPropagationMask     : QSGNode.DirtyStateBit = ... # 0xc500
    OwnedByParent            : QSGNode.Flag = ... # 0x1
    UsePreprocess            : QSGNode.Flag = ... # 0x2
    OwnsGeometry             : QSGNode.Flag = ... # 0x10000
    OwnsMaterial             : QSGNode.Flag = ... # 0x20000
    OwnsOpaqueMaterial       : QSGNode.Flag = ... # 0x40000
    IsVisitableNode          : QSGNode.Flag = ... # 0x1000000
    BasicNodeType            : QSGNode.NodeType = ... # 0x0
    GeometryNodeType         : QSGNode.NodeType = ... # 0x1
    TransformNodeType        : QSGNode.NodeType = ... # 0x2
    ClipNodeType             : QSGNode.NodeType = ... # 0x3
    OpacityNodeType          : QSGNode.NodeType = ... # 0x4
    RootNodeType             : QSGNode.NodeType = ... # 0x5
    RenderNodeType           : QSGNode.NodeType = ... # 0x6

    class DirtyState(object): ...

    class DirtyStateBit(Shiboken.Enum):
        DirtyUsePreprocess       : QSGNode.DirtyStateBit = ... # 0x2
        DirtySubtreeBlocked      : QSGNode.DirtyStateBit = ... # 0x80
        DirtyMatrix              : QSGNode.DirtyStateBit = ... # 0x100
        DirtyNodeAdded           : QSGNode.DirtyStateBit = ... # 0x400
        DirtyNodeRemoved         : QSGNode.DirtyStateBit = ... # 0x800
        DirtyGeometry            : QSGNode.DirtyStateBit = ... # 0x1000
        DirtyMaterial            : QSGNode.DirtyStateBit = ... # 0x2000
        DirtyOpacity             : QSGNode.DirtyStateBit = ... # 0x4000
        DirtyForceUpdate         : QSGNode.DirtyStateBit = ... # 0x8000
        DirtyPropagationMask     : QSGNode.DirtyStateBit = ... # 0xc500

    class Flag(Shiboken.Enum):
        OwnedByParent            : QSGNode.Flag = ... # 0x1
        UsePreprocess            : QSGNode.Flag = ... # 0x2
        OwnsGeometry             : QSGNode.Flag = ... # 0x10000
        OwnsMaterial             : QSGNode.Flag = ... # 0x20000
        OwnsOpaqueMaterial       : QSGNode.Flag = ... # 0x40000
        IsVisitableNode          : QSGNode.Flag = ... # 0x1000000

    class Flags(object): ...

    class NodeType(Shiboken.Enum):
        BasicNodeType            : QSGNode.NodeType = ... # 0x0
        GeometryNodeType         : QSGNode.NodeType = ... # 0x1
        TransformNodeType        : QSGNode.NodeType = ... # 0x2
        ClipNodeType             : QSGNode.NodeType = ... # 0x3
        OpacityNodeType          : QSGNode.NodeType = ... # 0x4
        RootNodeType             : QSGNode.NodeType = ... # 0x5
        RenderNodeType           : QSGNode.NodeType = ... # 0x6

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, type: PySide6.QtQuick.QSGNode.NodeType) -> None: ...

    def appendChildNode(self, node: PySide6.QtQuick.QSGNode) -> None: ...
    def childAtIndex(self, i: int) -> PySide6.QtQuick.QSGNode: ...
    def childCount(self) -> int: ...
    def clearDirty(self) -> None: ...
    def dirtyState(self) -> PySide6.QtQuick.QSGNode.DirtyState: ...
    def firstChild(self) -> PySide6.QtQuick.QSGNode: ...
    def flags(self) -> PySide6.QtQuick.QSGNode.Flags: ...
    def insertChildNodeAfter(self, node: PySide6.QtQuick.QSGNode, after: PySide6.QtQuick.QSGNode) -> None: ...
    def insertChildNodeBefore(self, node: PySide6.QtQuick.QSGNode, before: PySide6.QtQuick.QSGNode) -> None: ...
    def isSubtreeBlocked(self) -> bool: ...
    def lastChild(self) -> PySide6.QtQuick.QSGNode: ...
    def markDirty(self, bits: PySide6.QtQuick.QSGNode.DirtyState) -> None: ...
    def nextSibling(self) -> PySide6.QtQuick.QSGNode: ...
    def parent(self) -> PySide6.QtQuick.QSGNode: ...
    def prependChildNode(self, node: PySide6.QtQuick.QSGNode) -> None: ...
    def preprocess(self) -> None: ...
    def previousSibling(self) -> PySide6.QtQuick.QSGNode: ...
    def removeAllChildNodes(self) -> None: ...
    def removeChildNode(self, node: PySide6.QtQuick.QSGNode) -> None: ...
    def reparentChildNodesTo(self, newParent: PySide6.QtQuick.QSGNode) -> None: ...
    def setFlag(self, arg__1: PySide6.QtQuick.QSGNode.Flag, arg__2: bool = ...) -> None: ...
    def setFlags(self, arg__1: PySide6.QtQuick.QSGNode.Flags, arg__2: bool = ...) -> None: ...
    def type(self) -> PySide6.QtQuick.QSGNode.NodeType: ...


class QSGOpacityNode(PySide6.QtQuick.QSGNode):

    def __init__(self) -> None: ...

    def combinedOpacity(self) -> float: ...
    def isSubtreeBlocked(self) -> bool: ...
    def opacity(self) -> float: ...
    def setCombinedOpacity(self, opacity: float) -> None: ...
    def setOpacity(self, opacity: float) -> None: ...


class QSGSimpleRectNode(PySide6.QtQuick.QSGGeometryNode):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], color: Union[PySide6.QtGui.QColor, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...

    def color(self) -> PySide6.QtGui.QColor: ...
    def rect(self) -> PySide6.QtCore.QRectF: ...
    def setColor(self, color: Union[PySide6.QtGui.QColor, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    @typing.overload
    def setRect(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @typing.overload
    def setRect(self, x: float, y: float, w: float, h: float) -> None: ...


class QSGSimpleTextureNode(PySide6.QtQuick.QSGGeometryNode):
    NoTransform              : QSGSimpleTextureNode.TextureCoordinatesTransformFlag = ... # 0x0
    MirrorHorizontally       : QSGSimpleTextureNode.TextureCoordinatesTransformFlag = ... # 0x1
    MirrorVertically         : QSGSimpleTextureNode.TextureCoordinatesTransformFlag = ... # 0x2

    class TextureCoordinatesTransformFlag(Shiboken.Enum):
        NoTransform              : QSGSimpleTextureNode.TextureCoordinatesTransformFlag = ... # 0x0
        MirrorHorizontally       : QSGSimpleTextureNode.TextureCoordinatesTransformFlag = ... # 0x1
        MirrorVertically         : QSGSimpleTextureNode.TextureCoordinatesTransformFlag = ... # 0x2

    class TextureCoordinatesTransformMode(object): ...

    def __init__(self) -> None: ...

    def filtering(self) -> PySide6.QtQuick.QSGTexture.Filtering: ...
    def ownsTexture(self) -> bool: ...
    def rect(self) -> PySide6.QtCore.QRectF: ...
    def setFiltering(self, filtering: PySide6.QtQuick.QSGTexture.Filtering) -> None: ...
    def setOwnsTexture(self, owns: bool) -> None: ...
    @typing.overload
    def setRect(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @typing.overload
    def setRect(self, x: float, y: float, w: float, h: float) -> None: ...
    @typing.overload
    def setSourceRect(self, r: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @typing.overload
    def setSourceRect(self, x: float, y: float, w: float, h: float) -> None: ...
    def setTexture(self, texture: PySide6.QtQuick.QSGTexture) -> None: ...
    def setTextureCoordinatesTransform(self, mode: PySide6.QtQuick.QSGSimpleTextureNode.TextureCoordinatesTransformMode) -> None: ...
    def sourceRect(self) -> PySide6.QtCore.QRectF: ...
    def texture(self) -> PySide6.QtQuick.QSGTexture: ...
    def textureCoordinatesTransform(self) -> PySide6.QtQuick.QSGSimpleTextureNode.TextureCoordinatesTransformMode: ...


class QSGTexture(PySide6.QtCore.QObject):
    AnisotropyNone           : QSGTexture.AnisotropyLevel = ... # 0x0
    Anisotropy2x             : QSGTexture.AnisotropyLevel = ... # 0x1
    Anisotropy4x             : QSGTexture.AnisotropyLevel = ... # 0x2
    Anisotropy8x             : QSGTexture.AnisotropyLevel = ... # 0x3
    Anisotropy16x            : QSGTexture.AnisotropyLevel = ... # 0x4
    None_                    : QSGTexture.Filtering = ... # 0x0
    Nearest                  : QSGTexture.Filtering = ... # 0x1
    Linear                   : QSGTexture.Filtering = ... # 0x2
    Repeat                   : QSGTexture.WrapMode = ... # 0x0
    ClampToEdge              : QSGTexture.WrapMode = ... # 0x1
    MirroredRepeat           : QSGTexture.WrapMode = ... # 0x2

    class AnisotropyLevel(Shiboken.Enum):
        AnisotropyNone           : QSGTexture.AnisotropyLevel = ... # 0x0
        Anisotropy2x             : QSGTexture.AnisotropyLevel = ... # 0x1
        Anisotropy4x             : QSGTexture.AnisotropyLevel = ... # 0x2
        Anisotropy8x             : QSGTexture.AnisotropyLevel = ... # 0x3
        Anisotropy16x            : QSGTexture.AnisotropyLevel = ... # 0x4

    class Filtering(Shiboken.Enum):
        None_                    : QSGTexture.Filtering = ... # 0x0
        Nearest                  : QSGTexture.Filtering = ... # 0x1
        Linear                   : QSGTexture.Filtering = ... # 0x2

    class WrapMode(Shiboken.Enum):
        Repeat                   : QSGTexture.WrapMode = ... # 0x0
        ClampToEdge              : QSGTexture.WrapMode = ... # 0x1
        MirroredRepeat           : QSGTexture.WrapMode = ... # 0x2

    def __init__(self) -> None: ...

    def anisotropyLevel(self) -> PySide6.QtQuick.QSGTexture.AnisotropyLevel: ...
    def comparisonKey(self) -> int: ...
    def convertToNormalizedSourceRect(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtCore.QRectF: ...
    def filtering(self) -> PySide6.QtQuick.QSGTexture.Filtering: ...
    def hasAlphaChannel(self) -> bool: ...
    def hasMipmaps(self) -> bool: ...
    def horizontalWrapMode(self) -> PySide6.QtQuick.QSGTexture.WrapMode: ...
    def isAtlasTexture(self) -> bool: ...
    def mipmapFiltering(self) -> PySide6.QtQuick.QSGTexture.Filtering: ...
    def normalizedTextureSubRect(self) -> PySide6.QtCore.QRectF: ...
    def setAnisotropyLevel(self, level: PySide6.QtQuick.QSGTexture.AnisotropyLevel) -> None: ...
    def setFiltering(self, filter: PySide6.QtQuick.QSGTexture.Filtering) -> None: ...
    def setHorizontalWrapMode(self, hwrap: PySide6.QtQuick.QSGTexture.WrapMode) -> None: ...
    def setMipmapFiltering(self, filter: PySide6.QtQuick.QSGTexture.Filtering) -> None: ...
    def setVerticalWrapMode(self, vwrap: PySide6.QtQuick.QSGTexture.WrapMode) -> None: ...
    def textureSize(self) -> PySide6.QtCore.QSize: ...
    def verticalWrapMode(self) -> PySide6.QtQuick.QSGTexture.WrapMode: ...


class QSGTextureProvider(PySide6.QtCore.QObject):

    def __init__(self) -> None: ...

    def texture(self) -> PySide6.QtQuick.QSGTexture: ...


class QSGTransformNode(PySide6.QtQuick.QSGNode):

    def __init__(self) -> None: ...

    def combinedMatrix(self) -> PySide6.QtGui.QMatrix4x4: ...
    def matrix(self) -> PySide6.QtGui.QMatrix4x4: ...
    def setCombinedMatrix(self, matrix: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform]) -> None: ...
    def setMatrix(self, matrix: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform]) -> None: ...

# eof
