/* Autogenerated by mlir-tblgen; don't manually edit */
#ifdef GEN_PASS_CLASSES

//===----------------------------------------------------------------------===//
// BufferPacking
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class BufferPackingBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = BufferPackingBase;

  BufferPackingBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  BufferPackingBase(const BufferPackingBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("buffer-packing");
  }
  ::llvm::StringRef getArgument() const override { return "buffer-packing"; }

  ::llvm::StringRef getDescription() const override { return "Pass to pack allocated buffer to reduce memory consumption."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("BufferPacking");
  }
  ::llvm::StringRef getName() const override { return "BufferPacking"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<func::FuncDialect>();

  registry.insert<memref::MemRefDialect>();

  registry.insert<arith::ArithmeticDialect>();

  }

protected:
  ::mlir::Pass::Option<unsigned> window_size_{*this, "window-size", ::llvm::cl::desc("The window size blurs the start position of anallocated buffer. Buffers allocated in the same sliding window areaare treated equally in terms of starting position, withing thesliding window area they are sorted by memory size.A window size of zero sorts the buffers only by memory size."), ::llvm::cl::init(5)};
};

//===----------------------------------------------------------------------===//
// BufferReuse
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class BufferReuseBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = BufferReuseBase;

  BufferReuseBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  BufferReuseBase(const BufferReuseBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("buffer-reuse");
  }
  ::llvm::StringRef getArgument() const override { return "buffer-reuse"; }

  ::llvm::StringRef getDescription() const override { return "Reuses already allocated buffers to save allocation operations if it is provably safe."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("BufferReuse");
  }
  ::llvm::StringRef getName() const override { return "BufferReuse"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// CopyRemoval
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class CopyRemovalBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = CopyRemovalBase;

  CopyRemovalBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  CopyRemovalBase(const CopyRemovalBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("copy-removal");
  }
  ::llvm::StringRef getArgument() const override { return "copy-removal"; }

  ::llvm::StringRef getDescription() const override { return "Removes redundant operations that implement a CopyOpInterface, if the intersection of the useranges fromcopy source and target only contains the CopyOp."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("CopyRemoval");
  }
  ::llvm::StringRef getName() const override { return "CopyRemoval"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// MemoryCount
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class MemoryCountBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = MemoryCountBase;

  MemoryCountBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  MemoryCountBase(const MemoryCountBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("memory-count");
  }
  ::llvm::StringRef getArgument() const override { return "memory-count"; }

  ::llvm::StringRef getDescription() const override { return "Test pass to count the allocated memory of a module."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("MemoryCount");
  }
  ::llvm::StringRef getName() const override { return "MemoryCount"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// SymbolicShapeOptimization
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class SymbolicShapeOptimizationBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = SymbolicShapeOptimizationBase;

  SymbolicShapeOptimizationBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  SymbolicShapeOptimizationBase(const SymbolicShapeOptimizationBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("symbolic-shape-optimization");
  }
  ::llvm::StringRef getArgument() const override { return "symbolic-shape-optimization"; }

  ::llvm::StringRef getDescription() const override { return "Analyzes shapes and performs shape-related optimizations"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("SymbolicShapeOptimization");
  }
  ::llvm::StringRef getName() const override { return "SymbolicShapeOptimization"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// TestShapeComponentAnalysis
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class TestShapeComponentAnalysisBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = TestShapeComponentAnalysisBase;

  TestShapeComponentAnalysisBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  TestShapeComponentAnalysisBase(const TestShapeComponentAnalysisBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("test-print-shape-components");
  }
  ::llvm::StringRef getArgument() const override { return "test-print-shape-components"; }

  ::llvm::StringRef getDescription() const override { return "Test pass for analyzing shape components."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TestShapeComponentAnalysis");
  }
  ::llvm::StringRef getName() const override { return "TestShapeComponentAnalysis"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// TestUserange
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class TestUserangeBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = TestUserangeBase;

  TestUserangeBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  TestUserangeBase(const TestUserangeBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("test-print-userange");
  }
  ::llvm::StringRef getArgument() const override { return "test-print-userange"; }

  ::llvm::StringRef getDescription() const override { return "Test pass for checking userange intervals."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TestUserange");
  }
  ::llvm::StringRef getName() const override { return "TestUserange"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// BufferPacking Registration
//===----------------------------------------------------------------------===//

inline void registerBufferPackingPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createBufferPackingPass();
  });
}

//===----------------------------------------------------------------------===//
// BufferReuse Registration
//===----------------------------------------------------------------------===//

inline void registerBufferReusePass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createBufferReusePass();
  });
}

//===----------------------------------------------------------------------===//
// CopyRemoval Registration
//===----------------------------------------------------------------------===//

inline void registerCopyRemovalPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createCopyRemovalPass();
  });
}

//===----------------------------------------------------------------------===//
// MemoryCount Registration
//===----------------------------------------------------------------------===//

inline void registerMemoryCountPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createMemoryCountPass();
  });
}

//===----------------------------------------------------------------------===//
// SymbolicShapeOptimization Registration
//===----------------------------------------------------------------------===//

inline void registerSymbolicShapeOptimizationPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createSymbolicShapeOptimizationPass();
  });
}

//===----------------------------------------------------------------------===//
// TestShapeComponentAnalysis Registration
//===----------------------------------------------------------------------===//

inline void registerTestShapeComponentAnalysisPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTestShapeComponentAnalysisPass();
  });
}

//===----------------------------------------------------------------------===//
// TestUserange Registration
//===----------------------------------------------------------------------===//

inline void registerTestUserangePass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTestUserangePass();
  });
}

//===----------------------------------------------------------------------===//
// LMHLOTransforms Registration
//===----------------------------------------------------------------------===//

inline void registerLMHLOTransformsPasses() {
  registerBufferPackingPass();
  registerBufferReusePass();
  registerCopyRemovalPass();
  registerMemoryCountPass();
  registerSymbolicShapeOptimizationPass();
  registerTestShapeComponentAnalysisPass();
  registerTestUserangePass();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
