# coding: utf-8

"""
    Carbon

    Connect external data to LLMs, no matter the source.

    The version of the OpenAPI document: 1.0.0
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal, TYPE_CHECKING
from pydantic import BaseModel, Field, RootModel, ConfigDict

from carbon.pydantic.helpdesk_file_types import HelpdeskFileTypes
from carbon.pydantic.transcription_service_nullable import TranscriptionServiceNullable

class FileSyncConfig(BaseModel):
    # File types to automatically sync when the data source connects. Only a subset of file types can be          controlled. If not supported, then they will always be synced
    auto_synced_source_types: typing.Optional[typing.List[HelpdeskFileTypes]] = Field(None, alias='auto_synced_source_types')

    # Automatically sync attachments from files where supported. Currently applies to Helpdesk Tickets
    sync_attachments: typing.Optional[bool] = Field(None, alias='sync_attachments')

    # Detect audio language before transcription for audio files
    detect_audio_language: typing.Optional[bool] = Field(None, alias='detect_audio_language')

    transcription_service: typing.Optional[TranscriptionServiceNullable] = Field(None, alias='transcription_service')

    # Detect multiple speakers and label segments of speech by speaker for audio files.
    include_speaker_labels: typing.Optional[bool] = Field(None, alias='include_speaker_labels')

    # Whether to split tabular rows into chunks. Currently only valid for CSV, TSV, and XLSX files.
    split_rows: typing.Optional[bool] = Field(None, alias='split_rows')

    model_config = ConfigDict(
        protected_namespaces=(),
        arbitrary_types_allowed=True
    )
