# coding: utf-8

"""
    Carbon

    Connect external data to LLMs, no matter the source.

    The version of the OpenAPI document: 1.0.0
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal, TYPE_CHECKING
from pydantic import BaseModel, Field, RootModel, ConfigDict

from carbon.pydantic.embedding_generators import EmbeddingGenerators
from carbon.pydantic.sitemap_scrape_request_css_classes_to_skip import SitemapScrapeRequestCssClassesToSkip
from carbon.pydantic.sitemap_scrape_request_css_selectors_to_skip import SitemapScrapeRequestCssSelectorsToSkip
from carbon.pydantic.sitemap_scrape_request_html_tags_to_skip import SitemapScrapeRequestHtmlTagsToSkip
from carbon.pydantic.sitemap_scrape_request_tags import SitemapScrapeRequestTags
from carbon.pydantic.sitemap_scrape_request_url_paths_to_exclude import SitemapScrapeRequestUrlPathsToExclude
from carbon.pydantic.sitemap_scrape_request_url_paths_to_include import SitemapScrapeRequestUrlPathsToInclude
from carbon.pydantic.sitemap_scrape_request_urls_to_scrape import SitemapScrapeRequestUrlsToScrape

class SitemapScrapeRequest(BaseModel):
    url: str = Field(alias='url')

    tags: typing.Optional[SitemapScrapeRequestTags] = Field(None, alias='tags')

    max_pages_to_scrape: typing.Optional[typing.Optional[int]] = Field(None, alias='max_pages_to_scrape')

    chunk_size: typing.Optional[typing.Optional[int]] = Field(None, alias='chunk_size')

    chunk_overlap: typing.Optional[typing.Optional[int]] = Field(None, alias='chunk_overlap')

    skip_embedding_generation: typing.Optional[typing.Optional[bool]] = Field(None, alias='skip_embedding_generation')

    enable_auto_sync: typing.Optional[typing.Optional[bool]] = Field(None, alias='enable_auto_sync')

    generate_sparse_vectors: typing.Optional[typing.Optional[bool]] = Field(None, alias='generate_sparse_vectors')

    prepend_filename_to_chunks: typing.Optional[typing.Optional[bool]] = Field(None, alias='prepend_filename_to_chunks')

    html_tags_to_skip: typing.Optional[SitemapScrapeRequestHtmlTagsToSkip] = Field(None, alias='html_tags_to_skip')

    css_classes_to_skip: typing.Optional[SitemapScrapeRequestCssClassesToSkip] = Field(None, alias='css_classes_to_skip')

    css_selectors_to_skip: typing.Optional[SitemapScrapeRequestCssSelectorsToSkip] = Field(None, alias='css_selectors_to_skip')

    embedding_model: typing.Optional[EmbeddingGenerators] = Field(None, alias='embedding_model')

    url_paths_to_include: typing.Optional[SitemapScrapeRequestUrlPathsToInclude] = Field(None, alias='url_paths_to_include')

    url_paths_to_exclude: typing.Optional[SitemapScrapeRequestUrlPathsToExclude] = Field(None, alias='url_paths_to_exclude')

    urls_to_scrape: typing.Optional[SitemapScrapeRequestUrlsToScrape] = Field(None, alias='urls_to_scrape')

    # Whether the scraper should download css and media from the page (images, fonts, etc). Scrapes          might take longer to finish with this flag enabled, but the success rate is improved.
    download_css_and_media: typing.Optional[typing.Optional[bool]] = Field(None, alias='download_css_and_media')

    model_config = ConfigDict(
        protected_namespaces=(),
        arbitrary_types_allowed=True
    )
