# coding: utf-8

"""
    Carbon

    Connect external data to LLMs, no matter the source.

    The version of the OpenAPI document: 1.0.0
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal, TYPE_CHECKING

from carbon.type.embedding_generators_nullable import EmbeddingGeneratorsNullable
from carbon.type.file_content_types_nullable import FileContentTypesNullable
from carbon.type.get_embedding_documents_body_file_ids import GetEmbeddingDocumentsBodyFileIds
from carbon.type.get_embedding_documents_body_parent_file_ids import GetEmbeddingDocumentsBodyParentFileIds
from carbon.type.get_embedding_documents_body_query_vector import GetEmbeddingDocumentsBodyQueryVector
from carbon.type.get_embedding_documents_body_tags import GetEmbeddingDocumentsBodyTags
from carbon.type.helpdesk_file_types import HelpdeskFileTypes
from carbon.type.hybrid_search_tuning_params_nullable import HybridSearchTuningParamsNullable
from carbon.type.rerank_params_nullable import RerankParamsNullable

class RequiredGetEmbeddingDocumentsBody(TypedDict):
    # Query for which to get related chunks and embeddings.
    query: str

    # Number of related chunks to return.
    k: int


class OptionalGetEmbeddingDocumentsBody(TypedDict, total=False):
    tags: typing.Optional[GetEmbeddingDocumentsBodyTags]

    query_vector: typing.Optional[GetEmbeddingDocumentsBodyQueryVector]

    file_ids: typing.Optional[GetEmbeddingDocumentsBodyFileIds]

    # WARNING: This property is deprecated
    parent_file_ids: typing.Optional[GetEmbeddingDocumentsBodyParentFileIds]

    # Flag to control whether or not to include all children of filtered files in the embedding search.
    include_all_children: bool

    # A set of tags to limit the search to. Use this instead of `tags`, which is deprecated.
    tags_v2: typing.Optional[typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]]

    # Flag to control whether or not to include tags for each chunk in the response.
    include_tags: typing.Optional[bool]

    # Flag to control whether or not to include embedding vectors in the response.
    include_vectors: typing.Optional[bool]

    # Flag to control whether or not to include a signed URL to the raw file containing each chunk         in the response.
    include_raw_file: typing.Optional[bool]

    # Flag to control whether or not to perform hybrid search.
    hybrid_search: typing.Optional[bool]

    hybrid_search_tuning_parameters: typing.Optional[HybridSearchTuningParamsNullable]

    media_type: typing.Optional[FileContentTypesNullable]

    embedding_model: typing.Optional[EmbeddingGeneratorsNullable]

    # Flag to control whether or not to include file-level metadata in the response. This metadata         will be included in the `content_metadata` field of each document along with chunk/embedding level metadata.
    include_file_level_metadata: typing.Optional[bool]

    # Flag to control whether or not to perform a high accuracy embedding search. By default, this is set to false.         If true, the search may return more accurate results, but may take longer to complete.
    high_accuracy: typing.Optional[bool]

    rerank: typing.Optional[RerankParamsNullable]

    # Filter files based on their type at the source (for example help center tickets and articles)
    file_types_at_source: typing.Optional[typing.List[HelpdeskFileTypes]]

    # Flag to control whether or not to exclude files that are not in hot storage. If set to False, then an error will be returned if any filtered         files are in cold storage.
    exclude_cold_storage_files: bool

class GetEmbeddingDocumentsBody(RequiredGetEmbeddingDocumentsBody, OptionalGetEmbeddingDocumentsBody):
    pass
