# noahENERGY-phoenix_sdk
Base API for Glumanda and other services.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: Alpha
- Package version: v2.6.0-dev.18
- Generator version: 7.11.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.8+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import phoenix_sdk
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import phoenix_sdk
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import phoenix_sdk
from phoenix_sdk.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = phoenix_sdk.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: APIKeyHeader
configuration.api_key['APIKeyHeader'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['APIKeyHeader'] = 'Bearer'

# Configure API key authorization: APIKeyQuery
configuration.api_key['APIKeyQuery'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['APIKeyQuery'] = 'Bearer'


# Enter a context with an instance of the API client
with phoenix_sdk.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = phoenix_sdk.AddressApi(api_client)
    id = 'id_example' # str | 

    try:
        # Delete Address
        api_instance.addresses_delete(id)
    except ApiException as e:
        print("Exception when calling AddressApi->addresses_delete: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AddressApi* | [**addresses_delete**](docs/AddressApi.md#addresses_delete) | **DELETE** /addresses/{id}/ | Delete Address
*AddressApi* | [**addresses_get**](docs/AddressApi.md#addresses_get) | **GET** /addresses/{id}/ | Get Address
*AddressApi* | [**addresses_list**](docs/AddressApi.md#addresses_list) | **GET** /addresses/ | Get Addresses
*AddressApi* | [**addresses_patch**](docs/AddressApi.md#addresses_patch) | **PATCH** /addresses/{id}/ | Patch Address
*AddressApi* | [**addresses_post**](docs/AddressApi.md#addresses_post) | **POST** /addresses/ | Create Address
*CompanyApi* | [**companies_delete**](docs/CompanyApi.md#companies_delete) | **DELETE** /companies/{id}/ | Delete Company
*CompanyApi* | [**companies_get**](docs/CompanyApi.md#companies_get) | **GET** /companies/{id}/ | Get Company
*CompanyApi* | [**companies_list**](docs/CompanyApi.md#companies_list) | **GET** /companies/ | Get Companies
*CompanyApi* | [**companies_members_delete**](docs/CompanyApi.md#companies_members_delete) | **DELETE** /companies/{id}/members/{sub} | Delete Member
*CompanyApi* | [**companies_members_get**](docs/CompanyApi.md#companies_members_get) | **GET** /companies/{id}/members/ | Get Members List
*CompanyApi* | [**companies_members_post**](docs/CompanyApi.md#companies_members_post) | **POST** /companies/{id}/members/{sub} | Post Member
*CompanyApi* | [**companies_patch**](docs/CompanyApi.md#companies_patch) | **PATCH** /companies/{id}/ | Patch Company
*CompanyApi* | [**companies_post**](docs/CompanyApi.md#companies_post) | **POST** /companies/ | Create Company
*CompanyApi* | [**companies_put**](docs/CompanyApi.md#companies_put) | **PUT** /companies/{id}/ | Put Company
*CompanyApi* | [**companies_run_influx_query_get**](docs/CompanyApi.md#companies_run_influx_query_get) | **GET** /companies/{id}/run_influx_query | Run Influx Query
*CompanyApi* | [**companies_write_bulk_data_post**](docs/CompanyApi.md#companies_write_bulk_data_post) | **POST** /companies/{id}/write_bulk_data/ | Write Bulk Data
*DeviceApi* | [**configs_delete**](docs/DeviceApi.md#configs_delete) | **DELETE** /configs/{id}/ | Delete Device Config
*DeviceApi* | [**configs_get**](docs/DeviceApi.md#configs_get) | **GET** /configs/{id}/ | Get Device Config
*DeviceApi* | [**configs_list**](docs/DeviceApi.md#configs_list) | **GET** /configs/ | Get Device Configs
*DeviceApi* | [**configs_patch**](docs/DeviceApi.md#configs_patch) | **PATCH** /configs/{id}/ | Patch Device Config
*DeviceApi* | [**configs_post**](docs/DeviceApi.md#configs_post) | **POST** /configs/ | Create Device Config
*DeviceApi* | [**devices_delete**](docs/DeviceApi.md#devices_delete) | **DELETE** /devices/{id}/ | Delete Device
*DeviceApi* | [**devices_devicetype_post**](docs/DeviceApi.md#devices_devicetype_post) | **POST** /devices/devicetype | Create Device Type
*DeviceApi* | [**devices_downlink_put**](docs/DeviceApi.md#devices_downlink_put) | **PUT** /devices/{id}/downlink/ | Send Downlink
*DeviceApi* | [**devices_flush_queue_put**](docs/DeviceApi.md#devices_flush_queue_put) | **PUT** /devices/{id}/flush_queue | Flush Queue
*DeviceApi* | [**devices_get**](docs/DeviceApi.md#devices_get) | **GET** /devices/{id}/ | Get Device
*DeviceApi* | [**devices_list**](docs/DeviceApi.md#devices_list) | **GET** /devices/ | Get Devices
*DeviceApi* | [**devices_patch**](docs/DeviceApi.md#devices_patch) | **PATCH** /devices/{id}/ | Patch Device
*DeviceApi* | [**devices_post**](docs/DeviceApi.md#devices_post) | **POST** /devices/ | Create Device
*DeviceApi* | [**devices_transfer_patch**](docs/DeviceApi.md#devices_transfer_patch) | **PATCH** /devices/transfer/ | Change Companies
*DeviceApi* | [**devices_translate_config_key_get**](docs/DeviceApi.md#devices_translate_config_key_get) | **GET** /devices/{id}/translate_config_key/ | Translate Config Db Key
*DeviceApi* | [**devices_write_put**](docs/DeviceApi.md#devices_write_put) | **PUT** /devices/{id}/write/ | Write Device
*GatewaysApi* | [**gateways_delete**](docs/GatewaysApi.md#gateways_delete) | **DELETE** /gateways/{id}/ | Delete Gateway
*GatewaysApi* | [**gateways_get**](docs/GatewaysApi.md#gateways_get) | **GET** /gateways/{id}/ | Get Gateway
*GatewaysApi* | [**gateways_list**](docs/GatewaysApi.md#gateways_list) | **GET** /gateways/ | Get Gateways
*GatewaysApi* | [**gateways_patch**](docs/GatewaysApi.md#gateways_patch) | **PATCH** /gateways/{id}/ | Patch Gateway
*GatewaysApi* | [**gateways_post**](docs/GatewaysApi.md#gateways_post) | **POST** /gateways/ | Create Gateway
*OrdersApi* | [**orders_all_list**](docs/OrdersApi.md#orders_all_list) | **GET** /orders/all | Get All Orders
*OrdersApi* | [**orders_claim_invoice_post**](docs/OrdersApi.md#orders_claim_invoice_post) | **POST** /orders/claim/invoice/{company_id} | Claim Order
*OrdersApi* | [**orders_claim_list**](docs/OrdersApi.md#orders_claim_list) | **GET** /orders/claim | Order Claim Items
*OrdersApi* | [**orders_csv_post**](docs/OrdersApi.md#orders_csv_post) | **POST** /orders/csv/ | Load Csv Order
*OrdersApi* | [**orders_current_list**](docs/OrdersApi.md#orders_current_list) | **GET** /orders/current | Get Current Order
*OrdersApi* | [**orders_delete**](docs/OrdersApi.md#orders_delete) | **DELETE** /orders/{order_id} | Delete Order
*OrdersApi* | [**orders_edit_patch**](docs/OrdersApi.md#orders_edit_patch) | **PATCH** /orders/edit/{order_id}/ | Edit Order
*OrdersApi* | [**orders_get**](docs/OrdersApi.md#orders_get) | **GET** /orders/{order_id}/ | Get Order
*OrdersApi* | [**orders_invoice_get**](docs/OrdersApi.md#orders_invoice_get) | **GET** /orders/invoice/{order_id}/ | Generate Invoice
*OrdersApi* | [**orders_item_patch**](docs/OrdersApi.md#orders_item_patch) | **PATCH** /orders/{order_id}/item/{item_id} | Delete Order Item
*OrdersApi* | [**orders_offer_get**](docs/OrdersApi.md#orders_offer_get) | **GET** /orders/offer/{order_id}/ | Generate Offer
*OrdersApi* | [**orders_post**](docs/OrdersApi.md#orders_post) | **POST** /orders/ | Add Order Items
*OrdersApi* | [**orders_put**](docs/OrdersApi.md#orders_put) | **PUT** /orders/{order_id}/ | Update Order Items
*StatsApi* | [**stats_list**](docs/StatsApi.md#stats_list) | **GET** /stats/ | Get Stats
*StripApi* | [**stripe_webhook_post**](docs/StripApi.md#stripe_webhook_post) | **POST** /stripe/webhook | Stripe Web Hook
*UnitApi* | [**groups_delete**](docs/UnitApi.md#groups_delete) | **DELETE** /groups/{id}/ | Delete Unit Group
*UnitApi* | [**groups_get**](docs/UnitApi.md#groups_get) | **GET** /groups/{id}/ | Get Unit Group
*UnitApi* | [**groups_list**](docs/UnitApi.md#groups_list) | **GET** /groups/ | Get Unit Groups
*UnitApi* | [**groups_post**](docs/UnitApi.md#groups_post) | **POST** /groups/ | Create Unit Group
*UnitApi* | [**units_delete**](docs/UnitApi.md#units_delete) | **DELETE** /units/{id}/ | Delete Unit
*UnitApi* | [**units_downlink_put**](docs/UnitApi.md#units_downlink_put) | **PUT** /units/{id}/downlink/ | Downlink Unit
*UnitApi* | [**units_events_delete**](docs/UnitApi.md#units_events_delete) | **DELETE** /units/{id}/events/{event_id} | Delete Unit Event
*UnitApi* | [**units_events_get**](docs/UnitApi.md#units_events_get) | **GET** /units/{id}/events/{event_id} | Get Unit Event
*UnitApi* | [**units_events_list**](docs/UnitApi.md#units_events_list) | **GET** /units/{id}/events | Get Unit Events
*UnitApi* | [**units_events_patch**](docs/UnitApi.md#units_events_patch) | **PATCH** /units/{id}/events/{event_id} | Patch Unit Event
*UnitApi* | [**units_events_post**](docs/UnitApi.md#units_events_post) | **POST** /units/{id}/events | Create Unit Event
*UnitApi* | [**units_flush_queue_put**](docs/UnitApi.md#units_flush_queue_put) | **PUT** /units/{id}/flush_queue | Flush Queue
*UnitApi* | [**units_get**](docs/UnitApi.md#units_get) | **GET** /units/{id}/ | Get Unit
*UnitApi* | [**units_list**](docs/UnitApi.md#units_list) | **GET** /units/ | Get Units
*UnitApi* | [**units_patch**](docs/UnitApi.md#units_patch) | **PATCH** /units/{id}/ | Patch Unit
*UnitApi* | [**units_post**](docs/UnitApi.md#units_post) | **POST** /units/ | Create Unit
*UnitApi* | [**units_write_put**](docs/UnitApi.md#units_write_put) | **PUT** /units/{id}/write/ | Write Unit Data


## Documentation For Models

 - [AddressSchemaIn](docs/AddressSchemaIn.md)
 - [AddressSchemaOut](docs/AddressSchemaOut.md)
 - [CompanyPatchSchemaIn](docs/CompanyPatchSchemaIn.md)
 - [CompanySchemaIn](docs/CompanySchemaIn.md)
 - [CompanySchemaOut](docs/CompanySchemaOut.md)
 - [CountryEnum](docs/CountryEnum.md)
 - [Data](docs/Data.md)
 - [DeviceConfigMin](docs/DeviceConfigMin.md)
 - [DeviceConfigSchemaIN](docs/DeviceConfigSchemaIN.md)
 - [DeviceConfigSchemaOUT](docs/DeviceConfigSchemaOUT.md)
 - [DeviceSchemaIN](docs/DeviceSchemaIN.md)
 - [DeviceSchemaOUT](docs/DeviceSchemaOUT.md)
 - [DeviceTypesSchemaIN](docs/DeviceTypesSchemaIN.md)
 - [DeviceTypesSchemaOUT](docs/DeviceTypesSchemaOUT.md)
 - [EventType](docs/EventType.md)
 - [GatewaySchemaIN](docs/GatewaySchemaIN.md)
 - [GatewaySchemaOut](docs/GatewaySchemaOut.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [OrderClaimInvoiceSchemaIN](docs/OrderClaimInvoiceSchemaIN.md)
 - [OrderClaimItemsSchemaOUT](docs/OrderClaimItemsSchemaOUT.md)
 - [OrderClaimStatus](docs/OrderClaimStatus.md)
 - [OrderStatus](docs/OrderStatus.md)
 - [PageAddressSchemaOut](docs/PageAddressSchemaOut.md)
 - [PageCompanySchemaOut](docs/PageCompanySchemaOut.md)
 - [PageDeviceConfigSchemaOUT](docs/PageDeviceConfigSchemaOUT.md)
 - [PageDeviceSchemaOUT](docs/PageDeviceSchemaOUT.md)
 - [PageUnitEventSchemaOut](docs/PageUnitEventSchemaOut.md)
 - [PageUnitGroupSchemaOut](docs/PageUnitGroupSchemaOut.md)
 - [PageUnitSchemaOut](docs/PageUnitSchemaOut.md)
 - [ShopOrderItemsSchemaIN](docs/ShopOrderItemsSchemaIN.md)
 - [ShopOrderSchemaIN](docs/ShopOrderSchemaIN.md)
 - [ShopOrderSchemaOUT](docs/ShopOrderSchemaOUT.md)
 - [StatsSchema](docs/StatsSchema.md)
 - [TransferDevices](docs/TransferDevices.md)
 - [UnitDataSchemaIN](docs/UnitDataSchemaIN.md)
 - [UnitEventSchemaIN](docs/UnitEventSchemaIN.md)
 - [UnitEventSchemaOut](docs/UnitEventSchemaOut.md)
 - [UnitGroupSchemaIN](docs/UnitGroupSchemaIN.md)
 - [UnitGroupSchemaOut](docs/UnitGroupSchemaOut.md)
 - [UnitSchemaIN](docs/UnitSchemaIN.md)
 - [UnitSchemaMin](docs/UnitSchemaMin.md)
 - [UnitSchemaOut](docs/UnitSchemaOut.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)
 - [Value](docs/Value.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="APIKeyQuery"></a>
### APIKeyQuery

- **Type**: API key
- **API key parameter name**: api-key
- **Location**: URL query string

<a id="APIKeyHeader"></a>
### APIKeyHeader

- **Type**: API key
- **API key parameter name**: x-api-key
- **Location**: HTTP header


## Author




