"""This file provides autocompletions for the ZOS-API and was automatically generated.
It should not be edited manually.
"""

from __future__ import annotations

__all__ = (
    "ICoordinateTransform",
    "IMatrixData",
    "IMetadata",
    "ISettingsData",
    "IVectorData",
    "SettingsDataType",
    "ZemaxColor",
    "ZemaxOpacity",
)

class ICoordinateTransform:
    @property
    def HasOffset(self) -> bool: ...
    @property
    def XOffset(self) -> float: ...
    @XOffset.setter
    def XOffset(self, value: float) -> None: ...
    @property
    def YOffset(self) -> float: ...
    @YOffset.setter
    def YOffset(self, value: float) -> None: ...
    @property
    def ZOffset(self) -> float: ...
    @ZOffset.setter
    def ZOffset(self, value: float) -> None: ...
    @property
    def HasRotation(self) -> bool: ...
    @property
    def R11(self) -> float: ...
    @R11.setter
    def R11(self, value: float) -> None: ...
    @property
    def R12(self) -> float: ...
    @R12.setter
    def R12(self, value: float) -> None: ...
    @property
    def R13(self) -> float: ...
    @R13.setter
    def R13(self, value: float) -> None: ...
    @property
    def R21(self) -> float: ...
    @R21.setter
    def R21(self, value: float) -> None: ...
    @property
    def R22(self) -> float: ...
    @R22.setter
    def R22(self, value: float) -> None: ...
    @property
    def R23(self) -> float: ...
    @R23.setter
    def R23(self, value: float) -> None: ...
    @property
    def R31(self) -> float: ...
    @R31.setter
    def R31(self, value: float) -> None: ...
    @property
    def R32(self) -> float: ...
    @R32.setter
    def R32(self, value: float) -> None: ...
    @property
    def R33(self) -> float: ...
    @R33.setter
    def R33(self, value: float) -> None: ...
    @property
    def RotationAnglesSpecified(self) -> bool: ...
    @RotationAnglesSpecified.setter
    def RotationAnglesSpecified(self, value: bool) -> None: ...
    @property
    def ThetaX(self) -> float: ...
    @ThetaX.setter
    def ThetaX(self, value: float) -> None: ...
    @property
    def ThetaY(self) -> float: ...
    @ThetaY.setter
    def ThetaY(self, value: float) -> None: ...
    @property
    def ThetaZ(self) -> float: ...
    @ThetaZ.setter
    def ThetaZ(self, value: float) -> None: ...
    @property
    def CentroidX(self) -> float: ...
    @CentroidX.setter
    def CentroidX(self, value: float) -> None: ...
    @property
    def CentroidY(self) -> float: ...
    @CentroidY.setter
    def CentroidY(self, value: float) -> None: ...
    @property
    def CentroidZ(self) -> float: ...
    @CentroidZ.setter
    def CentroidZ(self, value: float) -> None: ...
    def GetAngleSet(self) -> list[float]: ...
    def GetDecenterVector(self) -> list[float]: ...
    def GetMatrix_3x3(self) -> list[list[float]]: ...
    def GetMatrix_4x4(self) -> list[list[float]]: ...

class IMatrixData:
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def Rows(self) -> int: ...
    @property
    def Cols(self) -> int: ...
    @property
    def TotalLength(self) -> int: ...
    @property
    def Data(self) -> list[list[float]]: ...
    @Data.setter
    def Data(self, value: list[list[float]]) -> None: ...
    def GetValueAt(self, Row: int, Col: int) -> float: ...
    def ReadData(self, Size: int) -> tuple[list[float]]: ...
    def SetValueAt(self, Row: int, Col: int, Value: float) -> None: ...
    def WriteData(self, Size: int, Data: list[float]) -> None: ...

class IMetadata:
    @property
    def NumberOfKeys(self) -> int: ...
    def ConvertFromBinary(self, data: list[int]) -> str: ...
    def ConvertToBinary(self, s: str) -> list[int]: ...
    def CreateGuid(self) -> str: ...
    def GetData(self, key: str) -> str: ...
    def GetKeyName(self, keyNumber: int) -> str: ...
    def RemoveData(self, key: str) -> bool: ...
    def SetData(self, key: str, value: str) -> None: ...

class ISettingsData:
    @property
    def NumberOfSettings(self) -> int: ...
    def GetBooleanArray(self, key: str, Size: int) -> tuple[bool, list[bool]]: ...
    def GetBooleanValue(self, key: str) -> tuple[bool, bool]: ...
    def GetByteArray(self, key: str, Size: int) -> tuple[bool, list[int]]: ...
    def GetByteValue(self, key: str) -> tuple[bool, int]: ...
    def GetDoubleArray(self, key: str, Size: int) -> tuple[bool, list[float]]: ...
    def GetDoubleValue(self, key: str) -> tuple[bool, float]: ...
    def GetEntryType(self, key: str) -> tuple[bool, SettingsDataType, bool, int]: ...
    def GetFloatArray(self, key: str, Size: int) -> tuple[bool, list[float]]: ...
    def GetFloatValue(self, key: str) -> tuple[bool, float]: ...
    def GetIntegerArray(self, key: str, Size: int) -> tuple[bool, list[int]]: ...
    def GetIntegerValue(self, key: str) -> tuple[bool, int]: ...
    def GetKeys(self) -> list[str]: ...
    def GetStringValue(self, key: str) -> tuple[bool, str]: ...
    def SetBooleanArray(self, key: str, Size: int, val: list[bool]) -> None: ...
    def SetBooleanValue(self, key: str, val: bool) -> None: ...
    def SetByteArray(self, key: str, Size: int, val: list[int]) -> None: ...
    def SetByteValue(self, key: str, val: int) -> None: ...
    def SetDoubleArray(self, key: str, Size: int, val: list[float]) -> None: ...
    def SetDoubleValue(self, key: str, val: float) -> None: ...
    def SetFloatArray(self, key: str, Size: int, val: list[float]) -> None: ...
    def SetFloatValue(self, key: str, val: float) -> None: ...
    def SetIntegerArray(self, key: str, Size: int, val: list[int]) -> None: ...
    def SetIntegerValue(self, key: str, val: int) -> None: ...
    def SetStringValue(self, key: str, val: str) -> None: ...

class IVectorData:
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def Length(self) -> int: ...
    @property
    def Data(self) -> list[float]: ...
    @Data.setter
    def Data(self, value: list[float]) -> None: ...
    def GetValueAt(self, position: int) -> float: ...
    def ReadData(self, Size: int) -> tuple[list[float]]: ...
    def SetValueAt(self, position: int, Value: float) -> None: ...
    def WriteData(self, Size: int, Data: list[float]) -> None: ...

class SettingsDataType:
    # None = 0
    Integer = 1
    Double = 2
    Float = 3
    String = 4
    Byte = 5
    Boolean = 6

class ZemaxColor:
    Default = 0
    Color1 = 1
    Color2 = 2
    Color3 = 3
    Color4 = 4
    Color5 = 5
    Color6 = 6
    Color7 = 7
    Color8 = 8
    Color9 = 9
    Color10 = 10
    Color11 = 11
    Color12 = 12
    Color13 = 13
    Color14 = 14
    Color15 = 15
    Color16 = 16
    Color17 = 17
    Color18 = 18
    Color19 = 19
    Color20 = 20
    Color21 = 21
    Color22 = 22
    Color23 = 23
    Color24 = 24
    NoColor = 25

class ZemaxOpacity:
    P100 = 0
    P90 = 1
    P80 = 2
    P70 = 3
    P60 = 4
    P50 = 5
    P40 = 6
    P30 = 7
    P20 = 8
    P10 = 9
    P00 = 10
