"""This file provides autocompletions for the ZOS-API and was automatically generated.
It should not be edited manually.
"""

from __future__ import annotations

from zospy.api._ZOSAPI.Editors.LDE import SurfaceColumn
from zospy.api._ZOSAPI.Editors.NCE import ObjectColumn
from zospy.api._ZOSAPI.SystemData import FieldColumn

from . import LDE, MCE, MFE, NCE, TDE

__all__ = (
    "LDE",
    "MCE",
    "MFE",
    "NCE",
    "TDE",
    "CellDataType",
    "DirectionOfRayTravel",
    "EditorType",
    "ICoatingParameter",
    "IEditor",
    "IEditorCell",
    "IEditorRow",
    "ISolveAplanatic",
    "ISolveAutomatic",
    "ISolveCenterOfCurvature",
    "ISolveChiefRayAngle",
    "ISolveChiefRayHeight",
    "ISolveChiefRayNormal",
    "ISolveCocentricRadius",
    "ISolveCocentricSurface",
    "ISolveCompensator",
    "ISolveConfigPickup",
    "ISolveData",
    "ISolveDuplicateSag",
    "ISolveEdgeThickness",
    "ISolveElementPower",
    "ISolveFieldPickup",
    "ISolveFixed",
    "ISolveFNumber",
    "ISolveInvertSag",
    "ISolveMarginalRayAngle",
    "ISolveMarginalRayHeight",
    "ISolveMarginalRayNormal",
    "ISolveMaterialModel",
    "ISolveMaterialOffset",
    "ISolveMaterialSubstitute",
    "ISolveMaximum",
    "ISolveNone",
    "ISolveObjectPickup",
    "ISolveOpticalPathDifference",
    "ISolvePickupChiefRay",
    "ISolvePosition",
    "ISolvePupilPosition",
    "ISolveSurfacePickup",
    "ISolveThermalPickup",
    "ISolveVariable",
    "ISolveZPLMacro",
    "ReflectTransmitCode",
    "SampleSides",
    "Samplings",
    "SolveStatus",
    "SolveType",
)

class CellDataType:
    Integer = 0
    Double = 1
    String = 2

class DirectionOfRayTravel:
    inward = 0
    outward = 1

class EditorType:
    LDE = 0
    NCE = 1
    MFE = 2
    TDE = 3
    MCE = 4

class ICoatingParameter:
    @property
    def S(self) -> float: ...
    @S.setter
    def S(self, value: float) -> None: ...
    @property
    def P(self) -> float: ...
    @P.setter
    def P(self, value: float) -> None: ...

class IEditor:
    @property
    def Editor(self) -> EditorType: ...
    @property
    def NumberOfRows(self) -> int: ...
    @property
    def MinColumn(self) -> int: ...
    @property
    def MaxColumn(self) -> int: ...
    def AddRow(self) -> IEditorRow: ...
    def DeleteAllRows(self) -> int: ...
    def DeleteRowAt(self, pos: int) -> bool: ...
    def DeleteRowsAt(self, pos: int, numberOfRows: int) -> int: ...
    def GetRowAt(self, pos: int) -> IEditorRow: ...
    def HideEditor(self) -> None: ...
    def InsertRowAt(self, pos: int) -> IEditorRow: ...
    def ShowEditor(self) -> bool: ...

class IEditorCell:
    @property
    def Row(self) -> IEditorRow: ...
    @property
    def Col(self) -> int: ...
    @property
    def IsActive(self) -> bool: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def Header(self) -> str: ...
    @property
    def DataType(self) -> CellDataType: ...
    @property
    def IntegerValue(self) -> int: ...
    @IntegerValue.setter
    def IntegerValue(self, value: int) -> None: ...
    @property
    def DoubleValue(self) -> float: ...
    @DoubleValue.setter
    def DoubleValue(self, value: float) -> None: ...
    @property
    def Value(self) -> str: ...
    @Value.setter
    def Value(self, value: str) -> None: ...
    @property
    def Solve(self) -> SolveType: ...
    def CreateSolveType(self, type: SolveType) -> ISolveData: ...
    def FillAvailableSolveTypes(self, Length: int) -> tuple[list[SolveType]]: ...
    def GetAvailableSolveTypes(self) -> list[SolveType]: ...
    def GetNumberOfSolveTypes(self) -> int: ...
    def GetSolveData(self) -> ISolveData: ...
    def IsSolveTypeSupported(self, st: SolveType) -> bool: ...
    def MakeSolveFixed(self) -> bool: ...
    def MakeSolveVariable(self) -> bool: ...
    def SetSolveData(self, Data: ISolveData) -> SolveStatus: ...

class IEditorRow:
    @property
    def Editor(self) -> IEditor: ...
    @property
    def IsValidRow(self) -> bool: ...
    @property
    def RowIndex(self) -> int: ...
    @property
    def RowTypeName(self) -> str: ...
    @property
    def Bookmark(self) -> str: ...
    @Bookmark.setter
    def Bookmark(self, value: str) -> None: ...
    def GetCellAt(self, pos: int) -> IEditorCell: ...

class ISolveAplanatic(ISolveData): ...
class ISolveAutomatic(ISolveData): ...

class ISolveCenterOfCurvature(ISolveData):
    @property
    def RefSurface(self) -> int: ...
    @RefSurface.setter
    def RefSurface(self, value: int) -> None: ...

class ISolveChiefRayAngle(ISolveData):
    @property
    def Angle(self) -> float: ...
    @Angle.setter
    def Angle(self, value: float) -> None: ...

class ISolveChiefRayHeight(ISolveData):
    @property
    def Height(self) -> float: ...
    @Height.setter
    def Height(self, value: float) -> None: ...

class ISolveChiefRayNormal(ISolveData): ...

class ISolveCocentricRadius(ISolveData):
    @property
    def WithSurface(self) -> int: ...
    @WithSurface.setter
    def WithSurface(self, value: int) -> None: ...

class ISolveCocentricSurface(ISolveData):
    @property
    def AboutSurface(self) -> int: ...
    @AboutSurface.setter
    def AboutSurface(self, value: int) -> None: ...

class ISolveCompensator(ISolveData):
    @property
    def RefSurface(self) -> int: ...
    @RefSurface.setter
    def RefSurface(self, value: int) -> None: ...
    @property
    def Sum(self) -> float: ...
    @Sum.setter
    def Sum(self, value: float) -> None: ...

class ISolveConfigPickup(ISolveData):
    @property
    def Operand(self) -> int: ...
    @Operand.setter
    def Operand(self, value: int) -> None: ...
    @property
    def ScaleFactor(self) -> float: ...
    @ScaleFactor.setter
    def ScaleFactor(self, value: float) -> None: ...
    @property
    def SupportsScale(self) -> bool: ...
    @property
    def Offset(self) -> float: ...
    @Offset.setter
    def Offset(self, value: float) -> None: ...
    @property
    def Configuration(self) -> int: ...
    @Configuration.setter
    def Configuration(self, value: int) -> None: ...
    @property
    def SupportsOffset(self) -> bool: ...

class ISolveData:
    @property
    def IsValid(self) -> bool: ...
    @property
    def Type(self) -> SolveType: ...
    @property
    def _S_None(self) -> ISolveNone: ...
    @property
    def _S_Fixed(self) -> ISolveFixed: ...
    @property
    def _S_Variable(self) -> ISolveVariable: ...
    @property
    def _S_SurfacePickup(self) -> ISolveSurfacePickup: ...
    @property
    def _S_ZPLMacro(self) -> ISolveZPLMacro: ...
    @property
    def _S_MarginalRayAngle(self) -> ISolveMarginalRayAngle: ...
    @property
    def _S_MarginalRayHeight(self) -> ISolveMarginalRayHeight: ...
    @property
    def _S_ChiefRayAngle(self) -> ISolveChiefRayAngle: ...
    @property
    def _S_MarginalRayNormal(self) -> ISolveMarginalRayNormal: ...
    @property
    def _S_ChiefRayNormal(self) -> ISolveChiefRayNormal: ...
    @property
    def _S_Aplanatic(self) -> ISolveAplanatic: ...
    @property
    def _S_ElementPower(self) -> ISolveElementPower: ...
    @property
    def _S_CocentricSurface(self) -> ISolveCocentricSurface: ...
    @property
    def _S_CocentricRadius(self) -> ISolveCocentricRadius: ...
    @property
    def _S_FNumber(self) -> ISolveFNumber: ...
    @property
    def _S_ChiefRayHeight(self) -> ISolveChiefRayHeight: ...
    @property
    def _S_EdgeThickness(self) -> ISolveEdgeThickness: ...
    @property
    def _S_OpticalPathDifference(self) -> ISolveOpticalPathDifference: ...
    @property
    def _S_Position(self) -> ISolvePosition: ...
    @property
    def _S_Compensator(self) -> ISolveCompensator: ...
    @property
    def _S_CenterOfCurvature(self) -> ISolveCenterOfCurvature: ...
    @property
    def _S_PupilPosition(self) -> ISolvePupilPosition: ...
    @property
    def _S_MaterialModel(self) -> ISolveMaterialModel: ...
    @property
    def _S_MaterialSubstitute(self) -> ISolveMaterialSubstitute: ...
    @property
    def _S_MaterialOffset(self) -> ISolveMaterialOffset: ...
    @property
    def _S_Automatic(self) -> ISolveAutomatic: ...
    @property
    def _S_Maximum(self) -> ISolveMaximum: ...
    @property
    def _S_PickupChiefRay(self) -> ISolvePickupChiefRay: ...
    @property
    def _S_ObjectPickup(self) -> ISolveObjectPickup: ...
    @property
    def _S_ConfigPickup(self) -> ISolveConfigPickup: ...
    @property
    def _S_ThermalPickup(self) -> ISolveThermalPickup: ...
    @property
    def _S_FieldPickup(self) -> ISolveFieldPickup: ...
    @property
    def _S_DuplicateSag(self) -> ISolveDuplicateSag: ...
    @property
    def _S_InvertSag(self) -> ISolveInvertSag: ...

class ISolveDuplicateSag:
    @property
    def Surface(self) -> int: ...
    @Surface.setter
    def Surface(self, value: int) -> None: ...

class ISolveEdgeThickness(ISolveData):
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def RadialHeight(self) -> float: ...
    @RadialHeight.setter
    def RadialHeight(self, value: float) -> None: ...

class ISolveElementPower(ISolveData):
    @property
    def Power(self) -> float: ...
    @Power.setter
    def Power(self, value: float) -> None: ...

class ISolveFieldPickup(ISolveData):
    @property
    def Field(self) -> int: ...
    @Field.setter
    def Field(self, value: int) -> None: ...
    @property
    def ScaleFactor(self) -> float: ...
    @ScaleFactor.setter
    def ScaleFactor(self, value: float) -> None: ...
    @property
    def Offset(self) -> float: ...
    @Offset.setter
    def Offset(self, value: float) -> None: ...
    @property
    def Column(self) -> FieldColumn: ...
    @Column.setter
    def Column(self, value: FieldColumn) -> None: ...
    def IsPickupFromCurrentColumn(self) -> bool: ...
    def MakePickupFromCurrentColumn(self) -> None: ...

class ISolveFixed(ISolveData): ...

class ISolveFNumber(ISolveData):
    @property
    def FNumber(self) -> float: ...
    @FNumber.setter
    def FNumber(self, value: float) -> None: ...

class ISolveInvertSag:
    @property
    def Surface(self) -> int: ...
    @Surface.setter
    def Surface(self, value: int) -> None: ...

class ISolveMarginalRayAngle(ISolveData):
    @property
    def Angle(self) -> float: ...
    @Angle.setter
    def Angle(self, value: float) -> None: ...

class ISolveMarginalRayHeight(ISolveData):
    @property
    def Height(self) -> float: ...
    @Height.setter
    def Height(self, value: float) -> None: ...
    @property
    def PupilZone(self) -> float: ...
    @PupilZone.setter
    def PupilZone(self, value: float) -> None: ...

class ISolveMarginalRayNormal(ISolveData): ...

class ISolveMaterialModel(ISolveData):
    @property
    def IndexNd(self) -> float: ...
    @IndexNd.setter
    def IndexNd(self, value: float) -> None: ...
    @property
    def VaryIndex(self) -> bool: ...
    @VaryIndex.setter
    def VaryIndex(self, value: bool) -> None: ...
    @property
    def AbbeVd(self) -> float: ...
    @AbbeVd.setter
    def AbbeVd(self, value: float) -> None: ...
    @property
    def VaryAbbe(self) -> bool: ...
    @VaryAbbe.setter
    def VaryAbbe(self, value: bool) -> None: ...
    @property
    def dPgF(self) -> float: ...
    @dPgF.setter
    def dPgF(self, value: float) -> None: ...
    @property
    def VarydPgF(self) -> bool: ...
    @VarydPgF.setter
    def VarydPgF(self, value: bool) -> None: ...

class ISolveMaterialOffset(ISolveData):
    @property
    def NdOffset(self) -> float: ...
    @NdOffset.setter
    def NdOffset(self, value: float) -> None: ...
    @property
    def VdOffset(self) -> float: ...
    @VdOffset.setter
    def VdOffset(self, value: float) -> None: ...

class ISolveMaterialSubstitute(ISolveData):
    @property
    def Catalog(self) -> str: ...
    @Catalog.setter
    def Catalog(self, value: str) -> None: ...

class ISolveMaximum(ISolveData): ...
class ISolveNone(ISolveData): ...

class ISolveObjectPickup(ISolveData):
    @property
    def Object(self) -> int: ...
    @Object.setter
    def Object(self, value: int) -> None: ...
    @property
    def ScaleFactor(self) -> float: ...
    @ScaleFactor.setter
    def ScaleFactor(self, value: float) -> None: ...
    @property
    def SupportsScale(self) -> bool: ...
    @property
    def Offset(self) -> float: ...
    @Offset.setter
    def Offset(self, value: float) -> None: ...
    @property
    def SupportsOffset(self) -> bool: ...
    @property
    def Column(self) -> ObjectColumn: ...
    @Column.setter
    def Column(self, value: ObjectColumn) -> None: ...
    def IsPickupFromCurrentColumn(self) -> bool: ...
    def MakePickupFromCurrentColumn(self) -> None: ...

class ISolveOpticalPathDifference(ISolveData):
    @property
    def OPD(self) -> float: ...
    @OPD.setter
    def OPD(self, value: float) -> None: ...
    @property
    def PupilZone(self) -> float: ...
    @PupilZone.setter
    def PupilZone(self, value: float) -> None: ...

class ISolvePickupChiefRay(ISolveData):
    @property
    def Field(self) -> int: ...
    @Field.setter
    def Field(self, value: int) -> None: ...
    @property
    def Wavelength(self) -> int: ...
    @Wavelength.setter
    def Wavelength(self, value: int) -> None: ...

class ISolvePosition(ISolveData):
    @property
    def FromSurface(self) -> int: ...
    @FromSurface.setter
    def FromSurface(self, value: int) -> None: ...
    @property
    def Length(self) -> float: ...
    @Length.setter
    def Length(self, value: float) -> None: ...

class ISolvePupilPosition(ISolveData): ...

class ISolveSurfacePickup(ISolveData):
    @property
    def Surface(self) -> int: ...
    @Surface.setter
    def Surface(self, value: int) -> None: ...
    @property
    def ScaleFactor(self) -> float: ...
    @ScaleFactor.setter
    def ScaleFactor(self, value: float) -> None: ...
    @property
    def SupportsScale(self) -> bool: ...
    @property
    def Offset(self) -> float: ...
    @Offset.setter
    def Offset(self, value: float) -> None: ...
    @property
    def SupportsOffset(self) -> bool: ...
    @property
    def Column(self) -> SurfaceColumn: ...
    @Column.setter
    def Column(self, value: SurfaceColumn) -> None: ...
    def IsPickupFromCurrentColumn(self) -> bool: ...
    def MakePickupFromCurrentColumn(self) -> None: ...

class ISolveThermalPickup(ISolveData):
    @property
    def Configuration(self) -> int: ...
    @Configuration.setter
    def Configuration(self, value: int) -> None: ...

class ISolveVariable(ISolveData): ...

class ISolveZPLMacro(ISolveData):
    @property
    def Macro(self) -> str: ...
    @Macro.setter
    def Macro(self, value: str) -> None: ...
    def GetAvailableMacros(self) -> list[str]: ...

class ReflectTransmitCode:
    Success = 0
    NoReflectDataInFile = 1
    NoTransmitDataInFile = 2

class SampleSides:
    Front = 0
    Back = 1

class Samplings:
    FiveDegrees = 0
    TwoDegrees = 1
    OneDegree = 2

class SolveStatus:
    Success = 0
    InvalidSolveType = 1
    InvalidRow = 2
    InvalidColumn = 3
    PostSurfaceStopOnly = 4
    InvalidMacro = 5
    Failed = 10000

class SolveType:
    # None = 0
    Fixed = 1
    Variable = 2
    SurfacePickup = 3
    ZPLMacro = 4
    MarginalRayAngle = 5
    MarginalRayHeight = 6
    ChiefRayAngle = 7
    MarginalRayNormal = 8
    ChiefRayNormal = 9
    Aplanatic = 10
    ElementPower = 11
    CocentricSurface = 12
    ConcentricSurface = 12
    CocentricRadius = 13
    ConcentricRadius = 13
    FNumber = 14
    ChiefRayHeight = 15
    EdgeThickness = 16
    OpticalPathDifference = 17
    Position = 18
    Compensator = 19
    CenterOfCurvature = 20
    PupilPosition = 21
    MaterialSubstitute = 22
    MaterialOffset = 23
    MaterialModel = 24
    Automatic = 25
    Maximum = 26
    PickupChiefRay = 27
    ObjectPickup = 28
    ConfigPickup = 29
    ThermalPickup = 30
    MarginPercent = 31
    CA_fill = 32
    DIA_fill = 33
    DuplicateSag = 34
    InvertSag = 35
    FieldPickup = 10000
