"""
    Agent API

    This document refers to Symphony API calls to send and receive messages and content. They need the on-premise Agent installed to perform decryption/encryption of content.  - sessionToken and keyManagerToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - A new authorizationToken has been introduced in the authenticationAPI response payload. It can be used to replace the sessionToken in any of the API calls and can be passed as \"Authorization\" header. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have sent no message to any stream even if a request to some subset of the requested streams would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. - MessageML is a markup language for messages. See reference here: https://rest-api.symphony.com/docs/messagemlv2 - **Real Time Events**: The following events are returned when reading from a real time messages and events stream (\"datafeed\"). These events will be returned for datafeeds created with the v5 endpoints. To know more about the endpoints, refer to Create Messages/Events Stream and Read Messages/Events Stream. Unless otherwise specified, all events were added in 1.46.   # noqa: E501

    The version of the OpenAPI document: 22.5.1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from symphony.bdk.gen.api_client import ApiClient, Endpoint as _Endpoint
from symphony.bdk.gen.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from symphony.bdk.gen.agent_model.error import Error
from symphony.bdk.gen.agent_model.import_response_list import ImportResponseList
from symphony.bdk.gen.agent_model.message import Message
from symphony.bdk.gen.agent_model.message_import_list import MessageImportList
from symphony.bdk.gen.agent_model.message_list import MessageList
from symphony.bdk.gen.agent_model.message_search_query import MessageSearchQuery
from symphony.bdk.gen.agent_model.message_submission import MessageSubmission
from symphony.bdk.gen.agent_model.v2_error import V2Error
from symphony.bdk.gen.agent_model.v2_import_response_list import V2ImportResponseList
from symphony.bdk.gen.agent_model.v2_message import V2Message
from symphony.bdk.gen.agent_model.v2_message_import_list import V2MessageImportList
from symphony.bdk.gen.agent_model.v2_message_list import V2MessageList
from symphony.bdk.gen.agent_model.v2_message_submission import V2MessageSubmission
from symphony.bdk.gen.agent_model.v4_import_response_list import V4ImportResponseList
from symphony.bdk.gen.agent_model.v4_message import V4Message
from symphony.bdk.gen.agent_model.v4_message_blast_response import V4MessageBlastResponse
from symphony.bdk.gen.agent_model.v4_message_import_list import V4MessageImportList
from symphony.bdk.gen.agent_model.v4_message_list import V4MessageList


class MessagesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.v1_message_id_get_endpoint = _Endpoint(
            settings={
                'response_type': (V4Message,),
                'auth': [],
                'endpoint_path': '/v1/message/{id}',
                'operation_id': 'v1_message_id_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'key_manager_token',
                    'id',
                ],
                'required': [
                    'session_token',
                    'key_manager_token',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'id': 'id',
                },
                'location_map': {
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_message_import_post_endpoint = _Endpoint(
            settings={
                'response_type': (ImportResponseList,),
                'auth': [],
                'endpoint_path': '/v1/message/import',
                'operation_id': 'v1_message_import_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'key_manager_token',
                    'message_list',
                ],
                'required': [
                    'session_token',
                    'key_manager_token',
                    'message_list',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'message_list':
                        (MessageImportList,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                },
                'location_map': {
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'message_list': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v1_message_search_get_endpoint = _Endpoint(
            settings={
                'response_type': (V4MessageList,),
                'auth': [],
                'endpoint_path': '/v1/message/search',
                'operation_id': 'v1_message_search_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'query',
                    'session_token',
                    'key_manager_token',
                    'skip',
                    'limit',
                    'scope',
                    'sort_dir',
                ],
                'required': [
                    'query',
                    'session_token',
                    'key_manager_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'query':
                        (str,),
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'skip':
                        (int,),
                    'limit':
                        (int,),
                    'scope':
                        (str,),
                    'sort_dir':
                        (str,),
                },
                'attribute_map': {
                    'query': 'query',
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'skip': 'skip',
                    'limit': 'limit',
                    'scope': 'scope',
                    'sort_dir': 'sortDir',
                },
                'location_map': {
                    'query': 'query',
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'skip': 'query',
                    'limit': 'query',
                    'scope': 'query',
                    'sort_dir': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_message_search_post_endpoint = _Endpoint(
            settings={
                'response_type': (V4MessageList,),
                'auth': [],
                'endpoint_path': '/v1/message/search',
                'operation_id': 'v1_message_search_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'key_manager_token',
                    'query',
                    'skip',
                    'limit',
                    'scope',
                    'sort_dir',
                ],
                'required': [
                    'session_token',
                    'key_manager_token',
                    'query',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'query':
                        (MessageSearchQuery,),
                    'skip':
                        (int,),
                    'limit':
                        (int,),
                    'scope':
                        (str,),
                    'sort_dir':
                        (str,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'skip': 'skip',
                    'limit': 'limit',
                    'scope': 'scope',
                    'sort_dir': 'sortDir',
                },
                'location_map': {
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'query': 'body',
                    'skip': 'query',
                    'limit': 'query',
                    'scope': 'query',
                    'sort_dir': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v1_stream_sid_message_create_post_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [],
                'endpoint_path': '/v1/stream/{sid}/message/create',
                'operation_id': 'v1_stream_sid_message_create_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'sid',
                    'session_token',
                    'key_manager_token',
                    'message',
                ],
                'required': [
                    'sid',
                    'session_token',
                    'key_manager_token',
                    'message',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sid':
                        (str,),
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'message':
                        (MessageSubmission,),
                },
                'attribute_map': {
                    'sid': 'sid',
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                },
                'location_map': {
                    'sid': 'path',
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'message': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v1_stream_sid_message_get_endpoint = _Endpoint(
            settings={
                'response_type': (MessageList,),
                'auth': [],
                'endpoint_path': '/v1/stream/{sid}/message',
                'operation_id': 'v1_stream_sid_message_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'sid',
                    'since',
                    'session_token',
                    'key_manager_token',
                    'offset',
                    'max_messages',
                ],
                'required': [
                    'sid',
                    'since',
                    'session_token',
                    'key_manager_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sid':
                        (str,),
                    'since':
                        (int,),
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'offset':
                        (int,),
                    'max_messages':
                        (int,),
                },
                'attribute_map': {
                    'sid': 'sid',
                    'since': 'since',
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'offset': 'offset',
                    'max_messages': 'maxMessages',
                },
                'location_map': {
                    'sid': 'path',
                    'since': 'query',
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'offset': 'query',
                    'max_messages': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v2_message_import_post_endpoint = _Endpoint(
            settings={
                'response_type': (V2ImportResponseList,),
                'auth': [],
                'endpoint_path': '/v2/message/import',
                'operation_id': 'v2_message_import_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'key_manager_token',
                    'message_list',
                ],
                'required': [
                    'session_token',
                    'key_manager_token',
                    'message_list',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'message_list':
                        (V2MessageImportList,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                },
                'location_map': {
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'message_list': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v2_stream_sid_message_create_post_endpoint = _Endpoint(
            settings={
                'response_type': (V2Message,),
                'auth': [],
                'endpoint_path': '/v2/stream/{sid}/message/create',
                'operation_id': 'v2_stream_sid_message_create_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'sid',
                    'session_token',
                    'key_manager_token',
                    'message',
                ],
                'required': [
                    'sid',
                    'session_token',
                    'key_manager_token',
                    'message',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sid':
                        (str,),
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'message':
                        (V2MessageSubmission,),
                },
                'attribute_map': {
                    'sid': 'sid',
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                },
                'location_map': {
                    'sid': 'path',
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'message': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v2_stream_sid_message_get_endpoint = _Endpoint(
            settings={
                'response_type': (V2MessageList,),
                'auth': [],
                'endpoint_path': '/v2/stream/{sid}/message',
                'operation_id': 'v2_stream_sid_message_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'sid',
                    'since',
                    'session_token',
                    'key_manager_token',
                    'offset',
                    'limit',
                ],
                'required': [
                    'sid',
                    'since',
                    'session_token',
                    'key_manager_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sid':
                        (str,),
                    'since':
                        (int,),
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'offset':
                        (int,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'sid': 'sid',
                    'since': 'since',
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'offset': 'offset',
                    'limit': 'limit',
                },
                'location_map': {
                    'sid': 'path',
                    'since': 'query',
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'offset': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v3_stream_sid_message_create_post_endpoint = _Endpoint(
            settings={
                'response_type': (V2Message,),
                'auth': [],
                'endpoint_path': '/v3/stream/{sid}/message/create',
                'operation_id': 'v3_stream_sid_message_create_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'sid',
                    'session_token',
                    'message',
                    'key_manager_token',
                ],
                'required': [
                    'sid',
                    'session_token',
                    'message',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sid':
                        (str,),
                    'session_token':
                        (str,),
                    'message':
                        (V2MessageSubmission,),
                    'key_manager_token':
                        (str,),
                },
                'attribute_map': {
                    'sid': 'sid',
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                },
                'location_map': {
                    'sid': 'path',
                    'session_token': 'header',
                    'message': 'body',
                    'key_manager_token': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v4_message_blast_post_endpoint = _Endpoint(
            settings={
                'response_type': (V4MessageBlastResponse,),
                'auth': [],
                'endpoint_path': '/v4/message/blast',
                'operation_id': 'v4_message_blast_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'sids',
                    'key_manager_token',
                    'message',
                    'data',
                    'version',
                    'attachment',
                    'preview',
                ],
                'required': [
                    'session_token',
                    'sids',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'sids':
                        ([str],),
                    'key_manager_token':
                        (str,),
                    'message':
                        (str,),
                    'data':
                        (str,),
                    'version':
                        (str,),
                    'attachment':
                        (file_type,),
                    'preview':
                        (file_type,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'sids': 'sids',
                    'key_manager_token': 'keyManagerToken',
                    'message': 'message',
                    'data': 'data',
                    'version': 'version',
                    'attachment': 'attachment',
                    'preview': 'preview',
                },
                'location_map': {
                    'session_token': 'header',
                    'sids': 'form',
                    'key_manager_token': 'header',
                    'message': 'form',
                    'data': 'form',
                    'version': 'form',
                    'attachment': 'form',
                    'preview': 'form',
                },
                'collection_format_map': {
                    'sids': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.v4_message_import_post_endpoint = _Endpoint(
            settings={
                'response_type': (V4ImportResponseList,),
                'auth': [],
                'endpoint_path': '/v4/message/import',
                'operation_id': 'v4_message_import_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'key_manager_token',
                    'message_list',
                ],
                'required': [
                    'session_token',
                    'key_manager_token',
                    'message_list',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'message_list':
                        (V4MessageImportList,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                },
                'location_map': {
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'message_list': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v4_stream_sid_message_create_post_endpoint = _Endpoint(
            settings={
                'response_type': (V4Message,),
                'auth': [],
                'endpoint_path': '/v4/stream/{sid}/message/create',
                'operation_id': 'v4_stream_sid_message_create_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'sid',
                    'session_token',
                    'key_manager_token',
                    'message',
                    'data',
                    'version',
                    'attachment',
                    'preview',
                ],
                'required': [
                    'sid',
                    'session_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sid':
                        (str,),
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'message':
                        (str,),
                    'data':
                        (str,),
                    'version':
                        (str,),
                    'attachment':
                        (file_type,),
                    'preview':
                        (file_type,),
                },
                'attribute_map': {
                    'sid': 'sid',
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'message': 'message',
                    'data': 'data',
                    'version': 'version',
                    'attachment': 'attachment',
                    'preview': 'preview',
                },
                'location_map': {
                    'sid': 'path',
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'message': 'form',
                    'data': 'form',
                    'version': 'form',
                    'attachment': 'form',
                    'preview': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.v4_stream_sid_message_get_endpoint = _Endpoint(
            settings={
                'response_type': (V4MessageList,),
                'auth': [],
                'endpoint_path': '/v4/stream/{sid}/message',
                'operation_id': 'v4_stream_sid_message_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'sid',
                    'since',
                    'session_token',
                    'key_manager_token',
                    'skip',
                    'limit',
                ],
                'required': [
                    'sid',
                    'since',
                    'session_token',
                    'key_manager_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sid':
                        (str,),
                    'since':
                        (int,),
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'skip':
                        (int,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'sid': 'sid',
                    'since': 'since',
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'skip': 'skip',
                    'limit': 'limit',
                },
                'location_map': {
                    'sid': 'path',
                    'since': 'query',
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'skip': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v4_stream_sid_message_mid_update_post_endpoint = _Endpoint(
            settings={
                'response_type': (V4Message,),
                'auth': [],
                'endpoint_path': '/v4/stream/{sid}/message/{mid}/update',
                'operation_id': 'v4_stream_sid_message_mid_update_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'sid',
                    'mid',
                    'session_token',
                    'key_manager_token',
                    'message',
                    'data',
                    'version',
                    'silent',
                ],
                'required': [
                    'sid',
                    'mid',
                    'session_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sid':
                        (str,),
                    'mid':
                        (str,),
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'message':
                        (str,),
                    'data':
                        (str,),
                    'version':
                        (str,),
                    'silent':
                        (str,),
                },
                'attribute_map': {
                    'sid': 'sid',
                    'mid': 'mid',
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'message': 'message',
                    'data': 'data',
                    'version': 'version',
                    'silent': 'silent',
                },
                'location_map': {
                    'sid': 'path',
                    'mid': 'path',
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'message': 'form',
                    'data': 'form',
                    'version': 'form',
                    'silent': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )

    def v1_message_id_get(
        self,
        session_token,
        key_manager_token,
        id,
        **kwargs
    ):
        """Get a message by ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v1_message_id_get(session_token, key_manager_token, id, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.
            id (str): Message ID as a URL-safe string

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V4Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        kwargs['id'] = \
            id
        return self.v1_message_id_get_endpoint.call_with_http_info(**kwargs)

    def v1_message_import_post(
        self,
        session_token,
        key_manager_token,
        message_list,
        **kwargs
    ):
        """Import messages from other systems into Symphony.  # noqa: E501

        Sends a message to be imported into the system. Allows you to override the timestamp and author of the message with your desired values. The requesting user must have the Content Management role. The user that the message is intended to have come from must also be present in the conversation. The intended message timestamp must be a valid time from the past. It cannot be a future timestamp.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v1_message_import_post(session_token, key_manager_token, message_list, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.
            message_list (MessageImportList):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ImportResponseList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        kwargs['message_list'] = \
            message_list
        return self.v1_message_import_post_endpoint.call_with_http_info(**kwargs)

    def v1_message_search_get(
        self,
        query,
        session_token,
        key_manager_token,
        **kwargs
    ):
        """Search messages  # noqa: E501

        Search messages according to the specified criteria. The \"query\" parameter takes a search query defined as \"field:value\" pairs combined by the operator \"AND\" (e.g. \"text:foo AND autor:bar\"). Supported fields are  (case-insensitive): \"text\", \"author\", \"hashtag\", \"cashtag\", \"mention\", \"signal\", \"fromDate\", \"toDate\",  \"streamId\", \"streamType\".  \"text\" search requires a \"streamId\" to be specified.  \"streamType\" accepts one of the following values: \"chat\" (IMs and MIMs), \"im\", \"mim\", \"chatroom\", \"post\".  \"signal\" queries can only be combined with \"fromDate\", \"toDate\", \"skip\" and \"limit\" parameters.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v1_message_search_get(query, session_token, key_manager_token, async_req=True)
        >>> result = thread.get()

        Args:
            query (str): The search query. See above for the query syntax.
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.

        Keyword Args:
            skip (int): No. of results to skip. . [optional]
            limit (int): Max no. of results to return. If no value is provided, 50 is the default. . [optional]
            scope (str): Describes where content should be searched for that query. It can exclusively apply to Symphony content or to one Connector. . [optional]
            sort_dir (str): Messages sort direction : ASC or DESC (default to DESC) . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V4MessageList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['query'] = \
            query
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        return self.v1_message_search_get_endpoint.call_with_http_info(**kwargs)

    def v1_message_search_post(
        self,
        session_token,
        key_manager_token,
        query,
        **kwargs
    ):
        """Search messages  # noqa: E501

        Search messages according to the specified criteria.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v1_message_search_post(session_token, key_manager_token, query, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.
            query (MessageSearchQuery): The search query. See above for the query syntax.

        Keyword Args:
            skip (int): No. of results to skip. . [optional]
            limit (int): Max no. of results to return. If no value is provided, 50 is the default. . [optional]
            scope (str): Describes where content should be searched for that query. It can exclusively apply to Symphony content or to one Connector. . [optional]
            sort_dir (str): Messages sort direction : ASC or DESC (default to DESC) . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V4MessageList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        kwargs['query'] = \
            query
        return self.v1_message_search_post_endpoint.call_with_http_info(**kwargs)

    def v1_stream_sid_message_create_post(
        self,
        sid,
        session_token,
        key_manager_token,
        message,
        **kwargs
    ):
        """Post a message to one existing stream.  # noqa: E501

        Post a new message to the given stream. The stream can be a chatroom, an IM or a multiparty IM.  If the message parameter type is TEXT then the message contains plain text and cannot include formating, hash tags, mentions etc.  If the message parameter type is MessageML then the message contains MessageML which allows for these entities.  If the message is in MessageML and fails schema validation a client error results  If the message is sent then 200 is returned.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v1_stream_sid_message_create_post(sid, session_token, key_manager_token, message, async_req=True)
        >>> result = thread.get()

        Args:
            sid (str): Stream ID
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.
            message (MessageSubmission):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['sid'] = \
            sid
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        kwargs['message'] = \
            message
        return self.v1_stream_sid_message_create_post_endpoint.call_with_http_info(**kwargs)

    def v1_stream_sid_message_get(
        self,
        sid,
        since,
        session_token,
        key_manager_token,
        **kwargs
    ):
        """Get messages from an existing stream.  # noqa: E501

        A caller can fetch all unseen messages by passing the timestamp of the last message seen as the since parameter and the number of messages with the same timestamp value already seen as the skip parameter. This means that every message will be seen exactly once even in the case that an additional message is processed with the same timestamp as the last message returned by the previous call, and the case where there are more than maxMessages with the same timestamp value.  This method is intended for historic queries and is generally reliable but if guaranteed delivery of every message in real time is required then the equivilent firehose method should be called.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v1_stream_sid_message_get(sid, since, session_token, key_manager_token, async_req=True)
        >>> result = thread.get()

        Args:
            sid (str): Stream ID 
            since (int): Timestamp of first required message.  This is a long integer value representing milliseconds since Jan 1 1970 
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.

        Keyword Args:
            offset (int): No. of messages to skip. . [optional]
            max_messages (int): Max No. of messages to return. If no value is provided, 50 is the default. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MessageList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['sid'] = \
            sid
        kwargs['since'] = \
            since
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        return self.v1_stream_sid_message_get_endpoint.call_with_http_info(**kwargs)

    def v2_message_import_post(
        self,
        session_token,
        key_manager_token,
        message_list,
        **kwargs
    ):
        """Import messages from other systems into Symphony.  # noqa: E501

        Sends a message to be imported into the system. Allows you to override the timestamp and author of the message with your desired values. The requesting user must have the Content Management role. The user that the message is intended to have come from must also be present in the conversation. The intended message timestamp must be a valid time from the past. It cannot be a future timestamp. Optionally the original message ID can be specified to identify the imported message for the purpose of repeat imports.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v2_message_import_post(session_token, key_manager_token, message_list, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.
            message_list (V2MessageImportList):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V2ImportResponseList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        kwargs['message_list'] = \
            message_list
        return self.v2_message_import_post_endpoint.call_with_http_info(**kwargs)

    def v2_stream_sid_message_create_post(
        self,
        sid,
        session_token,
        key_manager_token,
        message,
        **kwargs
    ):
        """Post a message to one existing stream.  # noqa: E501

        Post a new message to the given stream. The stream can be a chatroom, an IM or a multiparty IM.  You may include an attachment on the message (see the V2MessageSubmission parameter).  If the message parameter type is TEXT then the message contains plain text and cannot include formating, hash tags, mentions etc.  If the message parameter type is MessageML then the message contains MessageML which allows for these entities.  If the message is in MessageML and fails schema validation a client error results  If the message is sent then 200 is returned.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v2_stream_sid_message_create_post(sid, session_token, key_manager_token, message, async_req=True)
        >>> result = thread.get()

        Args:
            sid (str): Stream ID
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.
            message (V2MessageSubmission):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V2Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['sid'] = \
            sid
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        kwargs['message'] = \
            message
        return self.v2_stream_sid_message_create_post_endpoint.call_with_http_info(**kwargs)

    def v2_stream_sid_message_get(
        self,
        sid,
        since,
        session_token,
        key_manager_token,
        **kwargs
    ):
        """Get messages from an existing stream.  # noqa: E501

        A caller can fetch all unseen messages by passing the timestamp of the last message seen as the since parameter and the number of messages with the same timestamp value already seen as the skip parameter. This means that every message will be seen exactly once even in the case that an additional message is processed with the same timestamp as the last message returned by the previous call, and the case where there are more than maxMessages with the same timestamp value.  This method is intended for historic queries and is generally reliable but if guaranteed delivery of every message in real time is required then the equivilent firehose method should be called.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v2_stream_sid_message_get(sid, since, session_token, key_manager_token, async_req=True)
        >>> result = thread.get()

        Args:
            sid (str): Stream ID 
            since (int): Timestamp of first required message.  This is a long integer value representing milliseconds since Jan 1 1970 
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.

        Keyword Args:
            offset (int): No. of messages to skip. . [optional]
            limit (int): Max No. of messages to return. If no value is provided, 50 is the default. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V2MessageList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['sid'] = \
            sid
        kwargs['since'] = \
            since
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        return self.v2_stream_sid_message_get_endpoint.call_with_http_info(**kwargs)

    def v3_stream_sid_message_create_post(
        self,
        sid,
        session_token,
        message,
        **kwargs
    ):
        """PROVISIONAL - Post a message to one existing stream.  # noqa: E501

        Post a new message to the given stream. The stream can be a chatroom, an IM or a multiparty IM.  You may include an attachment on the message (see the V2MessageSubmission parameter).  If the message parameter type is TEXT then the message contains plain text and cannot include formating, hash tags, mentions etc.  If the message parameter type is MessageML then the message contains MessageML which allows for these entities.  If the message is in MessageML and fails schema validation a client error results  If the message is sent then 200 is returned.  Regarding authentication, you must either use the sessionToken which was created for delegated app access or both the sessionToken and keyManagerToken together.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v3_stream_sid_message_create_post(sid, session_token, message, async_req=True)
        >>> result = thread.get()

        Args:
            sid (str): Stream ID
            session_token (str): Authorization token used to make delegated calls.
            message (V2MessageSubmission):

        Keyword Args:
            key_manager_token (str): Key Manager authentication token.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V2Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['sid'] = \
            sid
        kwargs['session_token'] = \
            session_token
        kwargs['message'] = \
            message
        return self.v3_stream_sid_message_create_post_endpoint.call_with_http_info(**kwargs)

    def v4_message_blast_post(
        self,
        session_token,
        sids,
        **kwargs
    ):
        """Post a message to multiple existing streams.  # noqa: E501

        Post a new message to the given list of streams. The stream can be a chatroom, an IM or a multiparty IM.  You may include an attachment on the message.  The message can be provided as MessageMLV2 or PresentationML. Both formats support Freemarker templates.  The optional parameter \"data\" can be used to provide a JSON payload containing entity data. If the message contains explicit references to entity data (in \"data-entity-id\" element attributes), this parameter is required.  If the message is in MessageML and fails schema validation a client error results  This endpoint is idempotent, it means that a 200 response will be returned even if the message has not been delivered to some streams. Check the `errors` map from the response in order to see on which stream(s) the message has not been delivered.  The maximum number of streams where the message can be sent is limitted to 100.  Regarding authentication, you must either use the sessionToken which was created for delegated app access or both the sessionToken and keyManagerToken together.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v4_message_blast_post(session_token, sids, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Authorization token used to make delegated calls.
            sids ([str]): A comma-separated list of Stream IDs

        Keyword Args:
            key_manager_token (str): Key Manager authentication token.. [optional]
            message (str): The message payload in MessageML.. [optional]
            data (str): Optional message data in EntityJSON.. [optional]
            version (str): Optional message version in the format \\\"major.minor\\\". If empty, defaults to the latest supported version. . [optional]
            attachment (file_type): Optional file attachment.. [optional]
            preview (file_type): Optional attachment preview.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V4MessageBlastResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['sids'] = \
            sids
        return self.v4_message_blast_post_endpoint.call_with_http_info(**kwargs)

    def v4_message_import_post(
        self,
        session_token,
        key_manager_token,
        message_list,
        **kwargs
    ):
        """Import messages from other systems into Symphony.  # noqa: E501

        Sends a message to be imported into the system. Allows you to override the timestamp and author of the message with your desired values. The requesting user must have the Content Management role. The user that the message is intended to have come from must also be present in the conversation. The intended message timestamp must be a valid time from the past. It cannot be a future timestamp. Optionally the original message ID can be specified to identify the imported message for the purpose of repeat imports.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v4_message_import_post(session_token, key_manager_token, message_list, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.
            message_list (V4MessageImportList):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V4ImportResponseList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        kwargs['message_list'] = \
            message_list
        return self.v4_message_import_post_endpoint.call_with_http_info(**kwargs)

    def v4_stream_sid_message_create_post(
        self,
        sid,
        session_token,
        **kwargs
    ):
        """Post a message to one existing stream.  # noqa: E501

        Post a new message to the given stream. The stream can be a chatroom, an IM or a multiparty IM.  You may include an attachment on the message.  The message can be provided as MessageMLV2 or PresentationML. Both formats support Freemarker templates.  The optional parameter \"data\" can be used to provide a JSON payload containing entity data. If the message contains explicit references to entity data (in \"data-entity-id\" element attributes), this parameter is required.  If the message is in MessageML and fails schema validation a client error results  If the message is sent then 200 is returned.  Regarding authentication, you must either use the sessionToken which was created for delegated app access or both the sessionToken and keyManagerToken together.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v4_stream_sid_message_create_post(sid, session_token, async_req=True)
        >>> result = thread.get()

        Args:
            sid (str): Stream ID
            session_token (str): Authorization token used to make delegated calls.

        Keyword Args:
            key_manager_token (str): Key Manager authentication token.. [optional]
            message (str): The message payload in MessageML.. [optional]
            data (str): Optional message data in EntityJSON.. [optional]
            version (str): Optional message version in the format \\\"major.minor\\\". If empty, defaults to the latest supported version. . [optional]
            attachment (file_type): Optional file attachment.. [optional]
            preview (file_type): Optional attachment preview.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V4Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['sid'] = \
            sid
        kwargs['session_token'] = \
            session_token
        return self.v4_stream_sid_message_create_post_endpoint.call_with_http_info(**kwargs)

    def v4_stream_sid_message_get(
        self,
        sid,
        since,
        session_token,
        key_manager_token,
        **kwargs
    ):
        """Get messages from an existing stream.  # noqa: E501

        A caller can fetch all unseen messages by passing the timestamp of the last message seen as the since parameter and the number of messages with the same timestamp value already seen as the skip parameter. This means that every message will be seen exactly once even in the case that an additional message is processed with the same timestamp as the last message returned by the previous call, and the case where there are more than maxMessages with the same timestamp value.  This method is intended for historic queries and is generally reliable but if guaranteed delivery of every message in real time is required then the equivilent firehose method should be called.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v4_stream_sid_message_get(sid, since, session_token, key_manager_token, async_req=True)
        >>> result = thread.get()

        Args:
            sid (str): Stream ID 
            since (int): Timestamp of first required message.  This is a long integer value representing milliseconds since Jan 1 1970 
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.

        Keyword Args:
            skip (int): No. of messages to skip. . [optional]
            limit (int): Max No. of messages to return. If no value is provided, 50 is the default. The maximum supported value is 500. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V4MessageList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['sid'] = \
            sid
        kwargs['since'] = \
            since
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        return self.v4_stream_sid_message_get_endpoint.call_with_http_info(**kwargs)

    def v4_stream_sid_message_mid_update_post(
        self,
        sid,
        mid,
        session_token,
        **kwargs
    ):
        """Update an existing message.  # noqa: E501

        Update an existing message. The existing message must be a valid social message, that has not been deleted.  The message can be provided as MessageMLV2 or PresentationML. Both formats support Freemarker templates.  The optional parameter \"data\" can be used to provide a JSON payload containing entity data. If the message contains explicit references to entity data (in \"data-entity-id\" element attributes), this parameter is required.  If the message is in MessageML and fails schema validation a client error results  If the message is updated then 200 is returned.  Regarding authentication, you must either use the sessionToken which was created for delegated app access or both the sessionToken and keyManagerToken together.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v4_stream_sid_message_mid_update_post(sid, mid, session_token, async_req=True)
        >>> result = thread.get()

        Args:
            sid (str): Stream ID
            mid (str): Parent message ID
            session_token (str): Authorization token used to make delegated calls.

        Keyword Args:
            key_manager_token (str): Key Manager authentication token.. [optional]
            message (str): The message payload in MessageML.. [optional]
            data (str): Optional message data in EntityJSON.. [optional]
            version (str): Optional message version in the format \\\"major.minor\\\". If empty, defaults to the latest supported version. . [optional]
            silent (str): Optional boolean field that will determine if the user/s should receive the message as read or not (true by default). Since Agent 20.14. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V4Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['sid'] = \
            sid
        kwargs['mid'] = \
            mid
        kwargs['session_token'] = \
            session_token
        return self.v4_stream_sid_message_mid_update_post_endpoint.call_with_http_info(**kwargs)

