import * as cdk from 'aws-cdk-lib';
import * as codedeploy from 'aws-cdk-lib/aws-codedeploy';
import * as cr from 'aws-cdk-lib/custom-resources';
import { Construct } from 'constructs';
/**
 * Construction properties of {@link EcsDeploymentProvider}.
 */
interface EcsDeploymentProviderProps {
    /**
     * The deployment group to target for this deployment.
     */
    readonly deploymentGroup: codedeploy.IEcsDeploymentGroup;
    /**
     * The timeout for the deployment. If the timeout is reached, it will trigger a rollback of the stack.
     */
    readonly timeout: cdk.Duration;
    /**
     * The interval to query the deployment to determine when the deployment is completed.
     *
     * @default 15 seconds
     */
    readonly queryInterval?: cdk.Duration;
}
/**
 * A custom resource provider to handle creation of new {@link EcsDeployment}.
 */
export declare class EcsDeploymentProvider extends cr.Provider {
    constructor(scope: Construct, id: string, props: EcsDeploymentProviderProps);
}
export {};
