import { createAggregatedClient } from "@aws-sdk/smithy-client";
import { CodeDeployClient } from "./CodeDeployClient";
import { AddTagsToOnPremisesInstancesCommand, } from "./commands/AddTagsToOnPremisesInstancesCommand";
import { BatchGetApplicationRevisionsCommand, } from "./commands/BatchGetApplicationRevisionsCommand";
import { BatchGetApplicationsCommand, } from "./commands/BatchGetApplicationsCommand";
import { BatchGetDeploymentGroupsCommand, } from "./commands/BatchGetDeploymentGroupsCommand";
import { BatchGetDeploymentInstancesCommand, } from "./commands/BatchGetDeploymentInstancesCommand";
import { BatchGetDeploymentsCommand, } from "./commands/BatchGetDeploymentsCommand";
import { BatchGetDeploymentTargetsCommand, } from "./commands/BatchGetDeploymentTargetsCommand";
import { BatchGetOnPremisesInstancesCommand, } from "./commands/BatchGetOnPremisesInstancesCommand";
import { ContinueDeploymentCommand, } from "./commands/ContinueDeploymentCommand";
import { CreateApplicationCommand, } from "./commands/CreateApplicationCommand";
import { CreateDeploymentCommand, } from "./commands/CreateDeploymentCommand";
import { CreateDeploymentConfigCommand, } from "./commands/CreateDeploymentConfigCommand";
import { CreateDeploymentGroupCommand, } from "./commands/CreateDeploymentGroupCommand";
import { DeleteApplicationCommand, } from "./commands/DeleteApplicationCommand";
import { DeleteDeploymentConfigCommand, } from "./commands/DeleteDeploymentConfigCommand";
import { DeleteDeploymentGroupCommand, } from "./commands/DeleteDeploymentGroupCommand";
import { DeleteGitHubAccountTokenCommand, } from "./commands/DeleteGitHubAccountTokenCommand";
import { DeleteResourcesByExternalIdCommand, } from "./commands/DeleteResourcesByExternalIdCommand";
import { DeregisterOnPremisesInstanceCommand, } from "./commands/DeregisterOnPremisesInstanceCommand";
import { GetApplicationCommand, } from "./commands/GetApplicationCommand";
import { GetApplicationRevisionCommand, } from "./commands/GetApplicationRevisionCommand";
import { GetDeploymentCommand, } from "./commands/GetDeploymentCommand";
import { GetDeploymentConfigCommand, } from "./commands/GetDeploymentConfigCommand";
import { GetDeploymentGroupCommand, } from "./commands/GetDeploymentGroupCommand";
import { GetDeploymentInstanceCommand, } from "./commands/GetDeploymentInstanceCommand";
import { GetDeploymentTargetCommand, } from "./commands/GetDeploymentTargetCommand";
import { GetOnPremisesInstanceCommand, } from "./commands/GetOnPremisesInstanceCommand";
import { ListApplicationRevisionsCommand, } from "./commands/ListApplicationRevisionsCommand";
import { ListApplicationsCommand, } from "./commands/ListApplicationsCommand";
import { ListDeploymentConfigsCommand, } from "./commands/ListDeploymentConfigsCommand";
import { ListDeploymentGroupsCommand, } from "./commands/ListDeploymentGroupsCommand";
import { ListDeploymentInstancesCommand, } from "./commands/ListDeploymentInstancesCommand";
import { ListDeploymentsCommand, } from "./commands/ListDeploymentsCommand";
import { ListDeploymentTargetsCommand, } from "./commands/ListDeploymentTargetsCommand";
import { ListGitHubAccountTokenNamesCommand, } from "./commands/ListGitHubAccountTokenNamesCommand";
import { ListOnPremisesInstancesCommand, } from "./commands/ListOnPremisesInstancesCommand";
import { ListTagsForResourceCommand, } from "./commands/ListTagsForResourceCommand";
import { PutLifecycleEventHookExecutionStatusCommand, } from "./commands/PutLifecycleEventHookExecutionStatusCommand";
import { RegisterApplicationRevisionCommand, } from "./commands/RegisterApplicationRevisionCommand";
import { RegisterOnPremisesInstanceCommand, } from "./commands/RegisterOnPremisesInstanceCommand";
import { RemoveTagsFromOnPremisesInstancesCommand, } from "./commands/RemoveTagsFromOnPremisesInstancesCommand";
import { SkipWaitTimeForInstanceTerminationCommand, } from "./commands/SkipWaitTimeForInstanceTerminationCommand";
import { StopDeploymentCommand, } from "./commands/StopDeploymentCommand";
import { TagResourceCommand } from "./commands/TagResourceCommand";
import { UntagResourceCommand, } from "./commands/UntagResourceCommand";
import { UpdateApplicationCommand, } from "./commands/UpdateApplicationCommand";
import { UpdateDeploymentGroupCommand, } from "./commands/UpdateDeploymentGroupCommand";
const commands = {
    AddTagsToOnPremisesInstancesCommand,
    BatchGetApplicationRevisionsCommand,
    BatchGetApplicationsCommand,
    BatchGetDeploymentGroupsCommand,
    BatchGetDeploymentInstancesCommand,
    BatchGetDeploymentsCommand,
    BatchGetDeploymentTargetsCommand,
    BatchGetOnPremisesInstancesCommand,
    ContinueDeploymentCommand,
    CreateApplicationCommand,
    CreateDeploymentCommand,
    CreateDeploymentConfigCommand,
    CreateDeploymentGroupCommand,
    DeleteApplicationCommand,
    DeleteDeploymentConfigCommand,
    DeleteDeploymentGroupCommand,
    DeleteGitHubAccountTokenCommand,
    DeleteResourcesByExternalIdCommand,
    DeregisterOnPremisesInstanceCommand,
    GetApplicationCommand,
    GetApplicationRevisionCommand,
    GetDeploymentCommand,
    GetDeploymentConfigCommand,
    GetDeploymentGroupCommand,
    GetDeploymentInstanceCommand,
    GetDeploymentTargetCommand,
    GetOnPremisesInstanceCommand,
    ListApplicationRevisionsCommand,
    ListApplicationsCommand,
    ListDeploymentConfigsCommand,
    ListDeploymentGroupsCommand,
    ListDeploymentInstancesCommand,
    ListDeploymentsCommand,
    ListDeploymentTargetsCommand,
    ListGitHubAccountTokenNamesCommand,
    ListOnPremisesInstancesCommand,
    ListTagsForResourceCommand,
    PutLifecycleEventHookExecutionStatusCommand,
    RegisterApplicationRevisionCommand,
    RegisterOnPremisesInstanceCommand,
    RemoveTagsFromOnPremisesInstancesCommand,
    SkipWaitTimeForInstanceTerminationCommand,
    StopDeploymentCommand,
    TagResourceCommand,
    UntagResourceCommand,
    UpdateApplicationCommand,
    UpdateDeploymentGroupCommand,
};
export class CodeDeploy extends CodeDeployClient {
}
createAggregatedClient(commands, CodeDeploy);
