import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { CodeDeployClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CodeDeployClient";
import { BatchGetApplicationRevisionsInput, BatchGetApplicationRevisionsOutput } from "../models/models_0";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link BatchGetApplicationRevisionsCommand}.
 */
export interface BatchGetApplicationRevisionsCommandInput extends BatchGetApplicationRevisionsInput {
}
/**
 * @public
 *
 * The output of {@link BatchGetApplicationRevisionsCommand}.
 */
export interface BatchGetApplicationRevisionsCommandOutput extends BatchGetApplicationRevisionsOutput, __MetadataBearer {
}
/**
 * @public
 * <p>Gets information about one or more application revisions. The maximum number of
 *             application revisions that can be returned is 25.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CodeDeployClient, BatchGetApplicationRevisionsCommand } from "@aws-sdk/client-codedeploy"; // ES Modules import
 * // const { CodeDeployClient, BatchGetApplicationRevisionsCommand } = require("@aws-sdk/client-codedeploy"); // CommonJS import
 * const client = new CodeDeployClient(config);
 * const input = { // BatchGetApplicationRevisionsInput
 *   applicationName: "STRING_VALUE", // required
 *   revisions: [ // RevisionLocationList // required
 *     { // RevisionLocation
 *       revisionType: "S3" || "GitHub" || "String" || "AppSpecContent",
 *       s3Location: { // S3Location
 *         bucket: "STRING_VALUE",
 *         key: "STRING_VALUE",
 *         bundleType: "tar" || "tgz" || "zip" || "YAML" || "JSON",
 *         version: "STRING_VALUE",
 *         eTag: "STRING_VALUE",
 *       },
 *       gitHubLocation: { // GitHubLocation
 *         repository: "STRING_VALUE",
 *         commitId: "STRING_VALUE",
 *       },
 *       string: { // RawString
 *         content: "STRING_VALUE",
 *         sha256: "STRING_VALUE",
 *       },
 *       appSpecContent: { // AppSpecContent
 *         content: "STRING_VALUE",
 *         sha256: "STRING_VALUE",
 *       },
 *     },
 *   ],
 * };
 * const command = new BatchGetApplicationRevisionsCommand(input);
 * const response = await client.send(command);
 * // { // BatchGetApplicationRevisionsOutput
 * //   applicationName: "STRING_VALUE",
 * //   errorMessage: "STRING_VALUE",
 * //   revisions: [ // RevisionInfoList
 * //     { // RevisionInfo
 * //       revisionLocation: { // RevisionLocation
 * //         revisionType: "S3" || "GitHub" || "String" || "AppSpecContent",
 * //         s3Location: { // S3Location
 * //           bucket: "STRING_VALUE",
 * //           key: "STRING_VALUE",
 * //           bundleType: "tar" || "tgz" || "zip" || "YAML" || "JSON",
 * //           version: "STRING_VALUE",
 * //           eTag: "STRING_VALUE",
 * //         },
 * //         gitHubLocation: { // GitHubLocation
 * //           repository: "STRING_VALUE",
 * //           commitId: "STRING_VALUE",
 * //         },
 * //         string: { // RawString
 * //           content: "STRING_VALUE",
 * //           sha256: "STRING_VALUE",
 * //         },
 * //         appSpecContent: { // AppSpecContent
 * //           content: "STRING_VALUE",
 * //           sha256: "STRING_VALUE",
 * //         },
 * //       },
 * //       genericRevisionInfo: { // GenericRevisionInfo
 * //         description: "STRING_VALUE",
 * //         deploymentGroups: [ // DeploymentGroupsList
 * //           "STRING_VALUE",
 * //         ],
 * //         firstUsedTime: new Date("TIMESTAMP"),
 * //         lastUsedTime: new Date("TIMESTAMP"),
 * //         registerTime: new Date("TIMESTAMP"),
 * //       },
 * //     },
 * //   ],
 * // };
 *
 * ```
 *
 * @param BatchGetApplicationRevisionsCommandInput - {@link BatchGetApplicationRevisionsCommandInput}
 * @returns {@link BatchGetApplicationRevisionsCommandOutput}
 * @see {@link BatchGetApplicationRevisionsCommandInput} for command's `input` shape.
 * @see {@link BatchGetApplicationRevisionsCommandOutput} for command's `response` shape.
 * @see {@link CodeDeployClientResolvedConfig | config} for CodeDeployClient's `config` shape.
 *
 * @throws {@link ApplicationDoesNotExistException} (client fault)
 *  <p>The application does not exist with the IAM user or Amazon Web Services account.</p>
 *
 * @throws {@link ApplicationNameRequiredException} (client fault)
 *  <p>The minimum number of required application names was not specified.</p>
 *
 * @throws {@link BatchLimitExceededException} (client fault)
 *  <p>The maximum number of names or IDs allowed for this request (100) was exceeded.</p>
 *
 * @throws {@link InvalidApplicationNameException} (client fault)
 *  <p>The application name was specified in an invalid format.</p>
 *
 * @throws {@link InvalidRevisionException} (client fault)
 *  <p>The revision was specified in an invalid format.</p>
 *
 * @throws {@link RevisionRequiredException} (client fault)
 *  <p>The revision ID was not specified.</p>
 *
 * @throws {@link CodeDeployServiceException}
 * <p>Base exception class for all service exceptions from CodeDeploy service.</p>
 *
 */
export declare class BatchGetApplicationRevisionsCommand extends $Command<BatchGetApplicationRevisionsCommandInput, BatchGetApplicationRevisionsCommandOutput, CodeDeployClientResolvedConfig> {
    readonly input: BatchGetApplicationRevisionsCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: BatchGetApplicationRevisionsCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: CodeDeployClientResolvedConfig, options?: __HttpHandlerOptions): Handler<BatchGetApplicationRevisionsCommandInput, BatchGetApplicationRevisionsCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
