
# Autogenerated by mlir-tblgen; don't manually edit.

from enum import IntEnum, auto, IntFlag
from ._ods_common import _cext as _ods_cext
from ..ir import register_attribute_builder
_ods_ir = _ods_cext.ir

class CmpFPredicate(IntEnum):
    """allowed 64-bit signless integer cases: 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15"""

    AlwaysFalse = 0
    OEQ = 1
    OGT = 2
    OGE = 3
    OLT = 4
    OLE = 5
    ONE = 6
    ORD = 7
    UEQ = 8
    UGT = 9
    UGE = 10
    ULT = 11
    ULE = 12
    UNE = 13
    UNO = 14
    AlwaysTrue = 15

    def __str__(self):
        if self is CmpFPredicate.AlwaysFalse:
            return "false"
        if self is CmpFPredicate.OEQ:
            return "oeq"
        if self is CmpFPredicate.OGT:
            return "ogt"
        if self is CmpFPredicate.OGE:
            return "oge"
        if self is CmpFPredicate.OLT:
            return "olt"
        if self is CmpFPredicate.OLE:
            return "ole"
        if self is CmpFPredicate.ONE:
            return "one"
        if self is CmpFPredicate.ORD:
            return "ord"
        if self is CmpFPredicate.UEQ:
            return "ueq"
        if self is CmpFPredicate.UGT:
            return "ugt"
        if self is CmpFPredicate.UGE:
            return "uge"
        if self is CmpFPredicate.ULT:
            return "ult"
        if self is CmpFPredicate.ULE:
            return "ule"
        if self is CmpFPredicate.UNE:
            return "une"
        if self is CmpFPredicate.UNO:
            return "uno"
        if self is CmpFPredicate.AlwaysTrue:
            return "true"
        raise ValueError("Unknown CmpFPredicate enum entry.")



@register_attribute_builder("Arith_CmpFPredicateAttr")
def _arith_cmpfpredicateattr(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(64, context=context), int(x))

class CmpIPredicate(IntEnum):
    """allowed 64-bit signless integer cases: 0, 1, 2, 3, 4, 5, 6, 7, 8, 9"""

    eq = 0
    ne = 1
    slt = 2
    sle = 3
    sgt = 4
    sge = 5
    ult = 6
    ule = 7
    ugt = 8
    uge = 9

    def __str__(self):
        if self is CmpIPredicate.eq:
            return "eq"
        if self is CmpIPredicate.ne:
            return "ne"
        if self is CmpIPredicate.slt:
            return "slt"
        if self is CmpIPredicate.sle:
            return "sle"
        if self is CmpIPredicate.sgt:
            return "sgt"
        if self is CmpIPredicate.sge:
            return "sge"
        if self is CmpIPredicate.ult:
            return "ult"
        if self is CmpIPredicate.ule:
            return "ule"
        if self is CmpIPredicate.ugt:
            return "ugt"
        if self is CmpIPredicate.uge:
            return "uge"
        raise ValueError("Unknown CmpIPredicate enum entry.")



@register_attribute_builder("Arith_CmpIPredicateAttr")
def _arith_cmpipredicateattr(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(64, context=context), int(x))

class IntegerOverflowFlags(IntFlag):
    """Integer overflow arith flags"""

    none = 0
    nsw = 1
    nuw = 2

    def __iter__(self):
        return iter([case for case in type(self) if (self & case) is case])
    def __len__(self):
        return bin(self).count("1")

    def __str__(self):
        if len(self) > 1:
            return ", ".join(map(str, self))
        if self is IntegerOverflowFlags.none:
            return "none"
        if self is IntegerOverflowFlags.nsw:
            return "nsw"
        if self is IntegerOverflowFlags.nuw:
            return "nuw"
        raise ValueError("Unknown IntegerOverflowFlags enum entry.")



@register_attribute_builder("Arith_IntegerOverflowFlags")
def _arith_integeroverflowflags(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class RoundingMode(IntEnum):
    """Floating point rounding mode"""

    to_nearest_even = 0
    downward = 1
    upward = 2
    toward_zero = 3
    to_nearest_away = 4

    def __str__(self):
        if self is RoundingMode.to_nearest_even:
            return "to_nearest_even"
        if self is RoundingMode.downward:
            return "downward"
        if self is RoundingMode.upward:
            return "upward"
        if self is RoundingMode.toward_zero:
            return "toward_zero"
        if self is RoundingMode.to_nearest_away:
            return "to_nearest_away"
        raise ValueError("Unknown RoundingMode enum entry.")



@register_attribute_builder("Arith_RoundingModeAttr")
def _arith_roundingmodeattr(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class AtomicRMWKind(IntEnum):
    """allowed 64-bit signless integer cases: 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14"""

    addf = 0
    addi = 1
    assign = 2
    maximumf = 3
    maxs = 4
    maxu = 5
    minimumf = 6
    mins = 7
    minu = 8
    mulf = 9
    muli = 10
    ori = 11
    andi = 12
    maxnumf = 13
    minnumf = 14

    def __str__(self):
        if self is AtomicRMWKind.addf:
            return "addf"
        if self is AtomicRMWKind.addi:
            return "addi"
        if self is AtomicRMWKind.assign:
            return "assign"
        if self is AtomicRMWKind.maximumf:
            return "maximumf"
        if self is AtomicRMWKind.maxs:
            return "maxs"
        if self is AtomicRMWKind.maxu:
            return "maxu"
        if self is AtomicRMWKind.minimumf:
            return "minimumf"
        if self is AtomicRMWKind.mins:
            return "mins"
        if self is AtomicRMWKind.minu:
            return "minu"
        if self is AtomicRMWKind.mulf:
            return "mulf"
        if self is AtomicRMWKind.muli:
            return "muli"
        if self is AtomicRMWKind.ori:
            return "ori"
        if self is AtomicRMWKind.andi:
            return "andi"
        if self is AtomicRMWKind.maxnumf:
            return "maxnumf"
        if self is AtomicRMWKind.minnumf:
            return "minnumf"
        raise ValueError("Unknown AtomicRMWKind enum entry.")



@register_attribute_builder("AtomicRMWKindAttr")
def _atomicrmwkindattr(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(64, context=context), int(x))

class FastMathFlags(IntFlag):
    """Floating point fast math flags"""

    none = 0
    reassoc = 1
    nnan = 2
    ninf = 4
    nsz = 8
    arcp = 16
    contract = 32
    afn = 64
    fast = 127

    def __iter__(self):
        return iter([case for case in type(self) if (self & case) is case])
    def __len__(self):
        return bin(self).count("1")

    def __str__(self):
        if len(self) > 1:
            return ",".join(map(str, self))
        if self is FastMathFlags.none:
            return "none"
        if self is FastMathFlags.reassoc:
            return "reassoc"
        if self is FastMathFlags.nnan:
            return "nnan"
        if self is FastMathFlags.ninf:
            return "ninf"
        if self is FastMathFlags.nsz:
            return "nsz"
        if self is FastMathFlags.arcp:
            return "arcp"
        if self is FastMathFlags.contract:
            return "contract"
        if self is FastMathFlags.afn:
            return "afn"
        if self is FastMathFlags.fast:
            return "fast"
        raise ValueError("Unknown FastMathFlags enum entry.")



@register_attribute_builder("FastMathFlags")
def _fastmathflags(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

@register_attribute_builder("Arith_FastMathAttr")
def _arith_fastmathattr(x, context):
    return _ods_ir.Attribute.parse(f'#arith.fastmath<{str(x)}>', context=context)

@register_attribute_builder("Arith_IntegerOverflowAttr")
def _arith_integeroverflowattr(x, context):
    return _ods_ir.Attribute.parse(f'#arith.overflow<{str(x)}>', context=context)

