/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.ArrayList;
import oracle.jdbc.driver.NTFDCNConnection;

class NTFDCNConnectionGroup {
    private static final int DEFAULT_MAX_NTF_CONNECTIONS = 16;
    private static int MAX_NTF_CONNECTIONS = 16;
    private ArrayList<NTFDCNConnection> dcnListenerConnections = new ArrayList();
    private final String groupId;
    private int noOfRegistrationsInThisGroup = 0;

    NTFDCNConnectionGroup(String string) {
        this.groupId = string;
    }

    synchronized NTFDCNConnection getNTFDCNConnection() {
        ++this.noOfRegistrationsInThisGroup;
        if (this.noOfRegistrationsInThisGroup > MAX_NTF_CONNECTIONS) {
            int n2 = this.noOfRegistrationsInThisGroup;
            NTFDCNConnection nTFDCNConnection = this.dcnListenerConnections.get(0);
            for (NTFDCNConnection nTFDCNConnection2 : this.dcnListenerConnections) {
                int n3 = nTFDCNConnection2.getNumberOfRegistrations();
                if (n3 >= n2) continue;
                nTFDCNConnection = nTFDCNConnection2;
                n2 = n3;
            }
            nTFDCNConnection.incrementNumberOfRegistrations(1);
            return nTFDCNConnection;
        }
        return null;
    }

    synchronized void startDCNListenerConnection(String string, String string2, String string3, String string4, ArrayList<String> arrayList, String string5, int n2) {
        assert (string5 != null) : "dcnConnectionId is null";
        String string6 = "notify" + string5;
        NTFDCNConnection nTFDCNConnection = new NTFDCNConnection(string5, arrayList, string, string2, string3, string4, string6, n2);
        this.dcnListenerConnections.add(nTFDCNConnection);
        nTFDCNConnection.setDaemon(true);
        nTFDCNConnection.start();
    }

    synchronized void stopNTFDCNConnection(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        for (NTFDCNConnection nTFDCNConnection : this.dcnListenerConnections) {
            if (nTFDCNConnection == null || !string.equals(nTFDCNConnection.getClientId())) continue;
            nTFDCNConnection.decrementNumberOfRegistrations(1);
            if (nTFDCNConnection.getNumberOfRegistrations() > 0) break;
            nTFDCNConnection.setNeedToBeClosed(true);
            break;
        }
    }
}

