import numpy as np
from . import core as jiminy, tree as tree
from .dynamics import State as State, TrajectoryDataType as TrajectoryDataType
from _typeshed import Incomplete
from typing import Any, Callable, Literal, Sequence, overload

SENSORS_FIELDS: dict[type[jiminy.AbstractSensor], list[str] | dict[str, list[str]]]
FieldNested: Incomplete
read_log: Incomplete

@overload
def extract_variables_from_log(log_vars: dict[str, np.ndarray], fieldnames: FieldNested, namespace: str = '', *, as_dict: Literal[False] = False) -> list[np.ndarray]: ...
@overload
def extract_variables_from_log(log_vars: dict[str, np.ndarray], fieldnames: FieldNested, namespace: str = '', *, as_dict: Literal[True]) -> dict[str, np.ndarray]: ...
def build_robot_from_log(log_data: dict[str, Any], mesh_path_dir: str | None = None, mesh_package_dirs: Sequence[str] = (), *, robot_name: str | None = None) -> jiminy.Robot: ...
def build_robots_from_log(log_data: dict[str, Any], mesh_path_dir: str | None = None, mesh_package_dirs: Sequence[str] = ()) -> Sequence[jiminy.Robot]: ...
def extract_trajectory_from_log(log_data: dict[str, Any], robot: jiminy.Robot | None = None, *, robot_name: str | None = None) -> TrajectoryDataType: ...
def extract_trajectories_from_log(log_data: dict[str, Any], robots: Sequence[jiminy.Robot] | None = None) -> dict[str, TrajectoryDataType]: ...
def update_sensor_measurements_from_log(log_data: dict[str, Any], robot: jiminy.Model) -> Callable[[float, np.ndarray, np.ndarray], None]: ...
