"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.allowEc2InstanceDeleteByOwner = void 0;
const statement = require("..");
/**
 * Allows stopping EC2 instance only for the user who started them
 *
 * @param tag The tag name, where the user information will be stored - default: `Owner`
 */
function allowEc2InstanceDeleteByOwner(tag) {
    const tagName = tag || 'Owner';
    return [
        new statement.Ec2()
            .allow()
            .toStartInstances()
            .ifAwsRequestTag(tagName, '${aws:username}'),
        new statement.Ec2()
            .allow()
            .toStopInstances()
            .ifResourceTag(tagName, '${aws:username}'),
    ];
}
exports.allowEc2InstanceDeleteByOwner = allowEc2InstanceDeleteByOwner;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWxsb3dFYzJJbnN0YW5jZURlbGV0ZUJ5T3duZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJhbGxvd0VjMkluc3RhbmNlRGVsZXRlQnlPd25lci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxnQ0FBZ0M7QUFFaEM7Ozs7R0FJRztBQUVILFNBQWdCLDZCQUE2QixDQUFDLEdBQVk7SUFDeEQsTUFBTSxPQUFPLEdBQUcsR0FBRyxJQUFJLE9BQU8sQ0FBQztJQUMvQixPQUFPO1FBQ0wsSUFBSSxTQUFTLENBQUMsR0FBRyxFQUFFO2FBQ2hCLEtBQUssRUFBRTthQUNQLGdCQUFnQixFQUFFO2FBQ2xCLGVBQWUsQ0FBQyxPQUFPLEVBQUUsaUJBQWlCLENBQUM7UUFDOUMsSUFBSSxTQUFTLENBQUMsR0FBRyxFQUFFO2FBQ2hCLEtBQUssRUFBRTthQUNQLGVBQWUsRUFBRTthQUNqQixhQUFhLENBQUMsT0FBTyxFQUFFLGlCQUFpQixDQUFDO0tBQzdDLENBQUM7QUFDSixDQUFDO0FBWkQsc0VBWUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBzdGF0ZW1lbnQgZnJvbSAnLi4nO1xuXG4vKipcbiAqIEFsbG93cyBzdG9wcGluZyBFQzIgaW5zdGFuY2Ugb25seSBmb3IgdGhlIHVzZXIgd2hvIHN0YXJ0ZWQgdGhlbVxuICpcbiAqIEBwYXJhbSB0YWcgVGhlIHRhZyBuYW1lLCB3aGVyZSB0aGUgdXNlciBpbmZvcm1hdGlvbiB3aWxsIGJlIHN0b3JlZCAtIGRlZmF1bHQ6IGBPd25lcmBcbiAqL1xuXG5leHBvcnQgZnVuY3Rpb24gYWxsb3dFYzJJbnN0YW5jZURlbGV0ZUJ5T3duZXIodGFnPzogc3RyaW5nKSB7XG4gIGNvbnN0IHRhZ05hbWUgPSB0YWcgfHwgJ093bmVyJztcbiAgcmV0dXJuIFtcbiAgICBuZXcgc3RhdGVtZW50LkVjMigpXG4gICAgICAuYWxsb3coKVxuICAgICAgLnRvU3RhcnRJbnN0YW5jZXMoKVxuICAgICAgLmlmQXdzUmVxdWVzdFRhZyh0YWdOYW1lLCAnJHthd3M6dXNlcm5hbWV9JyksXG4gICAgbmV3IHN0YXRlbWVudC5FYzIoKVxuICAgICAgLmFsbG93KClcbiAgICAgIC50b1N0b3BJbnN0YW5jZXMoKVxuICAgICAgLmlmUmVzb3VyY2VUYWcodGFnTmFtZSwgJyR7YXdzOnVzZXJuYW1lfScpLFxuICBdO1xufVxuIl19