import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [apigateway](https://docs.aws.amazon.com/service-authorization/latest/reference/list_manageamazonapigateway.html).
 *
 * @experimental
 */
export declare class Apigateway extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Used to delete resources.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/apigateway/api-reference/API_DELETE.html
     *
     * @experimental
     */
    toDELETE(): this;
    /**
     * (experimental) Used to get information about resources.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apigateway/api-reference/API_GET.html
     *
     * @experimental
     */
    toGET(): this;
    /**
     * (experimental) Used to update resources.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/apigateway/api-reference/API_PATCH.html
     *
     * @experimental
     */
    toPATCH(): this;
    /**
     * (experimental) Used to create child resources.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/apigateway/api-reference/API_POST.html
     *
     * @experimental
     */
    toPOST(): this;
    /**
     * (experimental) Used to update resources (and, although not recommended, can be used to create child resources).
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/apigateway/api-reference/API_PUT.html
     *
     * @experimental
     */
    toPUT(): this;
    /**
     * (experimental) Gives WebAcl permissions to WAF.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apigateway/api-reference/WEBACL_SET.html
     *
     * @experimental
     */
    toSetWebACL(): this;
    /**
     * (experimental) Used to update the Resource Policy for a given API.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toUpdateRestApiPolicy(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type apigateway-general to the statement.
     *
     * https://docs.aws.amazon.com/apigateway/latest/developerguide/permissions.html
     *
     * @param apiGatewayResourcePath - Identifier for the apiGatewayResourcePath.
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onApigatewayGeneral(apiGatewayResourcePath: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [apigateway](https://docs.aws.amazon.com/service-authorization/latest/reference/list_manageamazonapigateway.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
