"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Wellarchitected = void 0;
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [wellarchitected](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awswell-architectedtool.html).
 *
 * @experimental
 */
class Wellarchitected extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [wellarchitected](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awswell-architectedtool.html).
     *
     * @experimental
     */
    constructor(props) {
        super(props);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'wellarchitected';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "AssociateLenses",
                "CreateMilestone",
                "CreateWorkload",
                "CreateWorkloadShare",
                "DeleteWorkload",
                "DeleteWorkloadShare",
                "DisassociateLenses",
                "UpdateAnswer",
                "UpdateLensReview",
                "UpdateShareInvitation",
                "UpdateWorkload",
                "UpdateWorkloadShare",
                "UpgradeLensReview"
            ],
            "Read": [
                "GetAnswer",
                "GetLensReview",
                "GetLensReviewReport",
                "GetLensVersionDifference",
                "GetMilestone",
                "GetWorkload"
            ],
            "List": [
                "ListAnswers",
                "ListLensReviewImprovements",
                "ListLensReviews",
                "ListLenses",
                "ListMilestones",
                "ListNotifications",
                "ListShareInvitations",
                "ListWorkloadShares",
                "ListWorkloads"
            ]
        };
    }
    /**
     * (experimental) Grants permission to associate a lens to the specified workload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-add.html
     *
     * @experimental
     */
    toAssociateLenses() {
        return this.to('AssociateLenses');
    }
    /**
     * (experimental) Grants permission to create a new milestone for the specified workload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/milestones-save.html
     *
     * @experimental
     */
    toCreateMilestone() {
        return this.to('CreateMilestone');
    }
    /**
     * (experimental) Grants permission to create a new workload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/define-workload.html
     *
     * @experimental
     */
    toCreateWorkload() {
        return this.to('CreateWorkload');
    }
    /**
     * (experimental) Grants permission to share a workload with another account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-sharing.html
     *
     * @experimental
     */
    toCreateWorkloadShare() {
        return this.to('CreateWorkloadShare');
    }
    /**
     * (experimental) Grants permission to delete an existing workload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-delete.html
     *
     * @experimental
     */
    toDeleteWorkload() {
        return this.to('DeleteWorkload');
    }
    /**
     * (experimental) Grants permission to delete an existing workload share.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/sharing-remove.html
     *
     * @experimental
     */
    toDeleteWorkloadShare() {
        return this.to('DeleteWorkloadShare');
    }
    /**
     * (experimental) Grants permission to disassociate a lens from the specified workload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-remove.html
     *
     * @experimental
     */
    toDisassociateLenses() {
        return this.to('DisassociateLenses');
    }
    /**
     * (experimental) Grants permission to retrieve the specified answer from the specified lens review.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/start-workflow-review.html
     *
     * @experimental
     */
    toGetAnswer() {
        return this.to('GetAnswer');
    }
    /**
     * (experimental) Grants permission to retrieve the specified lens review of the specified workload.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/start-workflow-review.html
     *
     * @experimental
     */
    toGetLensReview() {
        return this.to('GetLensReview');
    }
    /**
     * (experimental) Grants permission to retrieve the report for the specified lens review.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-report.html
     *
     * @experimental
     */
    toGetLensReviewReport() {
        return this.to('GetLensReviewReport');
    }
    /**
     * (experimental) Grants permission to get the difference between the specified lens version and latest available lens version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-upgrading.html
     *
     * @experimental
     */
    toGetLensVersionDifference() {
        return this.to('GetLensVersionDifference');
    }
    /**
     * (experimental) Grants permission to retrieve the specified milestone of the specified workload.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/milestones-view.html
     *
     * @experimental
     */
    toGetMilestone() {
        return this.to('GetMilestone');
    }
    /**
     * (experimental) Grants permission to retrieve the specified workload.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-page.html
     *
     * @experimental
     */
    toGetWorkload() {
        return this.to('GetWorkload');
    }
    /**
     * (experimental) Grants permission to list the answers from the specified lens review.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/start-workflow-review.html
     *
     * @experimental
     */
    toListAnswers() {
        return this.to('ListAnswers');
    }
    /**
     * (experimental) Grants permission to list the improvements of the specified lens review.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/tutorial-step3.html
     *
     * @experimental
     */
    toListLensReviewImprovements() {
        return this.to('ListLensReviewImprovements');
    }
    /**
     * (experimental) Grants permission to list the lens reviews of the specified workload.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-details.html
     *
     * @experimental
     */
    toListLensReviews() {
        return this.to('ListLensReviews');
    }
    /**
     * (experimental) Grants permission to list the lenses available to this account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses.html
     *
     * @experimental
     */
    toListLenses() {
        return this.to('ListLenses');
    }
    /**
     * (experimental) Grants permission to list the milestones of the specified workload.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/details-milestones.html
     *
     * @experimental
     */
    toListMilestones() {
        return this.to('ListMilestones');
    }
    /**
     * (experimental) Grants permission to list notifications related to the account or specified resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-notifications.html
     *
     * @experimental
     */
    toListNotifications() {
        return this.to('ListNotifications');
    }
    /**
     * (experimental) Grants permission to list the workload share invitations of the specified account or user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/invitations.html
     *
     * @experimental
     */
    toListShareInvitations() {
        return this.to('ListShareInvitations');
    }
    /**
     * (experimental) Grants permission to list the workload shares of the specified workload.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-sharing.html
     *
     * @experimental
     */
    toListWorkloadShares() {
        return this.to('ListWorkloadShares');
    }
    /**
     * (experimental) Grants permission to list the workloads in this account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-page.html
     *
     * @experimental
     */
    toListWorkloads() {
        return this.to('ListWorkloads');
    }
    /**
     * (experimental) Grants permission to update properties of the specified answer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/start-workflow-review.html
     *
     * @experimental
     */
    toUpdateAnswer() {
        return this.to('UpdateAnswer');
    }
    /**
     * (experimental) Grants permission to update properties of the specified lens review.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-details.html
     *
     * @experimental
     */
    toUpdateLensReview() {
        return this.to('UpdateLensReview');
    }
    /**
     * (experimental) Grants permission to update status of the specified workload share invitation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/workload-sharing.html
     *
     * @experimental
     */
    toUpdateShareInvitation() {
        return this.to('UpdateShareInvitation');
    }
    /**
     * (experimental) Grants permission to update properties of the specified workload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/workload-edit.html
     *
     * @experimental
     */
    toUpdateWorkload() {
        return this.to('UpdateWorkload');
    }
    /**
     * (experimental) Grants permission to update properties of the specified workload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/workload-sharing.html
     *
     * @experimental
     */
    toUpdateWorkloadShare() {
        return this.to('UpdateWorkloadShare');
    }
    /**
     * (experimental) Grants permission to upgrade the specified lens review to use the latest version of the associated lens.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-upgrading.html
     *
     * @experimental
     */
    toUpgradeLensReview() {
        return this.to('UpgradeLensReview');
    }
    /**
     * (experimental) Adds a resource of type workload to the statement.
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/iam-auth-access.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onWorkload(resourceId, account, region, partition) {
        var arn = 'arn:${Partition}:wellarchitected:${Region}:${Account}:workload/${ResourceId}';
        arn = arn.replace('${ResourceId}', resourceId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
}
exports.Wellarchitected = Wellarchitected;
//# sourceMappingURL=data:application/json;base64,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