/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kernel;

import infodynamics.measures.continuous.TransferEntropyCalculatorMultiVariate;
import infodynamics.measures.continuous.TransferEntropyCommon;
import infodynamics.measures.continuous.kernel.KernelEstimatorMultiVariate;
import infodynamics.measures.continuous.kernel.KernelEstimatorTransferEntropyMultiVariate;
import infodynamics.measures.continuous.kernel.TransferEntropyKernelCounts;
import infodynamics.utils.EmpiricalMeasurementDistribution;
import infodynamics.utils.MathsUtils;
import infodynamics.utils.MatrixUtils;
import infodynamics.utils.RandomGenerator;
import java.util.Iterator;
import java.util.Vector;

public class TransferEntropyCalculatorMultiVariateKernel
extends TransferEntropyCommon
implements TransferEntropyCalculatorMultiVariate {
    protected KernelEstimatorTransferEntropyMultiVariate teKernelEstimator = new KernelEstimatorTransferEntropyMultiVariate();
    protected KernelEstimatorMultiVariate nextStateKernelEstimator = null;
    protected Vector<double[][]> vectorOfJointSourceObservations;
    protected Vector<double[][]> vectorOfJointDestinationObservations;
    protected double[][] destPastVectors;
    protected double[][] destNextVectors;
    protected double[][] sourceVectors;
    protected int destDimensions = 1;
    protected int sourceDimensions = 1;
    protected double[] localProbNextCondPast;
    protected boolean normalise = true;
    public static final String NORMALISE_PROP_NAME = "NORMALISE";
    protected boolean dynCorrExcl = false;
    protected int dynCorrExclTime = 100;
    public static final String DYN_CORR_EXCL_TIME_NAME = "DYN_CORR_EXCL";
    protected boolean forceCompareToAll = false;
    public static final String FORCE_KERNEL_COMPARE_TO_ALL = "FORCE_KERNEL_COMPARE_TO_ALL";
    public static final double DEFAULT_KERNEL_WIDTH = 0.25;
    protected double kernelWidth = 0.25;
    public static final String KERNEL_WIDTH_PROP_NAME = "KERNEL_WIDTH";
    public static final String EPSILON_PROP_NAME = "EPSILON";

    public TransferEntropyCalculatorMultiVariateKernel() {
        this.teKernelEstimator.setNormalise(this.normalise);
        this.nextStateKernelEstimator = new KernelEstimatorMultiVariate();
        this.nextStateKernelEstimator.setNormalise(this.normalise);
    }

    @Override
    public void initialise(int n) throws Exception {
        this.initialise(n, this.kernelWidth);
    }

    public void initialise(int n, double d) throws Exception {
        this.kernelWidth = d;
        this.initialise(n, 1, 1);
    }

    @Override
    public void initialise(int n, int n2, int n3) throws Exception {
        this.destDimensions = n3;
        this.sourceDimensions = n2;
        super.initialise(n);
    }

    @Override
    public void initialise(int n, int n2) throws Exception {
        this.destDimensions = n2;
        this.sourceDimensions = n;
        super.initialise(this.k);
    }

    @Override
    public void initialise() {
        this.teKernelEstimator.initialise(this.k * this.destDimensions, this.sourceDimensions, this.kernelWidth, this.kernelWidth);
        this.nextStateKernelEstimator.initialise(this.destDimensions, this.kernelWidth);
        this.destPastVectors = null;
        this.destNextVectors = null;
        this.sourceVectors = null;
        this.localProbNextCondPast = null;
    }

    @Override
    public void setProperty(String string, String string2) throws Exception {
        boolean bl = true;
        if (string.equalsIgnoreCase(KERNEL_WIDTH_PROP_NAME) || string.equalsIgnoreCase(EPSILON_PROP_NAME)) {
            this.kernelWidth = Double.parseDouble(string2);
        } else if (string.equalsIgnoreCase(NORMALISE_PROP_NAME)) {
            this.normalise = Boolean.parseBoolean(string2);
            this.teKernelEstimator.setNormalise(this.normalise);
            this.nextStateKernelEstimator.setNormalise(this.normalise);
        } else if (string.equalsIgnoreCase(DYN_CORR_EXCL_TIME_NAME)) {
            this.dynCorrExclTime = Integer.parseInt(string2);
            boolean bl2 = this.dynCorrExcl = this.dynCorrExclTime > 0;
            if (this.dynCorrExcl) {
                this.teKernelEstimator.setDynamicCorrelationExclusion(this.dynCorrExclTime);
                this.nextStateKernelEstimator.setDynamicCorrelationExclusion(this.dynCorrExclTime);
            } else {
                this.teKernelEstimator.clearDynamicCorrelationExclusion();
                this.nextStateKernelEstimator.clearDynamicCorrelationExclusion();
            }
        } else if (string.equalsIgnoreCase(FORCE_KERNEL_COMPARE_TO_ALL)) {
            this.forceCompareToAll = Boolean.parseBoolean(string2);
            this.teKernelEstimator.setForceCompareToAll(this.forceCompareToAll);
            this.nextStateKernelEstimator.setForceCompareToAll(this.forceCompareToAll);
        } else {
            bl = false;
            super.setProperty(string, string2);
        }
        if (this.debug && bl) {
            System.out.println(this.getClass().getSimpleName() + ": Set property " + string + " to " + string2);
        }
    }

    @Override
    public void setObservations(double[][] dArray, double[][] dArray2) throws Exception {
        this.startAddObservations();
        this.addObservations(dArray, dArray2);
        this.finaliseAddObservations();
    }

    @Override
    public void setObservations(double[][] dArray, double[][] dArray2, boolean[] blArray, boolean[] blArray2) throws Exception {
        Vector<int[]> vector = this.computeStartAndEndTimePairs(blArray, blArray2);
        this.startAddObservations();
        for (int[] nArray : vector) {
            int n = nArray[0];
            int n2 = nArray[1];
            this.addObservations(dArray, dArray2, n, n2 - n + 1);
        }
        this.finaliseAddObservations();
    }

    @Override
    public void setObservations(double[][] dArray, double[][] dArray2, boolean[][] blArray, boolean[][] blArray2) throws Exception {
        boolean[] blArray3 = MatrixUtils.andRows(blArray);
        boolean[] blArray4 = MatrixUtils.andRows(blArray2);
        this.setObservations(dArray, dArray2, blArray3, blArray4);
    }

    @Override
    public void startAddObservations() {
        this.vectorOfJointSourceObservations = new Vector();
        this.vectorOfJointDestinationObservations = new Vector();
    }

    @Override
    public void addObservations(double[] dArray, double[] dArray2) throws Exception {
        double[][] dArray3 = new double[dArray.length][1];
        MatrixUtils.copyIntoColumn(dArray3, 0, dArray);
        double[][] dArray4 = new double[dArray2.length][1];
        MatrixUtils.copyIntoColumn(dArray4, 0, dArray2);
        this.addObservations(dArray3, dArray4);
    }

    @Override
    public void addObservations(double[] dArray, double[] dArray2, int n, int n2) throws Exception {
        double[][] dArray3 = new double[n2][1];
        MatrixUtils.copyIntoColumn(dArray3, 0, 0, dArray, n, n2);
        double[][] dArray4 = new double[dArray2.length][1];
        MatrixUtils.copyIntoColumn(dArray4, 0, 0, dArray2, n, n2);
        this.addObservations(dArray3, dArray4);
    }

    @Override
    public void addObservations(double[][] dArray, double[][] dArray2) throws Exception {
        if (dArray.length != dArray2.length) {
            throw new Exception(String.format("Source and destination lengths (%d and %d) must match!", dArray.length, dArray2.length));
        }
        int n = dArray[0].length;
        int n2 = dArray2[0].length;
        if (n2 != this.destDimensions || n != this.sourceDimensions) {
            throw new Exception("Cannot add observsations for source and destination variables  of " + n + " and " + n2 + " dimensions respectively for TE calculator set up for " + this.sourceDimensions + " " + this.destDimensions + " source and destination dimensions respectively");
        }
        if (this.vectorOfJointSourceObservations == null) {
            throw new RuntimeException("User did not call startAddObservations before addObservations");
        }
        this.vectorOfJointSourceObservations.add(dArray);
        this.vectorOfJointDestinationObservations.add(dArray2);
    }

    @Override
    public void addObservations(double[][] dArray, double[][] dArray2, int n, int n2) throws Exception {
        double[][] dArray3 = new double[n2][dArray[0].length];
        System.arraycopy(dArray, n, dArray3, 0, n2);
        double[][] dArray4 = new double[n2][dArray2[0].length];
        System.arraycopy(dArray2, n, dArray4, 0, n2);
        this.addObservations(dArray3, dArray4);
    }

    @Override
    public void finaliseAddObservations() {
        this.totalObservations = 0;
        for (double[][] object2 : this.vectorOfJointDestinationObservations) {
            this.totalObservations += object2.length - this.k;
        }
        this.destPastVectors = new double[this.totalObservations][this.k * this.destDimensions];
        this.destNextVectors = new double[this.totalObservations][this.destDimensions];
        this.sourceVectors = new double[this.totalObservations][this.sourceDimensions];
        int n = 0;
        Iterator<double[][]> iterator = this.vectorOfJointDestinationObservations.iterator();
        for (double[][] dArray : this.vectorOfJointSourceObservations) {
            double[][] dArray2 = iterator.next();
            double[][] dArray3 = this.makeJointVectorForPast(dArray2);
            MatrixUtils.arrayCopy(dArray3, 0, 0, this.destPastVectors, n, 0, dArray3.length, this.k * this.destDimensions);
            MatrixUtils.arrayCopy(dArray2, this.k, 0, this.destNextVectors, n, 0, dArray2.length - this.k, this.destDimensions);
            MatrixUtils.arrayCopy(dArray, this.k - 1, 0, this.sourceVectors, n, 0, dArray.length - this.k, this.sourceDimensions);
            n += dArray2.length - this.k;
        }
        this.teKernelEstimator.setObservations(this.destPastVectors, this.destNextVectors, this.sourceVectors);
        this.addedMoreThanOneObservationSet = this.vectorOfJointDestinationObservations.size() > 1;
        this.vectorOfJointSourceObservations = null;
        this.vectorOfJointDestinationObservations = null;
    }

    @Override
    public double computeAverageLocalOfObservations() throws Exception {
        double d = 0.0;
        if (this.debug) {
            MatrixUtils.printMatrix(System.out, this.destPastVectors);
        }
        for (int i = 0; i < this.totalObservations; ++i) {
            TransferEntropyKernelCounts transferEntropyKernelCounts = this.teKernelEstimator.getCount(this.destPastVectors[i], this.destNextVectors[i], this.sourceVectors[i], i);
            double d2 = 0.0;
            double d3 = 0.0;
            if (transferEntropyKernelCounts.countNextPastSource > 0) {
                d2 = (double)transferEntropyKernelCounts.countNextPastSource / (double)transferEntropyKernelCounts.countPastSource / ((double)transferEntropyKernelCounts.countNextPast / (double)transferEntropyKernelCounts.countPast);
                d3 = Math.log(d2);
            }
            d += d3;
            if (!this.debug) continue;
            System.out.println(i + ": " + this.destPastVectors[i][0] + " (" + transferEntropyKernelCounts.countNextPastSource + " / " + transferEntropyKernelCounts.countPastSource + ") / (" + transferEntropyKernelCounts.countNextPast + " / " + transferEntropyKernelCounts.countPast + ") = " + d2 + " -> " + d3 / log2 + " -> sum: " + d / log2);
        }
        this.lastAverage = d / (double)this.totalObservations / log2;
        return this.lastAverage;
    }

    public double computeAverageLocalOfObservationsWithCorrection() throws Exception {
        double d = 0.0;
        for (int i = 0; i < this.totalObservations; ++i) {
            TransferEntropyKernelCounts transferEntropyKernelCounts = this.teKernelEstimator.getCount(this.destPastVectors[i], this.destNextVectors[i], this.sourceVectors[i], i);
            double d2 = 0.0;
            if (transferEntropyKernelCounts.countNextPastSource > 0) {
                d2 = MathsUtils.digamma(transferEntropyKernelCounts.countNextPastSource) - MathsUtils.digamma(transferEntropyKernelCounts.countPastSource) - MathsUtils.digamma(transferEntropyKernelCounts.countNextPast) + MathsUtils.digamma(transferEntropyKernelCounts.countPast);
            }
            d += d2;
        }
        this.lastAverage = d / (double)this.totalObservations / log2;
        return this.lastAverage;
    }

    @Override
    public double[] computeLocalOfPreviousObservations() throws Exception {
        return this.computeLocalUsingPreviousObservations(null, null, true);
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[][] dArray, double[][] dArray2) throws Exception {
        return this.computeLocalUsingPreviousObservations(dArray, dArray2, false);
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[] dArray, double[] dArray2) throws Exception {
        double[][] dArray3 = new double[dArray.length][1];
        MatrixUtils.copyIntoColumn(dArray3, 0, dArray);
        double[][] dArray4 = new double[dArray2.length][1];
        MatrixUtils.copyIntoColumn(dArray4, 0, dArray2);
        return this.computeLocalUsingPreviousObservations(dArray3, dArray4);
    }

    private double[] computeLocalUsingPreviousObservations(double[][] dArray, double[][] dArray2, boolean bl) throws Exception {
        double[] dArray3;
        double[][] dArray4;
        double[][] dArray5;
        double[][] dArray6;
        if (bl) {
            dArray6 = this.destPastVectors;
            dArray5 = this.destNextVectors;
            dArray4 = this.sourceVectors;
        } else {
            dArray6 = this.makeJointVectorForPast(dArray2);
            dArray5 = new double[dArray2.length - this.k][this.destDimensions];
            MatrixUtils.arrayCopy(dArray2, this.k, 0, dArray5, 0, 0, dArray2.length - this.k, this.destDimensions);
            dArray4 = new double[dArray.length - this.k][this.sourceDimensions];
            MatrixUtils.arrayCopy(dArray, this.k - 1, 0, dArray4, 0, 0, dArray.length - this.k, this.sourceDimensions);
        }
        double d = 0.0;
        int n = dArray6.length;
        int n2 = 0;
        if (bl && this.addedMoreThanOneObservationSet) {
            dArray3 = new double[n];
            n2 = 0;
        } else {
            dArray3 = new double[n + this.k];
            n2 = this.k;
        }
        this.localProbNextCondPast = new double[n];
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            TransferEntropyKernelCounts transferEntropyKernelCounts = bl ? this.teKernelEstimator.getCount(dArray6[i], dArray5[i], dArray4[i], i) : this.teKernelEstimator.getCount(dArray6[i], dArray5[i], dArray4[i], -1);
            d2 += (double)transferEntropyKernelCounts.countNextPastSource;
            double d3 = 0.0;
            double d4 = 0.0;
            if (transferEntropyKernelCounts.countPast > 0) {
                this.localProbNextCondPast[i] = (double)transferEntropyKernelCounts.countNextPast / (double)transferEntropyKernelCounts.countPast;
            }
            if (transferEntropyKernelCounts.countNextPastSource > 0) {
                d3 = (double)transferEntropyKernelCounts.countNextPastSource / (double)transferEntropyKernelCounts.countPastSource / this.localProbNextCondPast[i];
                d4 = Math.log(d3) / log2;
            }
            dArray3[n2 + i] = d4;
            d += d4;
        }
        d2 /= (double)n;
        if (this.debug) {
            System.out.printf("Average kernel count was %.3f\n", d2);
        }
        this.lastAverage = d / (double)n;
        return dArray3;
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int n) throws Exception {
        RandomGenerator randomGenerator = new RandomGenerator();
        int[][] nArray = randomGenerator.generateRandomPerturbations(this.totalObservations, n);
        return this.computeSignificance(nArray);
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int[][] nArray) throws Exception {
        int n = nArray.length;
        double d = this.computeAverageLocalOfObservations();
        double[][] dArray = this.sourceVectors;
        int n2 = MatrixUtils.max(nArray);
        if (n2 >= this.sourceVectors.length) {
            throw new Exception("Cannot prescribe a new ordering index of " + n2 + " since this is outside the range 0..n-1, where n=" + this.sourceVectors.length + " is the number of observations that " + "have been supplied to the calculator.");
        }
        int n3 = 0;
        EmpiricalMeasurementDistribution empiricalMeasurementDistribution = new EmpiricalMeasurementDistribution(n);
        for (int i = 0; i < n; ++i) {
            double d2;
            this.sourceVectors = MatrixUtils.extractSelectedTimePoints(dArray, nArray[i]);
            this.teKernelEstimator.initialise(this.k * this.destDimensions, this.sourceDimensions, this.kernelWidth, this.kernelWidth);
            this.teKernelEstimator.setObservations(this.destPastVectors, this.destNextVectors, this.sourceVectors);
            empiricalMeasurementDistribution.distribution[i] = d2 = this.computeAverageLocalOfObservations();
            if (!(d2 >= d)) continue;
            ++n3;
        }
        this.lastAverage = d;
        this.sourceVectors = dArray;
        this.teKernelEstimator.initialise(this.k * this.destDimensions, this.sourceDimensions, this.kernelWidth, this.kernelWidth);
        this.teKernelEstimator.setObservations(this.destPastVectors, this.destNextVectors, this.sourceVectors);
        empiricalMeasurementDistribution.pValue = (double)n3 / (double)n;
        empiricalMeasurementDistribution.actualValue = d;
        return empiricalMeasurementDistribution;
    }

    public double[] computeLocalActiveOfPreviousObservations() throws Exception {
        return this.computeLocalActiveUsingPreviousObservations(null, true);
    }

    public double[] computeLocalActiveUsingPreviousObservations(double[][] dArray) throws Exception {
        return this.computeLocalActiveUsingPreviousObservations(dArray, false);
    }

    private double[] computeLocalActiveUsingPreviousObservations(double[][] dArray, boolean bl) throws Exception {
        double[] dArray2;
        double[][] dArray3;
        if (this.localProbNextCondPast == null) {
            throw new RuntimeException("A local TE must have been computed before the local active info storage can be computed by TransferEntropyCalculatorMultiVariateKernel");
        }
        this.nextStateKernelEstimator.setObservations(this.destNextVectors);
        if (bl) {
            dArray3 = this.destNextVectors;
        } else {
            dArray3 = new double[dArray.length - this.k][this.destDimensions];
            MatrixUtils.arrayCopy(dArray, this.k, 0, dArray3, 0, 0, dArray.length - this.k, this.destDimensions);
        }
        int n = dArray3.length;
        int n2 = 0;
        if (bl && this.addedMoreThanOneObservationSet) {
            dArray2 = new double[n];
            n2 = 0;
        } else {
            dArray2 = new double[n + this.k];
            n2 = this.k;
        }
        for (int i = 0; i < n; ++i) {
            double d = bl ? this.nextStateKernelEstimator.getProbability(dArray3[i], i) : this.nextStateKernelEstimator.getProbability(dArray3[i], -1);
            double d2 = 0.0;
            double d3 = 0.0;
            if (this.localProbNextCondPast[i] > 0.0) {
                d2 = this.localProbNextCondPast[i] / d;
                d3 = Math.log(d2);
            }
            dArray2[n2 + i] = d3 / log2;
        }
        return dArray2;
    }

    @Override
    public void setDebug(boolean bl) {
        super.setDebug(bl);
        this.teKernelEstimator.setDebug(bl);
    }

    private double[][] makeJointVectorForPast(double[][] dArray) {
        try {
            return MatrixUtils.makeDelayEmbeddingVector(dArray, this.k, this.k - 1, dArray.length - this.k);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

