/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.discrete;

import infodynamics.measures.discrete.ChannelCalculatorDiscrete;
import infodynamics.measures.discrete.ContextOfPastMeasureCalculatorDiscrete;
import infodynamics.utils.AnalyticMeasurementDistribution;
import infodynamics.utils.AnalyticNullDistributionComputer;
import infodynamics.utils.ChiSquareMeasurementDistribution;
import infodynamics.utils.EmpiricalMeasurementDistribution;
import infodynamics.utils.MathsUtils;
import infodynamics.utils.MatrixUtils;
import infodynamics.utils.RandomGenerator;

public class TransferEntropyCalculatorDiscrete
extends ContextOfPastMeasureCalculatorDiscrete
implements ChannelCalculatorDiscrete,
AnalyticNullDistributionComputer {
    protected int[][][] sourceNextPastCount = null;
    protected int[][] sourcePastCount = null;
    protected boolean periodicBoundaryConditions = true;
    protected int destEmbeddingDelay = 1;
    protected int sourceHistoryEmbedLength = 1;
    protected int sourceEmbeddingDelay = 1;
    protected int delay = 1;
    protected int base_power_l = 1;
    protected int[] maxShiftedSourceValue = null;
    protected int startObservationTime = 1;
    protected boolean estimateComputed = false;

    public static TransferEntropyCalculatorDiscrete newInstance(int n, int n2) {
        return new TransferEntropyCalculatorDiscrete(n, n2);
    }

    public TransferEntropyCalculatorDiscrete(int n, int n2) {
        this(n, n2, 1, 1, 1, 1);
    }

    public TransferEntropyCalculatorDiscrete(int n, int n2, int n3) {
        this(n, n2, 1, n3, 1, 1);
    }

    public TransferEntropyCalculatorDiscrete(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2);
        int n7;
        this.destEmbeddingDelay = n3;
        if (n4 <= 0) {
            throw new RuntimeException("Cannot have source embedding length of zero or less");
        }
        this.sourceHistoryEmbedLength = n4;
        this.sourceEmbeddingDelay = n5;
        this.delay = n6;
        this.base_power_l = MathsUtils.power(n, this.sourceHistoryEmbedLength);
        if ((double)this.sourceHistoryEmbedLength > Math.log(2.147483647E9) / this.log_base) {
            throw new RuntimeException("Base and source history combination too large");
        }
        this.maxShiftedSourceValue = new int[n];
        for (n7 = 0; n7 < n; ++n7) {
            this.maxShiftedSourceValue[n7] = n7 * MathsUtils.power(n, this.sourceHistoryEmbedLength - 1);
        }
        this.sourceNextPastCount = new int[this.base_power_l][n][this.base_power_k];
        this.sourcePastCount = new int[this.base_power_l][this.base_power_k];
        n7 = (this.k - 1) * n3 + 1;
        int n8 = (this.sourceHistoryEmbedLength - 1) * n5 + n6;
        this.startObservationTime = Math.max(n7, n8);
    }

    @Override
    public void initialise() {
        super.initialise();
        this.estimateComputed = false;
        MatrixUtils.fill(this.sourceNextPastCount, 0);
        MatrixUtils.fill(this.sourcePastCount, 0);
    }

    @Override
    public void addObservations(int[] nArray, int[] nArray2) {
        this.addObservations(nArray, nArray2, 0, nArray2.length - 1);
    }

    public void addObservations(int[] nArray, int[] nArray2, int n, int n2) {
        int n3;
        int n4;
        if (n2 - n - this.startObservationTime + 1 <= 0) {
            return;
        }
        if (n2 >= nArray2.length || n2 >= nArray.length) {
            throw new ArrayIndexOutOfBoundsException(String.format("endTime (%d) must be <= length of input arrays (dest: %d, source: %d)", n2, nArray2.length, nArray.length));
        }
        this.observations += n2 - n - this.startObservationTime + 1;
        int[] nArray3 = new int[this.destEmbeddingDelay];
        for (int i = 0; i < this.destEmbeddingDelay; ++i) {
            nArray3[i] = 0;
            for (n4 = 0; n4 < this.k - 1; ++n4) {
                int n5 = i;
                nArray3[n5] = nArray3[n5] + nArray2[n + this.startObservationTime + i - 1 - (this.k - 1) * this.destEmbeddingDelay + n4 * this.destEmbeddingDelay];
                int n6 = i;
                nArray3[n6] = nArray3[n6] * this.base;
            }
        }
        int[] nArray4 = new int[this.sourceEmbeddingDelay];
        for (n4 = 0; n4 < this.sourceEmbeddingDelay; ++n4) {
            nArray4[n4] = 0;
            for (n3 = 0; n3 < this.sourceHistoryEmbedLength - 1; ++n3) {
                int n7 = n4;
                nArray4[n7] = nArray4[n7] + nArray[n + this.startObservationTime + n4 - this.delay - (this.sourceHistoryEmbedLength - 1) * this.sourceEmbeddingDelay + n3 * this.sourceEmbeddingDelay];
                int n8 = n4;
                nArray4[n8] = nArray4[n8] * this.base;
            }
        }
        n3 = 0;
        int n9 = 0;
        for (int i = n + this.startObservationTime; i <= n2; ++i) {
            if (this.k > 0) {
                int n10 = n3;
                nArray3[n10] = nArray3[n10] + nArray2[i - 1];
            }
            int n11 = n9;
            nArray4[n11] = nArray4[n11] + nArray[i - this.delay];
            n4 = nArray2[i];
            int n12 = nArray3[n3];
            int n13 = nArray4[n9];
            int[] nArray5 = this.sourceNextPastCount[n13][n4];
            int n14 = n12;
            nArray5[n14] = nArray5[n14] + 1;
            int[] nArray6 = this.sourcePastCount[n13];
            int n15 = n12;
            nArray6[n15] = nArray6[n15] + 1;
            int[] nArray7 = this.nextPastCount[n4];
            int n16 = n12;
            nArray7[n16] = nArray7[n16] + 1;
            int n17 = n12;
            this.pastCount[n17] = this.pastCount[n17] + 1;
            int n18 = n4;
            this.nextCount[n18] = this.nextCount[n18] + 1;
            if (this.k > 0) {
                int n19 = n3;
                nArray3[n19] = nArray3[n19] - this.maxShiftedValue[nArray2[i - 1 - (this.k - 1) * this.destEmbeddingDelay]];
                int n20 = n3;
                nArray3[n20] = nArray3[n20] * this.base;
            }
            int n21 = n9;
            nArray4[n21] = nArray4[n21] - this.maxShiftedSourceValue[nArray[i - this.delay - (this.sourceHistoryEmbedLength - 1) * this.sourceEmbeddingDelay]];
            int n22 = n9;
            nArray4[n22] = nArray4[n22] * this.base;
            n3 = (n3 + 1) % this.destEmbeddingDelay;
            n9 = (n9 + 1) % this.sourceEmbeddingDelay;
        }
    }

    public void addObservations(int[] nArray, int[] nArray2, boolean[] blArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = nArray2.length;
        if (nArray2.length - this.startObservationTime <= 0) {
            return;
        }
        int[] nArray3 = new int[this.destEmbeddingDelay];
        for (n5 = 0; n5 < this.destEmbeddingDelay; ++n5) {
            nArray3[n5] = 0;
            for (n4 = 0; n4 < this.k - 1; ++n4) {
                int n7 = n5;
                nArray3[n7] = nArray3[n7] + nArray2[this.startObservationTime + n5 - 1 - (this.k - 1) * this.destEmbeddingDelay + n4 * this.destEmbeddingDelay];
                int n8 = n5;
                nArray3[n8] = nArray3[n8] * this.base;
            }
        }
        n4 = n5 = this.k > 0 ? (this.k - 1) * this.destEmbeddingDelay + 1 : 0;
        for (int i = this.startObservationTime - 1; i >= 0; --i) {
            if (blArray[i]) continue;
            n4 = this.startObservationTime - i - 1;
            break;
        }
        int[] nArray4 = new int[this.sourceEmbeddingDelay];
        for (n3 = 0; n3 < this.sourceEmbeddingDelay; ++n3) {
            nArray4[n3] = 0;
            for (n2 = 0; n2 < this.sourceHistoryEmbedLength - 1; ++n2) {
                int n9 = n3;
                nArray4[n9] = nArray4[n9] + nArray[this.startObservationTime + n3 - this.delay - (this.sourceHistoryEmbedLength - 1) * this.sourceEmbeddingDelay + n2 * this.sourceEmbeddingDelay];
                int n10 = n3;
                nArray4[n10] = nArray4[n10] * this.base;
            }
        }
        n2 = n3 = (this.sourceHistoryEmbedLength - 1) * this.sourceEmbeddingDelay + 1;
        for (n = this.startObservationTime - this.delay; n >= 0; --n) {
            if (blArray[n]) continue;
            n2 = this.startObservationTime - n - 1;
            break;
        }
        int n11 = 0;
        int n12 = 0;
        for (int i = this.startObservationTime; i < n6; ++i) {
            ++n4;
            ++n2;
            if (this.k > 0) {
                int n13 = n11;
                nArray3[n13] = nArray3[n13] + nArray2[i - 1];
            }
            int n14 = n12;
            nArray4[n14] = nArray4[n14] + nArray[i - this.delay];
            if (!blArray[i]) {
                n4 = 0;
            }
            if (!blArray[i - this.delay]) {
                n2 = 0;
            }
            if (n4 > n5 && n2 >= n3) {
                n = nArray2[i];
                int n15 = nArray3[n11];
                int n16 = nArray4[n12];
                int[] nArray5 = this.sourceNextPastCount[n16][n];
                int n17 = n15;
                nArray5[n17] = nArray5[n17] + 1;
                int[] nArray6 = this.sourcePastCount[n16];
                int n18 = n15;
                nArray6[n18] = nArray6[n18] + 1;
                int[] nArray7 = this.nextPastCount[n];
                int n19 = n15;
                nArray7[n19] = nArray7[n19] + 1;
                int n20 = n15;
                this.pastCount[n20] = this.pastCount[n20] + 1;
                int n21 = n;
                this.nextCount[n21] = this.nextCount[n21] + 1;
                ++this.observations;
            }
            if (this.k > 0) {
                int n22 = n11;
                nArray3[n22] = nArray3[n22] - this.maxShiftedValue[nArray2[i - 1 - (this.k - 1) * this.destEmbeddingDelay]];
                int n23 = n11;
                nArray3[n23] = nArray3[n23] * this.base;
            }
            int n24 = n12;
            nArray4[n24] = nArray4[n24] - this.maxShiftedSourceValue[nArray[i - this.delay - (this.sourceHistoryEmbedLength - 1) * this.sourceEmbeddingDelay]];
            int n25 = n12;
            nArray4[n25] = nArray4[n25] * this.base;
            n11 = (n11 + 1) % this.destEmbeddingDelay;
            n12 = (n12 + 1) % this.sourceEmbeddingDelay;
        }
    }

    public void addObservations(int[][] nArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = nArray.length;
        if (n6 - this.startObservationTime <= 0) {
            return;
        }
        int n7 = nArray[0].length;
        this.observations = this.periodicBoundaryConditions ? (this.observations += (n6 - this.startObservationTime) * n7) : (this.observations += (n6 - this.startObservationTime) * (n7 - Math.abs(n)));
        int[][] nArray2 = new int[n7][this.destEmbeddingDelay];
        for (int i = 0; i < n7; ++i) {
            for (n5 = 0; n5 < this.destEmbeddingDelay; ++n5) {
                nArray2[i][n5] = 0;
                for (n4 = 0; n4 < this.k - 1; ++n4) {
                    int[] nArray3 = nArray2[i];
                    int n8 = n5;
                    nArray3[n8] = nArray3[n8] + nArray[this.startObservationTime + n5 - 1 - (this.k - 1) * this.destEmbeddingDelay + n4 * this.destEmbeddingDelay][i];
                    int[] nArray4 = nArray2[i];
                    int n9 = n5;
                    nArray4[n9] = nArray4[n9] * this.base;
                }
            }
        }
        int[][] nArray5 = new int[n7][this.sourceEmbeddingDelay];
        for (n5 = 0; n5 < n7; ++n5) {
            n4 = n5 - n;
            if (n4 < 0 || n4 >= n7) {
                if (!this.periodicBoundaryConditions) continue;
                n4 = (n4 + n7) % n7;
            }
            for (n3 = 0; n3 < this.sourceEmbeddingDelay; ++n3) {
                nArray5[n5][n3] = 0;
                for (n2 = 0; n2 < this.sourceHistoryEmbedLength - 1; ++n2) {
                    int[] nArray6 = nArray5[n5];
                    int n10 = n3;
                    nArray6[n10] = nArray6[n10] + nArray[this.startObservationTime + n3 - this.delay - (this.sourceHistoryEmbedLength - 1) * this.sourceEmbeddingDelay + n2 * this.sourceEmbeddingDelay][n4];
                    int[] nArray7 = nArray5[n5];
                    int n11 = n3;
                    nArray7[n11] = nArray7[n11] * this.base;
                }
            }
        }
        n4 = 0;
        n3 = 0;
        for (n2 = this.startObservationTime; n2 < n6; ++n2) {
            for (int i = 0; i < n7; ++i) {
                int n12 = i - n;
                if (n12 < 0 || n12 >= n7) {
                    if (!this.periodicBoundaryConditions) continue;
                    n12 = (n12 + n7) % n7;
                }
                if (this.k > 0) {
                    int[] nArray8 = nArray2[i];
                    int n13 = n4;
                    nArray8[n13] = nArray8[n13] + nArray[n2 - 1][i];
                }
                int[] nArray9 = nArray5[i];
                int n14 = n3;
                nArray9[n14] = nArray9[n14] + nArray[n2 - this.delay][n12];
                n5 = nArray[n2][i];
                int n15 = nArray2[i][n4];
                int n16 = nArray5[i][n3];
                int[] nArray10 = this.sourceNextPastCount[n16][n5];
                int n17 = n15;
                nArray10[n17] = nArray10[n17] + 1;
                int[] nArray11 = this.sourcePastCount[n16];
                int n18 = n15;
                nArray11[n18] = nArray11[n18] + 1;
                int[] nArray12 = this.nextPastCount[n5];
                int n19 = n15;
                nArray12[n19] = nArray12[n19] + 1;
                int n20 = n15;
                this.pastCount[n20] = this.pastCount[n20] + 1;
                int n21 = n5;
                this.nextCount[n21] = this.nextCount[n21] + 1;
                if (this.k > 0) {
                    int[] nArray13 = nArray2[i];
                    int n22 = n4;
                    nArray13[n22] = nArray13[n22] - this.maxShiftedValue[nArray[n2 - 1 - (this.k - 1) * this.destEmbeddingDelay][i]];
                    int[] nArray14 = nArray2[i];
                    int n23 = n4;
                    nArray14[n23] = nArray14[n23] * this.base;
                }
                int[] nArray15 = nArray5[i];
                int n24 = n3;
                nArray15[n24] = nArray15[n24] - this.maxShiftedSourceValue[nArray[n2 - this.delay - (this.sourceHistoryEmbedLength - 1) * this.sourceEmbeddingDelay][n12]];
                int[] nArray16 = nArray5[i];
                int n25 = n3;
                nArray16[n25] = nArray16[n25] * this.base;
            }
            n4 = (n4 + 1) % this.destEmbeddingDelay;
            n3 = (n3 + 1) % this.sourceEmbeddingDelay;
        }
    }

    public void addObservations(int[][][] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = nArray.length;
        if (n9 - this.startObservationTime <= 0) {
            return;
        }
        int n10 = nArray[0].length;
        if (n10 == 0) {
            return;
        }
        int n11 = nArray[0][0].length;
        this.observations = this.periodicBoundaryConditions ? (this.observations += (n9 - this.startObservationTime) * n10 * n11) : (this.observations += (n9 - this.startObservationTime) * (n10 - Math.abs(n)) * (n11 - Math.abs(n2)));
        int[][][] nArray2 = new int[n10][n11][this.destEmbeddingDelay];
        for (int i = 0; i < n10; ++i) {
            for (n8 = 0; n8 < n11; ++n8) {
                for (n7 = 0; n7 < this.destEmbeddingDelay; ++n7) {
                    nArray2[i][n8][n7] = 0;
                    for (n6 = 0; n6 < this.k - 1; ++n6) {
                        int[] nArray3 = nArray2[i][n8];
                        int n12 = n7;
                        nArray3[n12] = nArray3[n12] + nArray[this.startObservationTime + n7 - 1 - (this.k - 1) * this.destEmbeddingDelay + n6 * this.destEmbeddingDelay][i][n8];
                        int[] nArray4 = nArray2[i][n8];
                        int n13 = n7;
                        nArray4[n13] = nArray4[n13] * this.base;
                    }
                }
            }
        }
        int[][][] nArray5 = new int[n10][n11][this.sourceEmbeddingDelay];
        for (n8 = 0; n8 < n10; ++n8) {
            for (n7 = 0; n7 < n11; ++n7) {
                n6 = n8 - n;
                if (n6 < 0 || n6 >= n10) {
                    if (!this.periodicBoundaryConditions) continue;
                    n6 = (n6 + n10) % n10;
                }
                if ((n5 = n7 - n2) < 0 || n5 >= n11) {
                    if (!this.periodicBoundaryConditions) continue;
                    n5 = (n5 + n11) % n11;
                }
                for (n4 = 0; n4 < this.sourceEmbeddingDelay; ++n4) {
                    nArray5[n8][n7][n4] = 0;
                    for (n3 = 0; n3 < this.sourceHistoryEmbedLength - 1; ++n3) {
                        int[] nArray6 = nArray5[n8][n7];
                        int n14 = n4;
                        nArray6[n14] = nArray6[n14] + nArray[this.startObservationTime + n4 - this.delay - (this.sourceHistoryEmbedLength - 1) * this.sourceEmbeddingDelay + n3 * this.sourceEmbeddingDelay][n6][n5];
                        int[] nArray7 = nArray5[n8][n7];
                        int n15 = n4;
                        nArray7[n15] = nArray7[n15] * this.base;
                    }
                }
            }
        }
        n7 = 0;
        n6 = 0;
        for (n5 = this.startObservationTime; n5 < n9; ++n5) {
            for (n4 = 0; n4 < n10; ++n4) {
                for (n3 = 0; n3 < n11; ++n3) {
                    int n16;
                    int n17 = n4 - n;
                    if (n17 < 0 || n17 >= n10) {
                        if (!this.periodicBoundaryConditions) continue;
                        n17 = (n17 + n10) % n10;
                    }
                    if ((n16 = n3 - n2) < 0 || n16 >= n11) {
                        if (!this.periodicBoundaryConditions) continue;
                        n16 = (n16 + n11) % n11;
                    }
                    if (this.k > 0) {
                        int[] nArray8 = nArray2[n4][n3];
                        int n18 = n7;
                        nArray8[n18] = nArray8[n18] + nArray[n5 - 1][n4][n3];
                    }
                    int[] nArray9 = nArray5[n4][n3];
                    int n19 = n6;
                    nArray9[n19] = nArray9[n19] + nArray[n5 - this.delay][n17][n16];
                    n8 = nArray[n5][n4][n3];
                    int n20 = nArray2[n4][n3][n7];
                    int n21 = nArray5[n4][n3][n6];
                    int[] nArray10 = this.sourceNextPastCount[n21][n8];
                    int n22 = n20;
                    nArray10[n22] = nArray10[n22] + 1;
                    int[] nArray11 = this.sourcePastCount[n21];
                    int n23 = n20;
                    nArray11[n23] = nArray11[n23] + 1;
                    int[] nArray12 = this.nextPastCount[n8];
                    int n24 = n20;
                    nArray12[n24] = nArray12[n24] + 1;
                    int n25 = n20;
                    this.pastCount[n25] = this.pastCount[n25] + 1;
                    int n26 = n8;
                    this.nextCount[n26] = this.nextCount[n26] + 1;
                    if (this.k > 0) {
                        int[] nArray13 = nArray2[n4][n3];
                        int n27 = n7;
                        nArray13[n27] = nArray13[n27] - this.maxShiftedValue[nArray[n5 - 1 - (this.k - 1) * this.destEmbeddingDelay][n4][n3]];
                        int[] nArray14 = nArray2[n4][n3];
                        int n28 = n7;
                        nArray14[n28] = nArray14[n28] * this.base;
                    }
                    int[] nArray15 = nArray5[n4][n3];
                    int n29 = n6;
                    nArray15[n29] = nArray15[n29] - this.maxShiftedSourceValue[nArray[n5 - this.delay - (this.sourceHistoryEmbedLength - 1) * this.sourceEmbeddingDelay][n17][n16]];
                    int[] nArray16 = nArray5[n4][n3];
                    int n30 = n6;
                    nArray16[n30] = nArray16[n30] * this.base;
                }
            }
            n7 = (n7 + 1) % this.destEmbeddingDelay;
            n6 = (n6 + 1) % this.sourceEmbeddingDelay;
        }
    }

    @Override
    public void addObservations(int[][] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5 = nArray.length;
        if (n5 - this.startObservationTime <= 0) {
            return;
        }
        this.observations += n5 - this.startObservationTime;
        int[] nArray2 = new int[this.destEmbeddingDelay];
        for (int i = 0; i < this.destEmbeddingDelay; ++i) {
            nArray2[i] = 0;
            for (n4 = 0; n4 < this.k - 1; ++n4) {
                int n6 = i;
                nArray2[n6] = nArray2[n6] + nArray[this.startObservationTime + i - 1 - (this.k - 1) * this.destEmbeddingDelay + n4 * this.destEmbeddingDelay][n2];
                int n7 = i;
                nArray2[n7] = nArray2[n7] * this.base;
            }
        }
        int[] nArray3 = new int[this.sourceEmbeddingDelay];
        for (n4 = 0; n4 < this.sourceEmbeddingDelay; ++n4) {
            nArray3[n4] = 0;
            for (n3 = 0; n3 < this.sourceHistoryEmbedLength - 1; ++n3) {
                int n8 = n4;
                nArray3[n8] = nArray3[n8] + nArray[this.startObservationTime + n4 - this.delay - (this.sourceHistoryEmbedLength - 1) * this.sourceEmbeddingDelay + n3 * this.sourceEmbeddingDelay][n];
                int n9 = n4;
                nArray3[n9] = nArray3[n9] * this.base;
            }
        }
        n3 = 0;
        int n10 = 0;
        for (int i = this.startObservationTime; i < n5; ++i) {
            if (this.k > 0) {
                int n11 = n3;
                nArray2[n11] = nArray2[n11] + nArray[i - 1][n2];
            }
            int n12 = n10;
            nArray3[n12] = nArray3[n12] + nArray[i - this.delay][n];
            n4 = nArray[i][n2];
            int n13 = nArray2[n3];
            int n14 = nArray3[n10];
            int[] nArray4 = this.sourceNextPastCount[n14][n4];
            int n15 = n13;
            nArray4[n15] = nArray4[n15] + 1;
            int[] nArray5 = this.sourcePastCount[n14];
            int n16 = n13;
            nArray5[n16] = nArray5[n16] + 1;
            int[] nArray6 = this.nextPastCount[n4];
            int n17 = n13;
            nArray6[n17] = nArray6[n17] + 1;
            int n18 = n13;
            this.pastCount[n18] = this.pastCount[n18] + 1;
            int n19 = n4;
            this.nextCount[n19] = this.nextCount[n19] + 1;
            if (this.k > 0) {
                int n20 = n3;
                nArray2[n20] = nArray2[n20] - this.maxShiftedValue[nArray[i - 1 - (this.k - 1) * this.destEmbeddingDelay][n2]];
                int n21 = n3;
                nArray2[n21] = nArray2[n21] * this.base;
            }
            int n22 = n10;
            nArray3[n22] = nArray3[n22] - this.maxShiftedSourceValue[nArray[i - this.delay - (this.sourceHistoryEmbedLength - 1) * this.sourceEmbeddingDelay][n]];
            int n23 = n10;
            nArray3[n23] = nArray3[n23] * this.base;
            n3 = (n3 + 1) % this.destEmbeddingDelay;
            n10 = (n10 + 1) % this.sourceEmbeddingDelay;
        }
    }

    public void addObservations(int[][][] nArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = nArray.length;
        if (n7 - this.startObservationTime <= 0) {
            return;
        }
        this.observations += n7 - this.startObservationTime;
        int[] nArray2 = new int[this.destEmbeddingDelay];
        for (int i = 0; i < this.destEmbeddingDelay; ++i) {
            nArray2[i] = 0;
            for (n6 = 0; n6 < this.k - 1; ++n6) {
                int n8 = i;
                nArray2[n8] = nArray2[n8] + nArray[this.startObservationTime + i - 1 - (this.k - 1) * this.destEmbeddingDelay + n6 * this.destEmbeddingDelay][n3][n4];
                int n9 = i;
                nArray2[n9] = nArray2[n9] * this.base;
            }
        }
        int[] nArray3 = new int[this.sourceEmbeddingDelay];
        for (n6 = 0; n6 < this.sourceEmbeddingDelay; ++n6) {
            nArray3[n6] = 0;
            for (n5 = 0; n5 < this.sourceHistoryEmbedLength - 1; ++n5) {
                int n10 = n6;
                nArray3[n10] = nArray3[n10] + nArray[this.startObservationTime + n6 - this.delay - (this.sourceHistoryEmbedLength - 1) * this.sourceEmbeddingDelay + n5 * this.sourceEmbeddingDelay][n][n2];
                int n11 = n6;
                nArray3[n11] = nArray3[n11] * this.base;
            }
        }
        n5 = 0;
        int n12 = 0;
        for (int i = this.startObservationTime; i < n7; ++i) {
            if (this.k > 0) {
                int n13 = n5;
                nArray2[n13] = nArray2[n13] + nArray[i - 1][n3][n4];
            }
            int n14 = n12;
            nArray3[n14] = nArray3[n14] + nArray[i - this.delay][n][n2];
            n6 = nArray[i][n3][n4];
            int n15 = nArray2[n5];
            int n16 = nArray3[n12];
            int[] nArray4 = this.sourceNextPastCount[n16][n6];
            int n17 = n15;
            nArray4[n17] = nArray4[n17] + 1;
            int[] nArray5 = this.sourcePastCount[n16];
            int n18 = n15;
            nArray5[n18] = nArray5[n18] + 1;
            int[] nArray6 = this.nextPastCount[n6];
            int n19 = n15;
            nArray6[n19] = nArray6[n19] + 1;
            int n20 = n15;
            this.pastCount[n20] = this.pastCount[n20] + 1;
            int n21 = n6;
            this.nextCount[n21] = this.nextCount[n21] + 1;
            if (this.k > 0) {
                int n22 = n5;
                nArray2[n22] = nArray2[n22] - this.maxShiftedValue[nArray[i - 1 - (this.k - 1) * this.destEmbeddingDelay][n3][n4]];
                int n23 = n5;
                nArray2[n23] = nArray2[n23] * this.base;
            }
            int n24 = n12;
            nArray3[n24] = nArray3[n24] - this.maxShiftedSourceValue[nArray[i - this.delay - (this.sourceHistoryEmbedLength - 1) * this.sourceEmbeddingDelay][n][n2]];
            int n25 = n12;
            nArray3[n25] = nArray3[n25] * this.base;
            n5 = (n5 + 1) % this.destEmbeddingDelay;
            n12 = (n12 + 1) % this.sourceEmbeddingDelay;
        }
    }

    public int getPastCount(int n) {
        return this.pastCount[n];
    }

    public double getPastProbability(int n) {
        return (double)this.pastCount[n] / (double)this.observations;
    }

    public int getNextPastCount(int n, int n2) {
        return this.nextPastCount[n][n2];
    }

    public double getNextPastProbability(int n, int n2) {
        return (double)this.nextPastCount[n][n2] / (double)this.observations;
    }

    public int getSourcePastCount(int n, int n2) {
        return this.sourcePastCount[n][n2];
    }

    public double getSourcePastProbability(int n, int n2) {
        return (double)this.sourcePastCount[n][n2] / (double)this.observations;
    }

    public int getSourceNextPastCount(int n, int n2, int n3) {
        return this.sourceNextPastCount[n][n2][n3];
    }

    public double getSourceNextPastProbability(int n, int n2, int n3) {
        return (double)this.sourceNextPastCount[n][n2][n3] / (double)this.observations;
    }

    public int getNextCount(int n) {
        return this.nextCount[n];
    }

    public double getNextProbability(int n) {
        return (double)this.nextCount[n] / (double)this.observations;
    }

    @Override
    public double computeAverageLocalOfObservations() {
        double d = 0.0;
        double d2 = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.base_power_k; ++i) {
            if (this.pastCount[i] == 0) continue;
            for (int j = 0; j < this.base; ++j) {
                if (this.nextPastCount[j][i] == 0) continue;
                double d4 = (double)this.nextPastCount[j][i] / (double)this.pastCount[i];
                for (int k = 0; k < this.base_power_l; ++k) {
                    if (this.sourceNextPastCount[k][j][i] != 0) {
                        double d5 = (double)this.sourceNextPastCount[k][j][i] / (double)this.observations;
                        double d6 = (double)this.sourceNextPastCount[k][j][i] / (double)this.sourcePastCount[k][i] / d4;
                        double d7 = Math.log(d6);
                        d2 = d5 * d7;
                        if (d7 > this.max) {
                            this.max = d7;
                        } else if (d7 < this.min) {
                            this.min = d7;
                        }
                        d3 += d2 * d7;
                    } else {
                        d2 = 0.0;
                    }
                    d += d2;
                }
            }
        }
        this.max /= this.log_2;
        this.min /= this.log_2;
        this.average = d /= this.log_2;
        this.std = Math.sqrt((d3 /= this.log_2 * this.log_2) - this.average * this.average);
        this.estimateComputed = true;
        return d;
    }

    public double computeAverageActiveInfoStorageOfObservations() {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.base; ++i) {
            double d3 = (double)this.nextCount[i] / (double)this.observations;
            for (int j = 0; j < this.base_power_k; ++j) {
                if (this.nextPastCount[i][j] != 0) {
                    double d4 = (double)this.nextPastCount[i][j] / (double)this.pastCount[j] / d3;
                    double d5 = Math.log(d4) / this.log_2;
                    d2 = (double)this.nextPastCount[i][j] / (double)this.observations * d5;
                } else {
                    d2 = 0.0;
                }
                d += d2;
            }
        }
        return d;
    }

    public void debugPrintObservations() {
        System.out.println("Src\tDst\tPast\tc(s,d,p)\tc(s,p)\tc(d,p)\tc(p)");
        for (int i = 0; i < this.base_power_k; ++i) {
            for (int j = 0; j < this.base; ++j) {
                for (int k = 0; k < this.base_power_l; ++k) {
                    System.out.println(k + "\t" + j + "\t" + i + "\t" + this.sourceNextPastCount[k][j][i] + "\t\t" + this.sourcePastCount[k][i] + "\t" + this.nextPastCount[j][i] + "\t" + this.pastCount[i]);
                }
            }
        }
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int n) {
        RandomGenerator randomGenerator = new RandomGenerator();
        int[][] nArray = randomGenerator.generateRandomPerturbations(this.observations, n);
        return this.computeSignificance(nArray);
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int[][] nArray) {
        int n;
        int n2;
        double d = this.computeAverageLocalOfObservations();
        int n3 = nArray.length;
        int[] nArray2 = new int[this.observations];
        int n4 = 0;
        for (int i = 0; i < this.base_power_l; ++i) {
            int n5 = 0;
            for (n2 = 0; n2 < this.base_power_k; ++n2) {
                n5 += this.sourcePastCount[i][n2];
            }
            MatrixUtils.fill(nArray2, i, n4, n5);
            n4 += n5;
        }
        int[] nArray3 = new int[this.observations];
        int[] nArray4 = new int[this.observations];
        n2 = 0;
        int n6 = 0;
        for (int i = 0; i < this.base_power_k; ++i) {
            MatrixUtils.fill(nArray4, i, n6, this.pastCount[i]);
            n6 += this.pastCount[i];
            for (n = 0; n < this.base; ++n) {
                MatrixUtils.fill(nArray3, n, n2, this.nextPastCount[n][i]);
                n2 += this.nextPastCount[n][i];
            }
        }
        TransferEntropyCalculatorDiscrete transferEntropyCalculatorDiscrete = new TransferEntropyCalculatorDiscrete(this.base, this.k, this.destEmbeddingDelay, this.sourceHistoryEmbedLength, this.sourceEmbeddingDelay, this.delay);
        transferEntropyCalculatorDiscrete.initialise();
        transferEntropyCalculatorDiscrete.observations = this.observations;
        transferEntropyCalculatorDiscrete.pastCount = this.pastCount;
        transferEntropyCalculatorDiscrete.nextPastCount = this.nextPastCount;
        n = 0;
        EmpiricalMeasurementDistribution empiricalMeasurementDistribution = new EmpiricalMeasurementDistribution(n3);
        for (int i = 0; i < n3; ++i) {
            double d2;
            int[] nArray5 = MatrixUtils.extractSelectedTimePoints(nArray2, nArray[i]);
            MatrixUtils.fill(transferEntropyCalculatorDiscrete.sourceNextPastCount, 0);
            MatrixUtils.fill(transferEntropyCalculatorDiscrete.sourcePastCount, 0);
            for (int j = 0; j < this.observations; ++j) {
                int[] nArray6 = transferEntropyCalculatorDiscrete.sourcePastCount[nArray5[j]];
                int n7 = nArray4[j];
                nArray6[n7] = nArray6[n7] + 1;
                int[] nArray7 = transferEntropyCalculatorDiscrete.sourceNextPastCount[nArray5[j]][nArray3[j]];
                int n8 = nArray4[j];
                nArray7[n8] = nArray7[n8] + 1;
            }
            empiricalMeasurementDistribution.distribution[i] = d2 = transferEntropyCalculatorDiscrete.computeAverageLocalOfObservations();
            if (!(d2 >= d)) continue;
            ++n;
        }
        empiricalMeasurementDistribution.pValue = (double)n / (double)n3;
        empiricalMeasurementDistribution.actualValue = d;
        return empiricalMeasurementDistribution;
    }

    @Override
    public AnalyticMeasurementDistribution computeSignificance() throws Exception {
        if (!this.estimateComputed) {
            this.computeAverageLocalOfObservations();
        }
        return new ChiSquareMeasurementDistribution(this.average, this.observations, (this.base_power_l - 1) * (this.base - 1) * this.base_power_k);
    }

    public double computeLocalFromPreviousObservations(int n, int n2, int n3) {
        double d = (double)this.sourceNextPastCount[n][n2][n3] / (double)this.sourcePastCount[n][n3] / ((double)this.nextPastCount[n2][n3] / (double)this.pastCount[n3]);
        return Math.log(d) / this.log_2;
    }

    public double[] computeLocalFromPreviousObservations(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3 = nArray2.length;
        double[] dArray = new double[n3];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        if (n3 - this.startObservationTime <= 0) {
            return dArray;
        }
        int[] nArray3 = new int[this.destEmbeddingDelay];
        for (int i = 0; i < this.destEmbeddingDelay; ++i) {
            nArray3[i] = 0;
            for (n2 = 0; n2 < this.k - 1; ++n2) {
                int n4 = i;
                nArray3[n4] = nArray3[n4] + nArray2[this.startObservationTime + i - 1 - (this.k - 1) * this.destEmbeddingDelay + n2 * this.destEmbeddingDelay];
                int n5 = i;
                nArray3[n5] = nArray3[n5] * this.base;
            }
        }
        int[] nArray4 = new int[this.sourceEmbeddingDelay];
        for (n2 = 0; n2 < this.sourceEmbeddingDelay; ++n2) {
            nArray4[n2] = 0;
            for (n = 0; n < this.sourceHistoryEmbedLength - 1; ++n) {
                int n6 = n2;
                nArray4[n6] = nArray4[n6] + nArray[this.startObservationTime + n2 - this.delay - (this.sourceHistoryEmbedLength - 1) * this.sourceEmbeddingDelay + n * this.sourceEmbeddingDelay];
                int n7 = n2;
                nArray4[n7] = nArray4[n7] * this.base;
            }
        }
        n = 0;
        int n8 = 0;
        for (int i = this.startObservationTime; i < n3; ++i) {
            if (this.k > 0) {
                int n9 = n;
                nArray3[n9] = nArray3[n9] + nArray2[i - 1];
            }
            int n10 = n8;
            nArray4[n10] = nArray4[n10] + nArray[i - this.delay];
            n2 = nArray2[i];
            int n11 = nArray3[n];
            int n12 = nArray4[n8];
            double d = (double)this.sourceNextPastCount[n12][n2][n11] / (double)this.sourcePastCount[n12][n11] / ((double)this.nextPastCount[n2][n11] / (double)this.pastCount[n11]);
            dArray[i] = Math.log(d) / this.log_2;
            this.average += dArray[i];
            if (dArray[i] > this.max) {
                this.max = dArray[i];
            } else if (dArray[i] < this.min) {
                this.min = dArray[i];
            }
            if (this.k > 0) {
                int n13 = n;
                nArray3[n13] = nArray3[n13] - this.maxShiftedValue[nArray2[i - 1 - (this.k - 1) * this.destEmbeddingDelay]];
                int n14 = n;
                nArray3[n14] = nArray3[n14] * this.base;
            }
            int n15 = n8;
            nArray4[n15] = nArray4[n15] - this.maxShiftedSourceValue[nArray[i - this.delay - (this.sourceHistoryEmbedLength - 1) * this.sourceEmbeddingDelay]];
            int n16 = n8;
            nArray4[n16] = nArray4[n16] * this.base;
            n = (n + 1) % this.destEmbeddingDelay;
            n8 = (n8 + 1) % this.sourceEmbeddingDelay;
        }
        this.average /= (double)(n3 - this.startObservationTime);
        return dArray;
    }

    public double[][] computeLocalFromPreviousObservations(int[][] nArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5 = nArray.length;
        if (n5 == 0 || nArray[0] == null) {
            return new double[n5][];
        }
        int n6 = nArray[0].length;
        double[][] dArray = new double[n5][n6];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        if (n5 - this.startObservationTime <= 0) {
            return dArray;
        }
        int[][] nArray2 = new int[n6][this.destEmbeddingDelay];
        for (int i = 0; i < n6; ++i) {
            for (n4 = 0; n4 < this.destEmbeddingDelay; ++n4) {
                nArray2[i][n4] = 0;
                for (n3 = 0; n3 < this.k - 1; ++n3) {
                    int[] nArray3 = nArray2[i];
                    int n7 = n4;
                    nArray3[n7] = nArray3[n7] + nArray[this.startObservationTime + n4 - 1 - (this.k - 1) * this.destEmbeddingDelay + n3 * this.destEmbeddingDelay][i];
                    int[] nArray4 = nArray2[i];
                    int n8 = n4;
                    nArray4[n8] = nArray4[n8] * this.base;
                }
            }
        }
        int[][] nArray5 = new int[n6][this.sourceEmbeddingDelay];
        for (n4 = 0; n4 < n6; ++n4) {
            n3 = n4 - n;
            if (n3 < 0 || n3 >= n6) {
                if (!this.periodicBoundaryConditions) continue;
                n3 = (n3 + n6) % n6;
            }
            for (n2 = 0; n2 < this.sourceEmbeddingDelay; ++n2) {
                nArray5[n4][n2] = 0;
                for (int i = 0; i < this.sourceHistoryEmbedLength - 1; ++i) {
                    int[] nArray6 = nArray5[n4];
                    int n9 = n2;
                    nArray6[n9] = nArray6[n9] + nArray[this.startObservationTime + n2 - this.delay - (this.sourceHistoryEmbedLength - 1) * this.sourceEmbeddingDelay + i * this.sourceEmbeddingDelay][n3];
                    int[] nArray7 = nArray5[n4];
                    int n10 = n2;
                    nArray7[n10] = nArray7[n10] * this.base;
                }
            }
        }
        n3 = 0;
        n2 = 0;
        for (int i = this.startObservationTime; i < n5; ++i) {
            for (int j = 0; j < n6; ++j) {
                int n11 = j - n;
                if (n11 < 0 || n11 >= n6) {
                    if (!this.periodicBoundaryConditions) continue;
                    n11 = (n11 + n6) % n6;
                }
                if (this.k > 0) {
                    int[] nArray8 = nArray2[j];
                    int n12 = n3;
                    nArray8[n12] = nArray8[n12] + nArray[i - 1][j];
                }
                int[] nArray9 = nArray5[j];
                int n13 = n2;
                nArray9[n13] = nArray9[n13] + nArray[i - this.delay][n11];
                n4 = nArray[i][j];
                int n14 = nArray2[j][n3];
                int n15 = nArray5[j][n2];
                double d = (double)this.sourceNextPastCount[n15][n4][n14] / (double)this.sourcePastCount[n15][n14] / ((double)this.nextPastCount[n4][n14] / (double)this.pastCount[n14]);
                dArray[i][j] = Math.log(d) / this.log_2;
                this.average += dArray[i][j];
                if (dArray[i][j] > this.max) {
                    this.max = dArray[i][j];
                } else if (dArray[i][j] < this.min) {
                    this.min = dArray[i][j];
                }
                if (this.k > 0) {
                    int[] nArray10 = nArray2[j];
                    int n16 = n3;
                    nArray10[n16] = nArray10[n16] - this.maxShiftedValue[nArray[i - 1 - (this.k - 1) * this.destEmbeddingDelay][j]];
                    int[] nArray11 = nArray2[j];
                    int n17 = n3;
                    nArray11[n17] = nArray11[n17] * this.base;
                }
                int[] nArray12 = nArray5[j];
                int n18 = n2;
                nArray12[n18] = nArray12[n18] - this.maxShiftedSourceValue[nArray[i - this.delay - (this.sourceHistoryEmbedLength - 1) * this.sourceEmbeddingDelay][n11]];
                int[] nArray13 = nArray5[j];
                int n19 = n2;
                nArray13[n19] = nArray13[n19] * this.base;
            }
            n3 = (n3 + 1) % this.destEmbeddingDelay;
            n2 = (n2 + 1) % this.sourceEmbeddingDelay;
        }
        this.average = this.periodicBoundaryConditions ? (this.average /= (double)((n5 - this.startObservationTime) * n6)) : (this.average /= (double)((n5 - this.startObservationTime) * (n6 - Math.abs(n))));
        return dArray;
    }

    public double[][][] computeLocalFromPreviousObservations(int[][][] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = nArray.length;
        if (n7 == 0 || nArray[0] == null) {
            return new double[n7][][];
        }
        int n8 = nArray[0].length;
        if (n8 == 0) {
            return new double[n7][n8][];
        }
        int n9 = nArray[0][0].length;
        if (n8 == 0) {
            return new double[n7][n8][n9];
        }
        if (n7 - this.startObservationTime <= 0) {
            return new double[n7][][];
        }
        double[][][] dArray = new double[n7][n8][n9];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        int[][][] nArray2 = new int[n8][n9][this.destEmbeddingDelay];
        for (int i = 0; i < n8; ++i) {
            for (n6 = 0; n6 < n9; ++n6) {
                for (n5 = 0; n5 < this.destEmbeddingDelay; ++n5) {
                    nArray2[i][n6][n5] = 0;
                    for (n4 = 0; n4 < this.k - 1; ++n4) {
                        int[] nArray3 = nArray2[i][n6];
                        int n10 = n5;
                        nArray3[n10] = nArray3[n10] + nArray[this.startObservationTime + n5 - 1 - (this.k - 1) * this.destEmbeddingDelay + n4 * this.destEmbeddingDelay][i][n6];
                        int[] nArray4 = nArray2[i][n6];
                        int n11 = n5;
                        nArray4[n11] = nArray4[n11] * this.base;
                    }
                }
            }
        }
        int[][][] nArray5 = new int[n8][n9][this.sourceEmbeddingDelay];
        for (n6 = 0; n6 < n8; ++n6) {
            for (n5 = 0; n5 < n9; ++n5) {
                int n12;
                n4 = n6 - n;
                if (n4 < 0 || n4 >= n8) {
                    if (!this.periodicBoundaryConditions) continue;
                    n4 = (n4 + n8) % n8;
                }
                if ((n12 = n5 - n2) < 0 || n12 >= n9) {
                    if (!this.periodicBoundaryConditions) continue;
                    n12 = (n12 + n9) % n9;
                }
                for (int i = 0; i < this.sourceEmbeddingDelay; ++i) {
                    nArray5[n6][n5][i] = 0;
                    for (n3 = 0; n3 < this.sourceHistoryEmbedLength - 1; ++n3) {
                        int[] nArray6 = nArray5[n6][n5];
                        int n13 = i;
                        nArray6[n13] = nArray6[n13] + nArray[this.startObservationTime + i - this.delay - (this.sourceHistoryEmbedLength - 1) * this.sourceEmbeddingDelay + n3 * this.sourceEmbeddingDelay][n4][n12];
                        int[] nArray7 = nArray5[n6][n5];
                        int n14 = i;
                        nArray7[n14] = nArray7[n14] * this.base;
                    }
                }
            }
        }
        n5 = 0;
        n4 = 0;
        for (n3 = this.startObservationTime; n3 < n7; ++n3) {
            for (int i = 0; i < n8; ++i) {
                for (int j = 0; j < n9; ++j) {
                    int n15;
                    int n16 = i - n;
                    if (n16 < 0 || n16 >= n8) {
                        if (!this.periodicBoundaryConditions) continue;
                        n16 = (n16 + n8) % n8;
                    }
                    if ((n15 = j - n2) < 0 || n15 >= n9) {
                        if (!this.periodicBoundaryConditions) continue;
                        n15 = (n15 + n9) % n9;
                    }
                    if (this.k > 0) {
                        int[] nArray8 = nArray2[i][j];
                        int n17 = n5;
                        nArray8[n17] = nArray8[n17] + nArray[n3 - 1][i][j];
                    }
                    int[] nArray9 = nArray5[i][j];
                    int n18 = n4;
                    nArray9[n18] = nArray9[n18] + nArray[n3 - this.delay][n16][n15];
                    n6 = nArray[n3][i][j];
                    int n19 = nArray2[i][j][n5];
                    int n20 = nArray5[i][j][n4];
                    double d = (double)this.sourceNextPastCount[n20][n6][n19] / (double)this.sourcePastCount[n20][n19] / ((double)this.nextPastCount[n6][n19] / (double)this.pastCount[n19]);
                    dArray[n3][i][j] = Math.log(d) / this.log_2;
                    this.average += dArray[n3][i][j];
                    if (dArray[n3][i][j] > this.max) {
                        this.max = dArray[n3][i][j];
                    } else if (dArray[n3][i][j] < this.min) {
                        this.min = dArray[n3][i][j];
                    }
                    if (this.k > 0) {
                        int[] nArray10 = nArray2[i][j];
                        int n21 = n5;
                        nArray10[n21] = nArray10[n21] - this.maxShiftedValue[nArray[n3 - 1 - (this.k - 1) * this.destEmbeddingDelay][i][j]];
                        int[] nArray11 = nArray2[i][j];
                        int n22 = n5;
                        nArray11[n22] = nArray11[n22] * this.base;
                    }
                    int[] nArray12 = nArray5[i][j];
                    int n23 = n4;
                    nArray12[n23] = nArray12[n23] - this.maxShiftedSourceValue[nArray[n3 - this.delay - (this.sourceHistoryEmbedLength - 1) * this.sourceEmbeddingDelay][n16][n15]];
                    int[] nArray13 = nArray5[i][j];
                    int n24 = n4;
                    nArray13[n24] = nArray13[n24] * this.base;
                }
            }
            n5 = (n5 + 1) % this.destEmbeddingDelay;
            n4 = (n4 + 1) % this.sourceEmbeddingDelay;
        }
        this.average = this.periodicBoundaryConditions ? (this.average /= (double)((n7 - this.startObservationTime) * n8 * n9)) : (this.average /= (double)((n7 - this.startObservationTime) * (n8 - Math.abs(n)) * (n9 - Math.abs(n2))));
        return dArray;
    }

    public double[] computeLocalFromPreviousObservations(int[][] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5 = nArray.length;
        double[] dArray = new double[n5];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        if (n5 - this.startObservationTime <= 0) {
            return dArray;
        }
        int[] nArray2 = new int[this.destEmbeddingDelay];
        for (int i = 0; i < this.destEmbeddingDelay; ++i) {
            nArray2[i] = 0;
            for (n4 = 0; n4 < this.k - 1; ++n4) {
                int n6 = i;
                nArray2[n6] = nArray2[n6] + nArray[this.startObservationTime + i - 1 - (this.k - 1) * this.destEmbeddingDelay + n4 * this.destEmbeddingDelay][n2];
                int n7 = i;
                nArray2[n7] = nArray2[n7] * this.base;
            }
        }
        int[] nArray3 = new int[this.sourceEmbeddingDelay];
        for (n4 = 0; n4 < this.sourceEmbeddingDelay; ++n4) {
            nArray3[n4] = 0;
            for (n3 = 0; n3 < this.sourceHistoryEmbedLength - 1; ++n3) {
                int n8 = n4;
                nArray3[n8] = nArray3[n8] + nArray[this.startObservationTime + n4 - this.delay - (this.sourceHistoryEmbedLength - 1) * this.sourceEmbeddingDelay + n3 * this.sourceEmbeddingDelay][n];
                int n9 = n4;
                nArray3[n9] = nArray3[n9] * this.base;
            }
        }
        n3 = 0;
        int n10 = 0;
        for (int i = this.startObservationTime; i < n5; ++i) {
            if (this.k > 0) {
                int n11 = n3;
                nArray2[n11] = nArray2[n11] + nArray[i - 1][n2];
            }
            int n12 = n10;
            nArray3[n12] = nArray3[n12] + nArray[i - this.delay][n];
            n4 = nArray[i][n2];
            int n13 = nArray2[n3];
            int n14 = nArray3[n10];
            double d = (double)this.sourceNextPastCount[n14][n4][n13] / (double)this.sourcePastCount[n14][n13] / ((double)this.nextPastCount[n4][n13] / (double)this.pastCount[n13]);
            dArray[i] = Math.log(d) / this.log_2;
            this.average += dArray[i];
            if (dArray[i] > this.max) {
                this.max = dArray[i];
            } else if (dArray[i] < this.min) {
                this.min = dArray[i];
            }
            if (this.k > 0) {
                int n15 = n3;
                nArray2[n15] = nArray2[n15] - this.maxShiftedValue[nArray[i - 1 - (this.k - 1) * this.destEmbeddingDelay][n2]];
                int n16 = n3;
                nArray2[n16] = nArray2[n16] * this.base;
            }
            int n17 = n10;
            nArray3[n17] = nArray3[n17] - this.maxShiftedSourceValue[nArray[i - this.delay - (this.sourceHistoryEmbedLength - 1) * this.sourceEmbeddingDelay][n]];
            int n18 = n10;
            nArray3[n18] = nArray3[n18] * this.base;
            n3 = (n3 + 1) % this.destEmbeddingDelay;
            n10 = (n10 + 1) % this.sourceEmbeddingDelay;
        }
        this.average /= (double)(n5 - this.startObservationTime);
        return dArray;
    }

    public double[] computeLocalFromPreviousObservations(int[][][] nArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = nArray.length;
        double[] dArray = new double[n7];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        if (n7 - this.startObservationTime <= 0) {
            return dArray;
        }
        int[] nArray2 = new int[this.destEmbeddingDelay];
        for (int i = 0; i < this.destEmbeddingDelay; ++i) {
            nArray2[i] = 0;
            for (n6 = 0; n6 < this.k - 1; ++n6) {
                int n8 = i;
                nArray2[n8] = nArray2[n8] + nArray[this.startObservationTime + i - 1 - (this.k - 1) * this.destEmbeddingDelay + n6 * this.destEmbeddingDelay][n3][n4];
                int n9 = i;
                nArray2[n9] = nArray2[n9] * this.base;
            }
        }
        int[] nArray3 = new int[this.sourceEmbeddingDelay];
        for (n6 = 0; n6 < this.sourceEmbeddingDelay; ++n6) {
            nArray3[n6] = 0;
            for (n5 = 0; n5 < this.sourceHistoryEmbedLength - 1; ++n5) {
                int n10 = n6;
                nArray3[n10] = nArray3[n10] + nArray[this.startObservationTime + n6 - this.delay - (this.sourceHistoryEmbedLength - 1) * this.sourceEmbeddingDelay + n5 * this.sourceEmbeddingDelay][n][n2];
                int n11 = n6;
                nArray3[n11] = nArray3[n11] * this.base;
            }
        }
        n5 = 0;
        int n12 = 0;
        for (int i = this.startObservationTime; i < n7; ++i) {
            if (this.k > 0) {
                int n13 = n5;
                nArray2[n13] = nArray2[n13] + nArray[i - 1][n3][n4];
            }
            int n14 = n12;
            nArray3[n14] = nArray3[n14] + nArray[i - this.delay][n][n2];
            n6 = nArray[i][n3][n4];
            int n15 = nArray2[n5];
            int n16 = nArray3[n12];
            double d = (double)this.sourceNextPastCount[n16][n6][n15] / (double)this.sourcePastCount[n16][n15] / ((double)this.nextPastCount[n6][n15] / (double)this.pastCount[n15]);
            dArray[i] = Math.log(d) / this.log_2;
            this.average += dArray[i];
            if (dArray[i] > this.max) {
                this.max = dArray[i];
            } else if (dArray[i] < this.min) {
                this.min = dArray[i];
            }
            if (this.k > 0) {
                int n17 = n5;
                nArray2[n17] = nArray2[n17] - this.maxShiftedValue[nArray[i - 1 - (this.k - 1) * this.destEmbeddingDelay][n3][n4]];
                int n18 = n5;
                nArray2[n18] = nArray2[n18] * this.base;
            }
            int n19 = n12;
            nArray3[n19] = nArray3[n19] - this.maxShiftedSourceValue[nArray[i - this.delay - (this.sourceHistoryEmbedLength - 1) * this.sourceEmbeddingDelay][n][n2]];
            int n20 = n12;
            nArray3[n20] = nArray3[n20] * this.base;
            n5 = (n5 + 1) % this.destEmbeddingDelay;
            n12 = (n12 + 1) % this.sourceEmbeddingDelay;
        }
        this.average /= (double)(n7 - this.startObservationTime);
        return dArray;
    }

    public double[] computeLocal(int[] nArray, int[] nArray2) {
        this.initialise();
        this.addObservations(nArray, nArray2);
        return this.computeLocalFromPreviousObservations(nArray, nArray2);
    }

    public double[][] computeLocal(int[][] nArray, int n) {
        this.initialise();
        this.addObservations(nArray, n);
        return this.computeLocalFromPreviousObservations(nArray, n);
    }

    public double[][][] computeLocal(int[][][] nArray, int n, int n2) {
        this.initialise();
        this.addObservations(nArray, n, n2);
        return this.computeLocalFromPreviousObservations(nArray, n, n2);
    }

    public double computeAverageLocal(int[][] nArray, int n) {
        this.initialise();
        this.addObservations(nArray, n);
        return this.computeAverageLocalOfObservations();
    }

    public double computeAverageLocal(int[][][] nArray, int n, int n2) {
        this.initialise();
        this.addObservations(nArray, n, n2);
        return this.computeAverageLocalOfObservations();
    }

    public double[] computeLocal(int[][] nArray, int n, int n2) {
        this.initialise();
        this.addObservations(nArray, n, n2);
        return this.computeLocalFromPreviousObservations(nArray, n, n2);
    }

    public double[] computeLocal(int[][][] nArray, int n, int n2, int n3, int n4) {
        this.initialise();
        this.addObservations(nArray, n, n2, n3, n4);
        return this.computeLocalFromPreviousObservations(nArray, n, n2, n3, n4);
    }

    public double computeAverageLocal(int[][] nArray, int n, int n2) {
        this.initialise();
        this.addObservations(nArray, n, n2);
        return this.computeAverageLocalOfObservations();
    }

    public double computeAverageLocal(int[][][] nArray, int n, int n2, int n3, int n4) {
        this.initialise();
        this.addObservations(nArray, n, n2, n3, n4);
        return this.computeAverageLocalOfObservations();
    }

    public boolean isPeriodicBoundaryConditions() {
        return this.periodicBoundaryConditions;
    }

    public void setPeriodicBoundaryConditions(boolean bl) {
        this.periodicBoundaryConditions = bl;
    }
}

