/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.utils;

import infodynamics.utils.MatrixUtils;
import infodynamics.utils.MeasurementDistribution;

public class EmpiricalMeasurementDistribution
extends MeasurementDistribution {
    public double[] distribution;
    protected boolean computedMean = false;
    protected double meanOfDist;
    protected double stdOfDist;

    public EmpiricalMeasurementDistribution(int n) {
        this.distribution = new double[n];
    }

    public EmpiricalMeasurementDistribution(double[] dArray, double d) {
        super(d, 0.0);
        this.distribution = dArray;
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] >= d)) continue;
            ++n;
        }
        this.pValue = (double)n / (double)dArray.length;
    }

    public double getTSscore() {
        if (!this.computedMean) {
            this.meanOfDist = MatrixUtils.mean(this.distribution);
            this.stdOfDist = MatrixUtils.stdDev(this.distribution, this.meanOfDist);
            this.computedMean = true;
        }
        double d = (this.actualValue - this.meanOfDist) / this.stdOfDist;
        return d;
    }

    public double getMeanOfDistribution() {
        if (!this.computedMean) {
            this.meanOfDist = MatrixUtils.mean(this.distribution);
            this.stdOfDist = MatrixUtils.stdDev(this.distribution, this.meanOfDist);
            this.computedMean = true;
        }
        return this.meanOfDist;
    }

    public double getStdOfDistribution() {
        if (!this.computedMean) {
            this.meanOfDist = MatrixUtils.mean(this.distribution);
            this.stdOfDist = MatrixUtils.stdDev(this.distribution, this.meanOfDist);
            this.computedMean = true;
        }
        return this.stdOfDist;
    }
}

