# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: temporal/api/history/v1/message.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import datetime, timedelta
from typing import Dict, List

import betterproto

from temporal.api.common import v1 as v1common
from temporal.api.enums import v1 as v1enums
from temporal.api.failure import v1 as v1failure
from temporal.api.taskqueue import v1 as v1taskqueue
from temporal.api.workflow import v1 as v1workflow


@dataclass
class WorkflowExecutionStartedEventAttributes(betterproto.Message):
    workflow_type: v1common.WorkflowType = betterproto.message_field(1)
    parent_workflow_namespace: str = betterproto.string_field(2)
    parent_workflow_execution: v1common.WorkflowExecution = betterproto.message_field(3)
    parent_initiated_event_id: int = betterproto.int64_field(4)
    task_queue: v1taskqueue.TaskQueue = betterproto.message_field(5)
    input: v1common.Payloads = betterproto.message_field(6)
    # Total workflow execution timeout including retries and continue as new.
    workflow_execution_timeout: timedelta = betterproto.message_field(7)
    # Timeout of a single workflow run.
    workflow_run_timeout: timedelta = betterproto.message_field(8)
    # Timeout of a single workflow task.
    workflow_task_timeout: timedelta = betterproto.message_field(9)
    continued_execution_run_id: str = betterproto.string_field(10)
    initiator: v1enums.ContinueAsNewInitiator = betterproto.enum_field(11)
    continued_failure: v1failure.Failure = betterproto.message_field(12)
    last_completion_result: v1common.Payloads = betterproto.message_field(13)
    # This is the runId when the WorkflowExecutionStarted event is written.
    original_execution_run_id: str = betterproto.string_field(14)
    identity: str = betterproto.string_field(15)
    # This is the very first runId along the chain of ContinueAsNew and Reset.
    first_execution_run_id: str = betterproto.string_field(16)
    retry_policy: v1common.RetryPolicy = betterproto.message_field(17)
    attempt: int = betterproto.int32_field(18)
    # The absolute time at which workflow is timed out. This time is passed
    # without change to the next run/retry of a workflow.
    workflow_execution_expiration_time: datetime = betterproto.message_field(19)
    cron_schedule: str = betterproto.string_field(20)
    first_workflow_task_backoff: timedelta = betterproto.message_field(21)
    memo: v1common.Memo = betterproto.message_field(22)
    search_attributes: v1common.SearchAttributes = betterproto.message_field(23)
    prev_auto_reset_points: v1workflow.ResetPoints = betterproto.message_field(24)
    header: v1common.Header = betterproto.message_field(25)


@dataclass
class WorkflowExecutionCompletedEventAttributes(betterproto.Message):
    result: v1common.Payloads = betterproto.message_field(1)
    workflow_task_completed_event_id: int = betterproto.int64_field(2)


@dataclass
class WorkflowExecutionFailedEventAttributes(betterproto.Message):
    failure: v1failure.Failure = betterproto.message_field(1)
    retry_state: v1enums.RetryState = betterproto.enum_field(2)
    workflow_task_completed_event_id: int = betterproto.int64_field(3)


@dataclass
class WorkflowExecutionTimedOutEventAttributes(betterproto.Message):
    retry_state: v1enums.RetryState = betterproto.enum_field(1)


@dataclass
class WorkflowExecutionContinuedAsNewEventAttributes(betterproto.Message):
    new_execution_run_id: str = betterproto.string_field(1)
    workflow_type: v1common.WorkflowType = betterproto.message_field(2)
    task_queue: v1taskqueue.TaskQueue = betterproto.message_field(3)
    input: v1common.Payloads = betterproto.message_field(4)
    # workflow_execution_timeout is omitted as it shouldn'be overridden from
    # within a workflow. Timeout of a single workflow run.
    workflow_run_timeout: timedelta = betterproto.message_field(5)
    # Timeout of a single workflow task.
    workflow_task_timeout: timedelta = betterproto.message_field(6)
    workflow_task_completed_event_id: int = betterproto.int64_field(7)
    backoff_start_interval: timedelta = betterproto.message_field(8)
    initiator: v1enums.ContinueAsNewInitiator = betterproto.enum_field(9)
    failure: v1failure.Failure = betterproto.message_field(10)
    last_completion_result: v1common.Payloads = betterproto.message_field(11)
    header: v1common.Header = betterproto.message_field(12)
    memo: v1common.Memo = betterproto.message_field(13)
    search_attributes: v1common.SearchAttributes = betterproto.message_field(14)


@dataclass
class WorkflowTaskScheduledEventAttributes(betterproto.Message):
    task_queue: v1taskqueue.TaskQueue = betterproto.message_field(1)
    # (-- api-linter: core::0140::prepositions=disabled     aip.dev/not-
    # precedent: "to" is used to indicate interval. --)
    start_to_close_timeout: timedelta = betterproto.message_field(2)
    attempt: int = betterproto.int32_field(3)


@dataclass
class WorkflowTaskStartedEventAttributes(betterproto.Message):
    scheduled_event_id: int = betterproto.int64_field(1)
    identity: str = betterproto.string_field(2)
    request_id: str = betterproto.string_field(3)


@dataclass
class WorkflowTaskCompletedEventAttributes(betterproto.Message):
    scheduled_event_id: int = betterproto.int64_field(1)
    started_event_id: int = betterproto.int64_field(2)
    identity: str = betterproto.string_field(3)
    binary_checksum: str = betterproto.string_field(4)


@dataclass
class WorkflowTaskTimedOutEventAttributes(betterproto.Message):
    scheduled_event_id: int = betterproto.int64_field(1)
    started_event_id: int = betterproto.int64_field(2)
    timeout_type: v1enums.TimeoutType = betterproto.enum_field(3)


@dataclass
class WorkflowTaskFailedEventAttributes(betterproto.Message):
    scheduled_event_id: int = betterproto.int64_field(1)
    started_event_id: int = betterproto.int64_field(2)
    cause: v1enums.WorkflowTaskFailedCause = betterproto.enum_field(3)
    failure: v1failure.Failure = betterproto.message_field(4)
    identity: str = betterproto.string_field(5)
    # For reset workflow.
    base_run_id: str = betterproto.string_field(6)
    new_run_id: str = betterproto.string_field(7)
    fork_event_version: int = betterproto.int64_field(8)
    binary_checksum: str = betterproto.string_field(9)


@dataclass
class ActivityTaskScheduledEventAttributes(betterproto.Message):
    activity_id: str = betterproto.string_field(1)
    activity_type: v1common.ActivityType = betterproto.message_field(2)
    namespace: str = betterproto.string_field(3)
    task_queue: v1taskqueue.TaskQueue = betterproto.message_field(4)
    header: v1common.Header = betterproto.message_field(5)
    input: v1common.Payloads = betterproto.message_field(6)
    # (-- api-linter: core::0140::prepositions=disabled     aip.dev/not-
    # precedent: "to" is used to indicate interval. --) Indicates how long the
    # caller is willing to wait for an activity completion. Limits for how long
    # retries are happening. Either this or start_to_close_timeout_seconds must
    # be specified.
    schedule_to_close_timeout: timedelta = betterproto.message_field(7)
    # (-- api-linter: core::0140::prepositions=disabled     aip.dev/not-
    # precedent: "to" is used to indicate interval. --) Limits time an activity
    # task can stay in a task queue before a worker picks it up. This timeout is
    # always non retryable as all a retry would achieve is to put it back into
    # the same queue. Defaults to schedule_to_close_timeout_seconds or workflow
    # execution timeout if not specified.
    schedule_to_start_timeout: timedelta = betterproto.message_field(8)
    # (-- api-linter: core::0140::prepositions=disabled     aip.dev/not-
    # precedent: "to" is used to indicate interval. --) Maximum time an activity
    # is allowed to execute after a pick up by a worker. This timeout is always
    # retryable. Either this or schedule_to_close_timeout_seconds must be
    # specified.
    start_to_close_timeout: timedelta = betterproto.message_field(9)
    # Maximum time between successful worker heartbeats.
    heartbeat_timeout: timedelta = betterproto.message_field(10)
    workflow_task_completed_event_id: int = betterproto.int64_field(11)
    # Activities are provided by a default retry policy controlled through the
    # service dynamic configuration. Retries are happening up to
    # schedule_to_close_timeout. To disable retries set
    # retry_policy.maximum_attempts to 1.
    retry_policy: v1common.RetryPolicy = betterproto.message_field(12)


@dataclass
class ActivityTaskStartedEventAttributes(betterproto.Message):
    scheduled_event_id: int = betterproto.int64_field(1)
    identity: str = betterproto.string_field(2)
    request_id: str = betterproto.string_field(3)
    attempt: int = betterproto.int32_field(4)
    last_failure: v1failure.Failure = betterproto.message_field(5)


@dataclass
class ActivityTaskCompletedEventAttributes(betterproto.Message):
    result: v1common.Payloads = betterproto.message_field(1)
    scheduled_event_id: int = betterproto.int64_field(2)
    started_event_id: int = betterproto.int64_field(3)
    identity: str = betterproto.string_field(4)


@dataclass
class ActivityTaskFailedEventAttributes(betterproto.Message):
    failure: v1failure.Failure = betterproto.message_field(1)
    scheduled_event_id: int = betterproto.int64_field(2)
    started_event_id: int = betterproto.int64_field(3)
    identity: str = betterproto.string_field(4)
    retry_state: v1enums.RetryState = betterproto.enum_field(5)


@dataclass
class ActivityTaskTimedOutEventAttributes(betterproto.Message):
    # For retry activity, it may have a failure before timeout. It is stored as
    # `cause` in `failure`.
    failure: v1failure.Failure = betterproto.message_field(1)
    scheduled_event_id: int = betterproto.int64_field(2)
    started_event_id: int = betterproto.int64_field(3)
    retry_state: v1enums.RetryState = betterproto.enum_field(4)


@dataclass
class ActivityTaskCancelRequestedEventAttributes(betterproto.Message):
    scheduled_event_id: int = betterproto.int64_field(1)
    workflow_task_completed_event_id: int = betterproto.int64_field(2)


@dataclass
class ActivityTaskCanceledEventAttributes(betterproto.Message):
    details: v1common.Payloads = betterproto.message_field(1)
    latest_cancel_requested_event_id: int = betterproto.int64_field(2)
    scheduled_event_id: int = betterproto.int64_field(3)
    started_event_id: int = betterproto.int64_field(4)
    identity: str = betterproto.string_field(5)


@dataclass
class TimerStartedEventAttributes(betterproto.Message):
    timer_id: str = betterproto.string_field(1)
    # (-- api-linter: core::0140::prepositions=disabled     aip.dev/not-
    # precedent: "to" is used to indicate interval. --)
    start_to_fire_timeout: timedelta = betterproto.message_field(2)
    workflow_task_completed_event_id: int = betterproto.int64_field(3)


@dataclass
class TimerFiredEventAttributes(betterproto.Message):
    timer_id: str = betterproto.string_field(1)
    started_event_id: int = betterproto.int64_field(2)


@dataclass
class TimerCanceledEventAttributes(betterproto.Message):
    timer_id: str = betterproto.string_field(1)
    started_event_id: int = betterproto.int64_field(2)
    workflow_task_completed_event_id: int = betterproto.int64_field(3)
    identity: str = betterproto.string_field(4)


@dataclass
class WorkflowExecutionCancelRequestedEventAttributes(betterproto.Message):
    cause: str = betterproto.string_field(1)
    external_initiated_event_id: int = betterproto.int64_field(2)
    external_workflow_execution: v1common.WorkflowExecution = betterproto.message_field(
        3
    )
    identity: str = betterproto.string_field(4)


@dataclass
class WorkflowExecutionCanceledEventAttributes(betterproto.Message):
    workflow_task_completed_event_id: int = betterproto.int64_field(1)
    details: v1common.Payloads = betterproto.message_field(2)


@dataclass
class MarkerRecordedEventAttributes(betterproto.Message):
    marker_name: str = betterproto.string_field(1)
    details: Dict[str, v1common.Payloads] = betterproto.map_field(
        2, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    workflow_task_completed_event_id: int = betterproto.int64_field(3)
    header: v1common.Header = betterproto.message_field(4)
    failure: v1failure.Failure = betterproto.message_field(5)


@dataclass
class WorkflowExecutionSignaledEventAttributes(betterproto.Message):
    signal_name: str = betterproto.string_field(1)
    input: v1common.Payloads = betterproto.message_field(2)
    identity: str = betterproto.string_field(3)


@dataclass
class WorkflowExecutionTerminatedEventAttributes(betterproto.Message):
    reason: str = betterproto.string_field(1)
    details: v1common.Payloads = betterproto.message_field(2)
    identity: str = betterproto.string_field(3)


@dataclass
class RequestCancelExternalWorkflowExecutionInitiatedEventAttributes(
    betterproto.Message
):
    workflow_task_completed_event_id: int = betterproto.int64_field(1)
    namespace: str = betterproto.string_field(2)
    workflow_execution: v1common.WorkflowExecution = betterproto.message_field(3)
    control: str = betterproto.string_field(4)
    child_workflow_only: bool = betterproto.bool_field(5)


@dataclass
class RequestCancelExternalWorkflowExecutionFailedEventAttributes(betterproto.Message):
    cause: v1enums.CancelExternalWorkflowExecutionFailedCause = betterproto.enum_field(
        1
    )
    workflow_task_completed_event_id: int = betterproto.int64_field(2)
    namespace: str = betterproto.string_field(3)
    workflow_execution: v1common.WorkflowExecution = betterproto.message_field(4)
    initiated_event_id: int = betterproto.int64_field(5)
    control: str = betterproto.string_field(6)


@dataclass
class ExternalWorkflowExecutionCancelRequestedEventAttributes(betterproto.Message):
    initiated_event_id: int = betterproto.int64_field(1)
    namespace: str = betterproto.string_field(2)
    workflow_execution: v1common.WorkflowExecution = betterproto.message_field(3)


@dataclass
class SignalExternalWorkflowExecutionInitiatedEventAttributes(betterproto.Message):
    workflow_task_completed_event_id: int = betterproto.int64_field(1)
    namespace: str = betterproto.string_field(2)
    workflow_execution: v1common.WorkflowExecution = betterproto.message_field(3)
    signal_name: str = betterproto.string_field(4)
    input: v1common.Payloads = betterproto.message_field(5)
    control: str = betterproto.string_field(6)
    child_workflow_only: bool = betterproto.bool_field(7)


@dataclass
class SignalExternalWorkflowExecutionFailedEventAttributes(betterproto.Message):
    cause: v1enums.SignalExternalWorkflowExecutionFailedCause = betterproto.enum_field(
        1
    )
    workflow_task_completed_event_id: int = betterproto.int64_field(2)
    namespace: str = betterproto.string_field(3)
    workflow_execution: v1common.WorkflowExecution = betterproto.message_field(4)
    initiated_event_id: int = betterproto.int64_field(5)
    control: str = betterproto.string_field(6)


@dataclass
class ExternalWorkflowExecutionSignaledEventAttributes(betterproto.Message):
    initiated_event_id: int = betterproto.int64_field(1)
    namespace: str = betterproto.string_field(2)
    workflow_execution: v1common.WorkflowExecution = betterproto.message_field(3)
    control: str = betterproto.string_field(4)


@dataclass
class UpsertWorkflowSearchAttributesEventAttributes(betterproto.Message):
    workflow_task_completed_event_id: int = betterproto.int64_field(1)
    search_attributes: v1common.SearchAttributes = betterproto.message_field(2)


@dataclass
class StartChildWorkflowExecutionInitiatedEventAttributes(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    workflow_id: str = betterproto.string_field(2)
    workflow_type: v1common.WorkflowType = betterproto.message_field(3)
    task_queue: v1taskqueue.TaskQueue = betterproto.message_field(4)
    input: v1common.Payloads = betterproto.message_field(5)
    # Total workflow execution timeout including retries and continue as new.
    workflow_execution_timeout: timedelta = betterproto.message_field(6)
    # Timeout of a single workflow run.
    workflow_run_timeout: timedelta = betterproto.message_field(7)
    # Timeout of a single workflow task.
    workflow_task_timeout: timedelta = betterproto.message_field(8)
    # Default: PARENT_CLOSE_POLICY_TERMINATE.
    parent_close_policy: v1enums.ParentClosePolicy = betterproto.enum_field(9)
    control: str = betterproto.string_field(10)
    workflow_task_completed_event_id: int = betterproto.int64_field(11)
    # Default: WORKFLOW_ID_REUSE_POLICY_ALLOW_DUPLICATE.
    workflow_id_reuse_policy: v1enums.WorkflowIdReusePolicy = betterproto.enum_field(12)
    retry_policy: v1common.RetryPolicy = betterproto.message_field(13)
    cron_schedule: str = betterproto.string_field(14)
    header: v1common.Header = betterproto.message_field(15)
    memo: v1common.Memo = betterproto.message_field(16)
    search_attributes: v1common.SearchAttributes = betterproto.message_field(17)


@dataclass
class StartChildWorkflowExecutionFailedEventAttributes(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    workflow_id: str = betterproto.string_field(2)
    workflow_type: v1common.WorkflowType = betterproto.message_field(3)
    cause: v1enums.StartChildWorkflowExecutionFailedCause = betterproto.enum_field(4)
    control: str = betterproto.string_field(5)
    initiated_event_id: int = betterproto.int64_field(6)
    workflow_task_completed_event_id: int = betterproto.int64_field(7)


@dataclass
class ChildWorkflowExecutionStartedEventAttributes(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    initiated_event_id: int = betterproto.int64_field(2)
    workflow_execution: v1common.WorkflowExecution = betterproto.message_field(3)
    workflow_type: v1common.WorkflowType = betterproto.message_field(4)
    header: v1common.Header = betterproto.message_field(5)


@dataclass
class ChildWorkflowExecutionCompletedEventAttributes(betterproto.Message):
    result: v1common.Payloads = betterproto.message_field(1)
    namespace: str = betterproto.string_field(2)
    workflow_execution: v1common.WorkflowExecution = betterproto.message_field(3)
    workflow_type: v1common.WorkflowType = betterproto.message_field(4)
    initiated_event_id: int = betterproto.int64_field(5)
    started_event_id: int = betterproto.int64_field(6)


@dataclass
class ChildWorkflowExecutionFailedEventAttributes(betterproto.Message):
    failure: v1failure.Failure = betterproto.message_field(1)
    namespace: str = betterproto.string_field(2)
    workflow_execution: v1common.WorkflowExecution = betterproto.message_field(3)
    workflow_type: v1common.WorkflowType = betterproto.message_field(4)
    initiated_event_id: int = betterproto.int64_field(5)
    started_event_id: int = betterproto.int64_field(6)
    retry_state: v1enums.RetryState = betterproto.enum_field(7)


@dataclass
class ChildWorkflowExecutionCanceledEventAttributes(betterproto.Message):
    details: v1common.Payloads = betterproto.message_field(1)
    namespace: str = betterproto.string_field(2)
    workflow_execution: v1common.WorkflowExecution = betterproto.message_field(3)
    workflow_type: v1common.WorkflowType = betterproto.message_field(4)
    initiated_event_id: int = betterproto.int64_field(5)
    started_event_id: int = betterproto.int64_field(6)


@dataclass
class ChildWorkflowExecutionTimedOutEventAttributes(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    workflow_execution: v1common.WorkflowExecution = betterproto.message_field(2)
    workflow_type: v1common.WorkflowType = betterproto.message_field(3)
    initiated_event_id: int = betterproto.int64_field(4)
    started_event_id: int = betterproto.int64_field(5)
    retry_state: v1enums.RetryState = betterproto.enum_field(6)


@dataclass
class ChildWorkflowExecutionTerminatedEventAttributes(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    workflow_execution: v1common.WorkflowExecution = betterproto.message_field(2)
    workflow_type: v1common.WorkflowType = betterproto.message_field(3)
    initiated_event_id: int = betterproto.int64_field(4)
    started_event_id: int = betterproto.int64_field(5)


@dataclass
class HistoryEvent(betterproto.Message):
    event_id: int = betterproto.int64_field(1)
    event_time: datetime = betterproto.message_field(2)
    event_type: v1enums.EventType = betterproto.enum_field(3)
    version: int = betterproto.int64_field(4)
    task_id: int = betterproto.int64_field(5)
    workflow_execution_started_event_attributes: "WorkflowExecutionStartedEventAttributes" = betterproto.message_field(
        6, group="attributes"
    )
    workflow_execution_completed_event_attributes: "WorkflowExecutionCompletedEventAttributes" = betterproto.message_field(
        7, group="attributes"
    )
    workflow_execution_failed_event_attributes: "WorkflowExecutionFailedEventAttributes" = betterproto.message_field(
        8, group="attributes"
    )
    workflow_execution_timed_out_event_attributes: "WorkflowExecutionTimedOutEventAttributes" = betterproto.message_field(
        9, group="attributes"
    )
    workflow_task_scheduled_event_attributes: "WorkflowTaskScheduledEventAttributes" = betterproto.message_field(
        10, group="attributes"
    )
    workflow_task_started_event_attributes: "WorkflowTaskStartedEventAttributes" = betterproto.message_field(
        11, group="attributes"
    )
    workflow_task_completed_event_attributes: "WorkflowTaskCompletedEventAttributes" = betterproto.message_field(
        12, group="attributes"
    )
    workflow_task_timed_out_event_attributes: "WorkflowTaskTimedOutEventAttributes" = betterproto.message_field(
        13, group="attributes"
    )
    workflow_task_failed_event_attributes: "WorkflowTaskFailedEventAttributes" = betterproto.message_field(
        14, group="attributes"
    )
    activity_task_scheduled_event_attributes: "ActivityTaskScheduledEventAttributes" = betterproto.message_field(
        15, group="attributes"
    )
    activity_task_started_event_attributes: "ActivityTaskStartedEventAttributes" = betterproto.message_field(
        16, group="attributes"
    )
    activity_task_completed_event_attributes: "ActivityTaskCompletedEventAttributes" = betterproto.message_field(
        17, group="attributes"
    )
    activity_task_failed_event_attributes: "ActivityTaskFailedEventAttributes" = betterproto.message_field(
        18, group="attributes"
    )
    activity_task_timed_out_event_attributes: "ActivityTaskTimedOutEventAttributes" = betterproto.message_field(
        19, group="attributes"
    )
    timer_started_event_attributes: "TimerStartedEventAttributes" = betterproto.message_field(
        20, group="attributes"
    )
    timer_fired_event_attributes: "TimerFiredEventAttributes" = betterproto.message_field(
        21, group="attributes"
    )
    activity_task_cancel_requested_event_attributes: "ActivityTaskCancelRequestedEventAttributes" = betterproto.message_field(
        22, group="attributes"
    )
    activity_task_canceled_event_attributes: "ActivityTaskCanceledEventAttributes" = betterproto.message_field(
        23, group="attributes"
    )
    timer_canceled_event_attributes: "TimerCanceledEventAttributes" = betterproto.message_field(
        24, group="attributes"
    )
    marker_recorded_event_attributes: "MarkerRecordedEventAttributes" = betterproto.message_field(
        25, group="attributes"
    )
    workflow_execution_signaled_event_attributes: "WorkflowExecutionSignaledEventAttributes" = betterproto.message_field(
        26, group="attributes"
    )
    workflow_execution_terminated_event_attributes: "WorkflowExecutionTerminatedEventAttributes" = betterproto.message_field(
        27, group="attributes"
    )
    workflow_execution_cancel_requested_event_attributes: "WorkflowExecutionCancelRequestedEventAttributes" = betterproto.message_field(
        28, group="attributes"
    )
    workflow_execution_canceled_event_attributes: "WorkflowExecutionCanceledEventAttributes" = betterproto.message_field(
        29, group="attributes"
    )
    request_cancel_external_workflow_execution_initiated_event_attributes: "RequestCancelExternalWorkflowExecutionInitiatedEventAttributes" = betterproto.message_field(
        30, group="attributes"
    )
    request_cancel_external_workflow_execution_failed_event_attributes: "RequestCancelExternalWorkflowExecutionFailedEventAttributes" = betterproto.message_field(
        31, group="attributes"
    )
    external_workflow_execution_cancel_requested_event_attributes: "ExternalWorkflowExecutionCancelRequestedEventAttributes" = betterproto.message_field(
        32, group="attributes"
    )
    workflow_execution_continued_as_new_event_attributes: "WorkflowExecutionContinuedAsNewEventAttributes" = betterproto.message_field(
        33, group="attributes"
    )
    start_child_workflow_execution_initiated_event_attributes: "StartChildWorkflowExecutionInitiatedEventAttributes" = betterproto.message_field(
        34, group="attributes"
    )
    start_child_workflow_execution_failed_event_attributes: "StartChildWorkflowExecutionFailedEventAttributes" = betterproto.message_field(
        35, group="attributes"
    )
    child_workflow_execution_started_event_attributes: "ChildWorkflowExecutionStartedEventAttributes" = betterproto.message_field(
        36, group="attributes"
    )
    child_workflow_execution_completed_event_attributes: "ChildWorkflowExecutionCompletedEventAttributes" = betterproto.message_field(
        37, group="attributes"
    )
    child_workflow_execution_failed_event_attributes: "ChildWorkflowExecutionFailedEventAttributes" = betterproto.message_field(
        38, group="attributes"
    )
    child_workflow_execution_canceled_event_attributes: "ChildWorkflowExecutionCanceledEventAttributes" = betterproto.message_field(
        39, group="attributes"
    )
    child_workflow_execution_timed_out_event_attributes: "ChildWorkflowExecutionTimedOutEventAttributes" = betterproto.message_field(
        40, group="attributes"
    )
    child_workflow_execution_terminated_event_attributes: "ChildWorkflowExecutionTerminatedEventAttributes" = betterproto.message_field(
        41, group="attributes"
    )
    signal_external_workflow_execution_initiated_event_attributes: "SignalExternalWorkflowExecutionInitiatedEventAttributes" = betterproto.message_field(
        42, group="attributes"
    )
    signal_external_workflow_execution_failed_event_attributes: "SignalExternalWorkflowExecutionFailedEventAttributes" = betterproto.message_field(
        43, group="attributes"
    )
    external_workflow_execution_signaled_event_attributes: "ExternalWorkflowExecutionSignaledEventAttributes" = betterproto.message_field(
        44, group="attributes"
    )
    upsert_workflow_search_attributes_event_attributes: "UpsertWorkflowSearchAttributesEventAttributes" = betterproto.message_field(
        45, group="attributes"
    )


@dataclass
class History(betterproto.Message):
    events: List["HistoryEvent"] = betterproto.message_field(1)
