from configparser import ConfigParser
from setuptools import setup, find_packages

config = ConfigParser(delimiters=['='])
config.read('settings.ini')
cfg = config['DEFAULT']

setup(
    name = cfg['lib_name'],
    version=cfg['version'],
    packages=find_packages(),
    install_requires = ['pandas', 'plotly', 'seaborn', 'fastcore', 'sqlalchemy', 'sshtunnel', 'loguru', 'psycopg2-binary', 'oceano-algos', 'selenium', 'beautifulsoup4', 'numpy', 'undetected_chromedriver'], # <-- DO NOT EDIT, THIS LINE IS AUTOGENERATED
    long_description=cfg['long_description'],
    description=cfg['description']
)