# coding: utf-8

"""
    CredentialIssuanceService

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.0
    Contact: info@affinidi.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError

from typing_extensions import Annotated
from pydantic import Field, StrictStr, conint, constr

from typing import Optional

from affinidi_tdk_credential_issuance_client.models.batch_credential_input import BatchCredentialInput
from affinidi_tdk_credential_issuance_client.models.batch_credential_response import BatchCredentialResponse
from affinidi_tdk_credential_issuance_client.models.claimed_credential_list_response import ClaimedCredentialListResponse
from affinidi_tdk_credential_issuance_client.models.claimed_credential_response import ClaimedCredentialResponse
from affinidi_tdk_credential_issuance_client.models.create_credential_input import CreateCredentialInput
from affinidi_tdk_credential_issuance_client.models.credential_response import CredentialResponse

from affinidi_tdk_credential_issuance_client.api_client import ApiClient
from affinidi_tdk_credential_issuance_client.api_response import ApiResponse
from affinidi_tdk_credential_issuance_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class CredentialsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def batch_credential(self, project_id : Annotated[StrictStr, Field(..., description="Affinidi project id")], batch_credential_input : Annotated[BatchCredentialInput, Field(..., description="Request body for batch credential")], **kwargs) -> BatchCredentialResponse:  # noqa: E501
        """Allows wallets to claim multiple credentials at once.  # noqa: E501

        Allows wallets to claim multiple credentials at once. For authentication, it uses a token from the authorization server  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.batch_credential(project_id, batch_credential_input, async_req=True)
        >>> result = thread.get()

        :param project_id: Affinidi project id (required)
        :type project_id: str
        :param batch_credential_input: Request body for batch credential (required)
        :type batch_credential_input: BatchCredentialInput
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: BatchCredentialResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the batch_credential_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.batch_credential_with_http_info(project_id, batch_credential_input, **kwargs)  # noqa: E501

    @validate_arguments
    def batch_credential_with_http_info(self, project_id : Annotated[StrictStr, Field(..., description="Affinidi project id")], batch_credential_input : Annotated[BatchCredentialInput, Field(..., description="Request body for batch credential")], **kwargs) -> ApiResponse:  # noqa: E501
        """Allows wallets to claim multiple credentials at once.  # noqa: E501

        Allows wallets to claim multiple credentials at once. For authentication, it uses a token from the authorization server  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.batch_credential_with_http_info(project_id, batch_credential_input, async_req=True)
        >>> result = thread.get()

        :param project_id: Affinidi project id (required)
        :type project_id: str
        :param batch_credential_input: Request body for batch credential (required)
        :type batch_credential_input: BatchCredentialInput
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(BatchCredentialResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'batch_credential_input'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_credential" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id'] is not None:
            _path_params['projectId'] = _params['project_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['batch_credential_input'] is not None:
            _body_params = _params['batch_credential_input']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "BatchCredentialResponse",
        }

        return self.api_client.call_api(
            '/v1/{projectId}/batch_credential', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def generate_credentials(self, project_id : Annotated[StrictStr, Field(..., description="Affinidi project id")], create_credential_input : Annotated[CreateCredentialInput, Field(..., description="Request body to issue credentials")], **kwargs) -> CredentialResponse:  # noqa: E501
        """generate_credentials  # noqa: E501

        Issue credential for end user upon presentation a valid access token. Since we don't immediate issue credential It's expected to return `transaction_id` and use this `transaction_id` to get the deferred credentials  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.generate_credentials(project_id, create_credential_input, async_req=True)
        >>> result = thread.get()

        :param project_id: Affinidi project id (required)
        :type project_id: str
        :param create_credential_input: Request body to issue credentials (required)
        :type create_credential_input: CreateCredentialInput
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CredentialResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the generate_credentials_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.generate_credentials_with_http_info(project_id, create_credential_input, **kwargs)  # noqa: E501

    @validate_arguments
    def generate_credentials_with_http_info(self, project_id : Annotated[StrictStr, Field(..., description="Affinidi project id")], create_credential_input : Annotated[CreateCredentialInput, Field(..., description="Request body to issue credentials")], **kwargs) -> ApiResponse:  # noqa: E501
        """generate_credentials  # noqa: E501

        Issue credential for end user upon presentation a valid access token. Since we don't immediate issue credential It's expected to return `transaction_id` and use this `transaction_id` to get the deferred credentials  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.generate_credentials_with_http_info(project_id, create_credential_input, async_req=True)
        >>> result = thread.get()

        :param project_id: Affinidi project id (required)
        :type project_id: str
        :param create_credential_input: Request body to issue credentials (required)
        :type create_credential_input: CreateCredentialInput
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CredentialResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'create_credential_input'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_credentials" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id'] is not None:
            _path_params['projectId'] = _params['project_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_credential_input'] is not None:
            _body_params = _params['create_credential_input']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "CredentialResponse",
            '400': "GenerateCredentials400Response",
            '401': "InvalidJwtTokenError",
        }

        return self.api_client.call_api(
            '/v1/{projectId}/credential', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_claimed_credentials(self, project_id : Annotated[StrictStr, Field(..., description="project id")], configuration_id : Annotated[StrictStr, Field(..., description="configuration id")], range_start_time : StrictStr, range_end_time : Optional[StrictStr] = None, exclusive_start_key : Annotated[Optional[constr(strict=True, max_length=3000)], Field(description="exclusiveStartKey for retrieving the next batch of data.")] = None, limit : Optional[conint(strict=True, le=20, ge=1)] = None, **kwargs) -> ClaimedCredentialListResponse:  # noqa: E501
        """Get claimed credential in the specified range  # noqa: E501

        Get claimed credential in the specified range  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_claimed_credentials(project_id, configuration_id, range_start_time, range_end_time, exclusive_start_key, limit, async_req=True)
        >>> result = thread.get()

        :param project_id: project id (required)
        :type project_id: str
        :param configuration_id: configuration id (required)
        :type configuration_id: str
        :param range_start_time: (required)
        :type range_start_time: str
        :param range_end_time:
        :type range_end_time: str
        :param exclusive_start_key: exclusiveStartKey for retrieving the next batch of data.
        :type exclusive_start_key: str
        :param limit:
        :type limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ClaimedCredentialListResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_claimed_credentials_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_claimed_credentials_with_http_info(project_id, configuration_id, range_start_time, range_end_time, exclusive_start_key, limit, **kwargs)  # noqa: E501

    @validate_arguments
    def get_claimed_credentials_with_http_info(self, project_id : Annotated[StrictStr, Field(..., description="project id")], configuration_id : Annotated[StrictStr, Field(..., description="configuration id")], range_start_time : StrictStr, range_end_time : Optional[StrictStr] = None, exclusive_start_key : Annotated[Optional[constr(strict=True, max_length=3000)], Field(description="exclusiveStartKey for retrieving the next batch of data.")] = None, limit : Optional[conint(strict=True, le=20, ge=1)] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get claimed credential in the specified range  # noqa: E501

        Get claimed credential in the specified range  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_claimed_credentials_with_http_info(project_id, configuration_id, range_start_time, range_end_time, exclusive_start_key, limit, async_req=True)
        >>> result = thread.get()

        :param project_id: project id (required)
        :type project_id: str
        :param configuration_id: configuration id (required)
        :type configuration_id: str
        :param range_start_time: (required)
        :type range_start_time: str
        :param range_end_time:
        :type range_end_time: str
        :param exclusive_start_key: exclusiveStartKey for retrieving the next batch of data.
        :type exclusive_start_key: str
        :param limit:
        :type limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ClaimedCredentialListResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'configuration_id',
            'range_start_time',
            'range_end_time',
            'exclusive_start_key',
            'limit'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_claimed_credentials" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id'] is not None:
            _path_params['projectId'] = _params['project_id']

        if _params['configuration_id'] is not None:
            _path_params['configurationId'] = _params['configuration_id']


        # process the query parameters
        _query_params = []
        if _params.get('range_start_time') is not None:  # noqa: E501
            _query_params.append(('rangeStartTime', _params['range_start_time']))

        if _params.get('range_end_time') is not None:  # noqa: E501
            _query_params.append(('rangeEndTime', _params['range_end_time']))

        if _params.get('exclusive_start_key') is not None:  # noqa: E501
            _query_params.append(('exclusiveStartKey', _params['exclusive_start_key']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ProjectTokenAuth']  # noqa: E501

        _response_types_map = {
            '200': "ClaimedCredentialListResponse",
            '400': "InvalidParameterError",
            '404': "NotFoundError",
        }

        return self.api_client.call_api(
            '/v1/{projectId}/configurations/{configurationId}/credentials', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_issuance_id_claimed_credential(self, project_id : Annotated[StrictStr, Field(..., description="project id")], configuration_id : Annotated[StrictStr, Field(..., description="configuration id")], issuance_id : Annotated[StrictStr, Field(..., description="issuance id")], **kwargs) -> ClaimedCredentialResponse:  # noqa: E501
        """Get claimed VC linked to the issuanceId  # noqa: E501

        Get claimed VC linked to the issuanceId  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_issuance_id_claimed_credential(project_id, configuration_id, issuance_id, async_req=True)
        >>> result = thread.get()

        :param project_id: project id (required)
        :type project_id: str
        :param configuration_id: configuration id (required)
        :type configuration_id: str
        :param issuance_id: issuance id (required)
        :type issuance_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ClaimedCredentialResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_issuance_id_claimed_credential_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_issuance_id_claimed_credential_with_http_info(project_id, configuration_id, issuance_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_issuance_id_claimed_credential_with_http_info(self, project_id : Annotated[StrictStr, Field(..., description="project id")], configuration_id : Annotated[StrictStr, Field(..., description="configuration id")], issuance_id : Annotated[StrictStr, Field(..., description="issuance id")], **kwargs) -> ApiResponse:  # noqa: E501
        """Get claimed VC linked to the issuanceId  # noqa: E501

        Get claimed VC linked to the issuanceId  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_issuance_id_claimed_credential_with_http_info(project_id, configuration_id, issuance_id, async_req=True)
        >>> result = thread.get()

        :param project_id: project id (required)
        :type project_id: str
        :param configuration_id: configuration id (required)
        :type configuration_id: str
        :param issuance_id: issuance id (required)
        :type issuance_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ClaimedCredentialResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'configuration_id',
            'issuance_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_issuance_id_claimed_credential" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id'] is not None:
            _path_params['projectId'] = _params['project_id']

        if _params['configuration_id'] is not None:
            _path_params['configurationId'] = _params['configuration_id']

        if _params['issuance_id'] is not None:
            _path_params['issuanceId'] = _params['issuance_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ProjectTokenAuth']  # noqa: E501

        _response_types_map = {
            '200': "ClaimedCredentialResponse",
            '400': "InvalidParameterError",
            '404': "NotFoundError",
        }

        return self.api_client.call_api(
            '/v1/{projectId}/configurations/{configurationId}/issuances/{issuanceId}/credentials', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
