# coding: utf-8

"""
    CredentialIssuanceService

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.0
    Contact: info@affinidi.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError

from typing_extensions import Annotated
from pydantic import Field, StrictStr, conint, constr

from typing import Optional

from affinidi_tdk_credential_issuance_client.models.change_credential_status_input import ChangeCredentialStatusInput
from affinidi_tdk_credential_issuance_client.models.flow_data import FlowData
from affinidi_tdk_credential_issuance_client.models.list_issuance_record_response import ListIssuanceRecordResponse

from affinidi_tdk_credential_issuance_client.api_client import ApiClient
from affinidi_tdk_credential_issuance_client.api_response import ApiResponse
from affinidi_tdk_credential_issuance_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DefaultApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def change_credential_status(self, project_id : Annotated[StrictStr, Field(..., description="project id")], configuration_id : Annotated[StrictStr, Field(..., description="configuration id")], change_credential_status_input : Annotated[ChangeCredentialStatusInput, Field(..., description="Request body for changing credential status")], **kwargs) -> FlowData:  # noqa: E501
        """change credential status.  # noqa: E501

        change credential status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.change_credential_status(project_id, configuration_id, change_credential_status_input, async_req=True)
        >>> result = thread.get()

        :param project_id: project id (required)
        :type project_id: str
        :param configuration_id: configuration id (required)
        :type configuration_id: str
        :param change_credential_status_input: Request body for changing credential status (required)
        :type change_credential_status_input: ChangeCredentialStatusInput
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FlowData
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the change_credential_status_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.change_credential_status_with_http_info(project_id, configuration_id, change_credential_status_input, **kwargs)  # noqa: E501

    @validate_arguments
    def change_credential_status_with_http_info(self, project_id : Annotated[StrictStr, Field(..., description="project id")], configuration_id : Annotated[StrictStr, Field(..., description="configuration id")], change_credential_status_input : Annotated[ChangeCredentialStatusInput, Field(..., description="Request body for changing credential status")], **kwargs) -> ApiResponse:  # noqa: E501
        """change credential status.  # noqa: E501

        change credential status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.change_credential_status_with_http_info(project_id, configuration_id, change_credential_status_input, async_req=True)
        >>> result = thread.get()

        :param project_id: project id (required)
        :type project_id: str
        :param configuration_id: configuration id (required)
        :type configuration_id: str
        :param change_credential_status_input: Request body for changing credential status (required)
        :type change_credential_status_input: ChangeCredentialStatusInput
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FlowData, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'configuration_id',
            'change_credential_status_input'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method change_credential_status" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id'] is not None:
            _path_params['projectId'] = _params['project_id']

        if _params['configuration_id'] is not None:
            _path_params['configurationId'] = _params['configuration_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['change_credential_status_input'] is not None:
            _body_params = _params['change_credential_status_input']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ProjectTokenAuth']  # noqa: E501

        _response_types_map = {
            '200': "FlowData",
            '400': "ChangeCredentialStatus400Response",
            '404': "NotFoundError",
        }

        return self.api_client.call_api(
            '/v1/{projectId}/configurations/{configurationId}/issuance/change-status', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_issuance_data_records(self, project_id : Annotated[StrictStr, Field(..., description="Affinidi project id")], configuration_id : Annotated[StrictStr, Field(..., description="The id of the issuance configuration")], limit : Annotated[Optional[conint(strict=True, le=100, ge=1)], Field(description="Maximum number of records to fetch in a list")] = None, exclusive_start_key : Annotated[Optional[constr(strict=True, max_length=3000)], Field(description="exclusiveStartKey for retrieving the next batch of data.")] = None, **kwargs) -> ListIssuanceRecordResponse:  # noqa: E501
        """List records  # noqa: E501

        Retrieve a list of issuance data records.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_issuance_data_records(project_id, configuration_id, limit, exclusive_start_key, async_req=True)
        >>> result = thread.get()

        :param project_id: Affinidi project id (required)
        :type project_id: str
        :param configuration_id: The id of the issuance configuration (required)
        :type configuration_id: str
        :param limit: Maximum number of records to fetch in a list
        :type limit: int
        :param exclusive_start_key: exclusiveStartKey for retrieving the next batch of data.
        :type exclusive_start_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListIssuanceRecordResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_issuance_data_records_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_issuance_data_records_with_http_info(project_id, configuration_id, limit, exclusive_start_key, **kwargs)  # noqa: E501

    @validate_arguments
    def list_issuance_data_records_with_http_info(self, project_id : Annotated[StrictStr, Field(..., description="Affinidi project id")], configuration_id : Annotated[StrictStr, Field(..., description="The id of the issuance configuration")], limit : Annotated[Optional[conint(strict=True, le=100, ge=1)], Field(description="Maximum number of records to fetch in a list")] = None, exclusive_start_key : Annotated[Optional[constr(strict=True, max_length=3000)], Field(description="exclusiveStartKey for retrieving the next batch of data.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List records  # noqa: E501

        Retrieve a list of issuance data records.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_issuance_data_records_with_http_info(project_id, configuration_id, limit, exclusive_start_key, async_req=True)
        >>> result = thread.get()

        :param project_id: Affinidi project id (required)
        :type project_id: str
        :param configuration_id: The id of the issuance configuration (required)
        :type configuration_id: str
        :param limit: Maximum number of records to fetch in a list
        :type limit: int
        :param exclusive_start_key: exclusiveStartKey for retrieving the next batch of data.
        :type exclusive_start_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListIssuanceRecordResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'configuration_id',
            'limit',
            'exclusive_start_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_issuance_data_records" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id'] is not None:
            _path_params['projectId'] = _params['project_id']

        if _params['configuration_id'] is not None:
            _path_params['configurationId'] = _params['configuration_id']


        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('exclusive_start_key') is not None:  # noqa: E501
            _query_params.append(('exclusiveStartKey', _params['exclusive_start_key']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ProjectTokenAuth']  # noqa: E501

        _response_types_map = {
            '200': "ListIssuanceRecordResponse",
            '400': "InvalidParameterError",
            '404': "NotFoundError",
        }

        return self.api_client.call_api(
            '/v1/{projectId}/configurations/{configurationId}/issuance/issuance-data-records', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
