# coding: utf-8

"""
    CredentialIssuanceService

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.0
    Contact: info@affinidi.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from affinidi_tdk_credential_issuance_client.models.flow_data_status_lists_details_inner import FlowDataStatusListsDetailsInner

class FlowData(BaseModel):
    """
    FlowData
    """
    created_at: StrictStr = Field(default=..., alias="createdAt", description="[GEN] ISO 8601 string of the creation date/time the entity")
    modified_at: StrictStr = Field(default=..., alias="modifiedAt", description="[GEN] ISO 8601 string of the modification date/time the entity")
    id: StrictStr = Field(...)
    project_id: Optional[StrictStr] = Field(default=None, alias="projectId")
    flow_id: StrictStr = Field(default=..., alias="flowId")
    credential_type_id: StrictStr = Field(default=..., alias="credentialTypeId")
    json_ld_context_url: StrictStr = Field(default=..., alias="jsonLdContextUrl")
    json_schema_url: StrictStr = Field(default=..., alias="jsonSchemaUrl")
    configuration_id: Optional[StrictStr] = Field(default=None, alias="configurationId", description="Id of configuration, used to issue VC.")
    issued_at: Optional[StrictStr] = Field(default=None, alias="issuedAt", description="when credential was issued to the holder (holder invoked generateCredentials endpoint)")
    wallet_id: Optional[StrictStr] = Field(default=None, alias="walletId", description="Id of wallet, used to issue VC.")
    project_id_configuration_id: Optional[StrictStr] = Field(default=None, alias="projectIdConfigurationId", description="Id of configuration with which VC was issued. To use as an index, it is grouped together with projectId, as \"{projectIdConfigurationId}#{configurationId}\"")
    project_id_configuration_id_wallet_id: Optional[StrictStr] = Field(default=None, alias="projectIdConfigurationIdWalletId", description="Id of wallet which issued VC. To use as an index, it is grouped together with projectId, as \"{projectIdConfigurationId}#{walletId}\"")
    project_id_configuration_id_credential_type: Optional[StrictStr] = Field(default=None, alias="projectIdConfigurationIdCredentialType", description="VC.type value. To use as an index, it is grouped together with projectId, as \"{projectIdConfigurationId}#{credentialType}\"")
    status_lists_details: Optional[conlist(FlowDataStatusListsDetailsInner)] = Field(default=None, alias="statusListsDetails")
    __properties = ["createdAt", "modifiedAt", "id", "projectId", "flowId", "credentialTypeId", "jsonLdContextUrl", "jsonSchemaUrl", "configurationId", "issuedAt", "walletId", "projectIdConfigurationId", "projectIdConfigurationIdWalletId", "projectIdConfigurationIdCredentialType", "statusListsDetails"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FlowData:
        """Create an instance of FlowData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in status_lists_details (list)
        _items = []
        if self.status_lists_details:
            for _item in self.status_lists_details:
                if _item:
                    _items.append(_item.to_dict())
            _dict['statusListsDetails'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FlowData:
        """Create an instance of FlowData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FlowData.parse_obj(obj)

        _obj = FlowData.parse_obj({
            "created_at": obj.get("createdAt"),
            "modified_at": obj.get("modifiedAt"),
            "id": obj.get("id"),
            "project_id": obj.get("projectId"),
            "flow_id": obj.get("flowId"),
            "credential_type_id": obj.get("credentialTypeId"),
            "json_ld_context_url": obj.get("jsonLdContextUrl"),
            "json_schema_url": obj.get("jsonSchemaUrl"),
            "configuration_id": obj.get("configurationId"),
            "issued_at": obj.get("issuedAt"),
            "wallet_id": obj.get("walletId"),
            "project_id_configuration_id": obj.get("projectIdConfigurationId"),
            "project_id_configuration_id_wallet_id": obj.get("projectIdConfigurationIdWalletId"),
            "project_id_configuration_id_credential_type": obj.get("projectIdConfigurationIdCredentialType"),
            "status_lists_details": [FlowDataStatusListsDetailsInner.from_dict(_item) for _item in obj.get("statusListsDetails")] if obj.get("statusListsDetails") is not None else None
        })
        return _obj


