# coding: utf-8

"""
    CredentialIssuanceService

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.0
    Contact: info@affinidi.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from affinidi_tdk_credential_issuance_client.models.start_issuance_input_data_inner_meta_data import StartIssuanceInputDataInnerMetaData
from affinidi_tdk_credential_issuance_client.models.start_issuance_input_data_inner_status_list_details_inner import StartIssuanceInputDataInnerStatusListDetailsInner

class StartIssuanceInputDataInner(BaseModel):
    """
    Data to be included in issued credential  # noqa: E501
    """
    credential_type_id: StrictStr = Field(default=..., alias="credentialTypeId", description="It is a String that identifies a Credential that is being requested to be issued.")
    credential_data: Dict[str, Any] = Field(default=..., alias="credentialData", description="Object of data to be included in the issued credential ,should  match the credential type")
    status_list_details: Optional[conlist(StartIssuanceInputDataInnerStatusListDetailsInner)] = Field(default=None, alias="statusListDetails", description="Types of status lists to which the credential should be added once issued. If not provided or empty, the credential is not added to any of the status lists.")
    meta_data: Optional[StartIssuanceInputDataInnerMetaData] = Field(default=None, alias="metaData")
    __properties = ["credentialTypeId", "credentialData", "statusListDetails", "metaData"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StartIssuanceInputDataInner:
        """Create an instance of StartIssuanceInputDataInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in status_list_details (list)
        _items = []
        if self.status_list_details:
            for _item in self.status_list_details:
                if _item:
                    _items.append(_item.to_dict())
            _dict['statusListDetails'] = _items
        # override the default output from pydantic by calling `to_dict()` of meta_data
        if self.meta_data:
            _dict['metaData'] = self.meta_data.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StartIssuanceInputDataInner:
        """Create an instance of StartIssuanceInputDataInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return StartIssuanceInputDataInner.parse_obj(obj)

        _obj = StartIssuanceInputDataInner.parse_obj({
            "credential_type_id": obj.get("credentialTypeId"),
            "credential_data": obj.get("credentialData"),
            "status_list_details": [StartIssuanceInputDataInnerStatusListDetailsInner.from_dict(_item) for _item in obj.get("statusListDetails")] if obj.get("statusListDetails") is not None else None,
            "meta_data": StartIssuanceInputDataInnerMetaData.from_dict(obj.get("metaData")) if obj.get("metaData") is not None else None
        })
        return _obj


