# coding: utf-8

"""
    CredentialIssuanceService

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.0
    Contact: info@affinidi.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, StrictStr, conlist, validator
from affinidi_tdk_credential_issuance_client.models.well_known_open_id_credential_issuer_response_credentials_supported_inner import WellKnownOpenIdCredentialIssuerResponseCredentialsSupportedInner

class WellKnownOpenIdCredentialIssuerResponse(BaseModel):
    """
    WellKnownOpenIdCredentialIssuerResponse
    """
    authorization_endpoint: Optional[StrictStr] = None
    credential_endpoint: Optional[StrictStr] = None
    credential_issuer: Optional[StrictStr] = None
    batch_credential_endpoint: Optional[StrictStr] = None
    credentials_supported: Optional[conlist(WellKnownOpenIdCredentialIssuerResponseCredentialsSupportedInner)] = None
    deferred_credential_endpoint: Optional[StrictStr] = None
    grant_types_supported: Optional[conlist(StrictStr)] = None
    jwks_uri: Optional[StrictStr] = None
    scopes_supported: Optional[conlist(StrictStr)] = None
    token_endpoint: Optional[StrictStr] = None
    token_endpoint_auth_methods_supported: Optional[conlist(StrictStr)] = None
    additional_properties: Dict[str, Any] = {}
    __properties = ["authorization_endpoint", "credential_endpoint", "credential_issuer", "batch_credential_endpoint", "credentials_supported", "deferred_credential_endpoint", "grant_types_supported", "jwks_uri", "scopes_supported", "token_endpoint", "token_endpoint_auth_methods_supported"]

    @validator('grant_types_supported')
    def grant_types_supported_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in ('authorization_code', 'urn:ietf:params:oauth:grant-type:pre-authorized_code'):
                raise ValueError("each list item must be one of ('authorization_code', 'urn:ietf:params:oauth:grant-type:pre-authorized_code')")
        return value

    @validator('scopes_supported')
    def scopes_supported_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in ('openid'):
                raise ValueError("each list item must be one of ('openid')")
        return value

    @validator('token_endpoint_auth_methods_supported')
    def token_endpoint_auth_methods_supported_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in ('client_secret_post', 'client_secret_basic', 'none'):
                raise ValueError("each list item must be one of ('client_secret_post', 'client_secret_basic', 'none')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WellKnownOpenIdCredentialIssuerResponse:
        """Create an instance of WellKnownOpenIdCredentialIssuerResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "additional_properties"
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in credentials_supported (list)
        _items = []
        if self.credentials_supported:
            for _item in self.credentials_supported:
                if _item:
                    _items.append(_item.to_dict())
            _dict['credentials_supported'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WellKnownOpenIdCredentialIssuerResponse:
        """Create an instance of WellKnownOpenIdCredentialIssuerResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return WellKnownOpenIdCredentialIssuerResponse.parse_obj(obj)

        _obj = WellKnownOpenIdCredentialIssuerResponse.parse_obj({
            "authorization_endpoint": obj.get("authorization_endpoint"),
            "credential_endpoint": obj.get("credential_endpoint"),
            "credential_issuer": obj.get("credential_issuer"),
            "batch_credential_endpoint": obj.get("batch_credential_endpoint"),
            "credentials_supported": [WellKnownOpenIdCredentialIssuerResponseCredentialsSupportedInner.from_dict(_item) for _item in obj.get("credentials_supported")] if obj.get("credentials_supported") is not None else None,
            "deferred_credential_endpoint": obj.get("deferred_credential_endpoint"),
            "grant_types_supported": obj.get("grant_types_supported"),
            "jwks_uri": obj.get("jwks_uri"),
            "scopes_supported": obj.get("scopes_supported"),
            "token_endpoint": obj.get("token_endpoint"),
            "token_endpoint_auth_methods_supported": obj.get("token_endpoint_auth_methods_supported")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


