from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkIOCore

VTK_BIG_ENDIAN:int
VTK_COLOR_MODE_DEFAULT:int
VTK_COLOR_MODE_OFF:int
VTK_COLOR_MODE_UNIFORM_CELL_COLOR:int
VTK_COLOR_MODE_UNIFORM_COLOR:int
VTK_COLOR_MODE_UNIFORM_POINT_COLOR:int
VTK_LITTLE_ENDIAN:int
VTK_TEXTURECOORDS_TEXTUREUV:int
VTK_TEXTURECOORDS_UV:int

class vtkPLY(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkPLY') -> None: ...
    @staticmethod
    def equal_strings(__a:str, __b:str) -> bool: ...
    @staticmethod
    def get_ascii_item(__a:'vtkResourceParser', __b:int, __c:MutableSequence[int], __d:MutableSequence[int], __e:MutableSequence[float]) -> None: ...
    @staticmethod
    def get_item_value(__a:str, __b:int) -> float: ...
    @staticmethod
    def get_prop_type(__a:str) -> int: ...
    @staticmethod
    def get_stored_item(__a:Pointer, __b:int, __c:MutableSequence[int], __d:MutableSequence[int], __e:MutableSequence[float]) -> None: ...
    @staticmethod
    def my_alloc(__a:int, __b:int, __c:str) -> Pointer: ...
    @staticmethod
    def store_item(__a:str, __b:int, __c:int, __d:int, __e:float) -> None: ...

class vtkPLYReader(vtkmodules.vtkIOCore.vtkAbstractPolyDataReader):
    comments:'getset_descriptor'
    duplicate_points_for_face_texture:'getset_descriptor'
    face_texture_tolerance:'getset_descriptor'
    input_string:'getset_descriptor'
    read_from_input_stream:'getset_descriptor'
    read_from_input_string:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def CanReadFile(filename:str) -> int: ...
    def GetComments(self) -> 'vtkStringArray': ...
    def GetDuplicatePointsForFaceTexture(self) -> bool: ...
    def GetFaceTextureTolerance(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetReadFromInputStream(self) -> bool: ...
    def GetReadFromInputString(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPLYReader': ...
    def ReadFromInputStreamOff(self) -> None: ...
    def ReadFromInputStreamOn(self) -> None: ...
    def ReadFromInputStringOff(self) -> None: ...
    def ReadFromInputStringOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPLYReader': ...
    def SetDuplicatePointsForFaceTexture(self, _arg:bool) -> None: ...
    def SetFaceTextureTolerance(self, _arg:float) -> None: ...
    def SetInputString(self, s:str) -> None: ...
    def SetReadFromInputStream(self, _arg:bool) -> None: ...
    def SetReadFromInputString(self, _arg:bool) -> None: ...

class vtkPLYWriter(vtkmodules.vtkIOCore.vtkWriter):
    alpha:'getset_descriptor'
    array_name:'getset_descriptor'
    color:'getset_descriptor'
    color_mode:'getset_descriptor'
    component:'getset_descriptor'
    data_byte_order:'getset_descriptor'
    enable_alpha:'getset_descriptor'
    file_name:'getset_descriptor'
    file_type:'getset_descriptor'
    input:'getset_descriptor'
    lookup_table:'getset_descriptor'
    output_string:'getset_descriptor'
    texture_coordinates_name:'getset_descriptor'
    write_object_information:'getset_descriptor'
    write_to_output_string:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddComment(self, comment:str) -> None: ...
    def EnableAlphaOff(self) -> None: ...
    def EnableAlphaOn(self) -> None: ...
    def GetAlpha(self) -> int: ...
    def GetArrayName(self) -> str: ...
    def GetColor(self) -> Tuple[int, int, int]: ...
    def GetColorMode(self) -> int: ...
    def GetComponent(self) -> int: ...
    def GetComponentMaxValue(self) -> int: ...
    def GetComponentMinValue(self) -> int: ...
    def GetDataByteOrder(self) -> int: ...
    def GetDataByteOrderMaxValue(self) -> int: ...
    def GetDataByteOrderMinValue(self) -> int: ...
    def GetEnableAlpha(self) -> bool: ...
    def GetFileName(self) -> str: ...
    def GetFileType(self) -> int: ...
    def GetFileTypeMaxValue(self) -> int: ...
    def GetFileTypeMinValue(self) -> int: ...
    @overload
    def GetInput(self) -> 'vtkPolyData': ...
    @overload
    def GetInput(self, port:int) -> 'vtkPolyData': ...
    def GetLookupTable(self) -> 'vtkScalarsToColors': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputString(self) -> str: ...
    def GetTextureCoordinatesName(self) -> int: ...
    def GetTextureCoordinatesNameMaxValue(self) -> int: ...
    def GetTextureCoordinatesNameMinValue(self) -> int: ...
    def GetWriteObjectInformation(self) -> bool: ...
    def GetWriteToOutputString(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPLYWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPLYWriter': ...
    def SetAlpha(self, _arg:int) -> None: ...
    def SetArrayName(self, _arg:str) -> None: ...
    @overload
    def SetColor(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetColor(self, _arg:Sequence[int]) -> None: ...
    def SetColorMode(self, _arg:int) -> None: ...
    def SetColorModeToDefault(self) -> None: ...
    def SetColorModeToOff(self) -> None: ...
    def SetColorModeToUniformCellColor(self) -> None: ...
    def SetColorModeToUniformColor(self) -> None: ...
    def SetColorModeToUniformPointColor(self) -> None: ...
    def SetComponent(self, _arg:int) -> None: ...
    def SetDataByteOrder(self, _arg:int) -> None: ...
    def SetDataByteOrderToBigEndian(self) -> None: ...
    def SetDataByteOrderToLittleEndian(self) -> None: ...
    def SetEnableAlpha(self, _arg:bool) -> None: ...
    def SetFileName(self, _arg:str) -> None: ...
    def SetFileType(self, _arg:int) -> None: ...
    def SetFileTypeToASCII(self) -> None: ...
    def SetFileTypeToBinary(self) -> None: ...
    def SetLookupTable(self, __a:'vtkScalarsToColors') -> None: ...
    def SetTextureCoordinatesName(self, _arg:int) -> None: ...
    def SetTextureCoordinatesNameToTextureUV(self) -> None: ...
    def SetTextureCoordinatesNameToUV(self) -> None: ...
    def SetWriteObjectInformation(self, _arg:bool) -> None: ...
    def SetWriteToOutputString(self, _arg:bool) -> None: ...
    def WriteObjectInformationOff(self) -> None: ...
    def WriteObjectInformationOn(self) -> None: ...
    def WriteToOutputStringOff(self) -> None: ...
    def WriteToOutputStringOn(self) -> None: ...

