from com.alipay.ams.api.model.payment_method_detail import PaymentMethodDetail
from com.alipay.ams.api.response.alipay_response import AlipayResponse


class AlipayVaultingQueryResponse(AlipayResponse):
    def __init__(self, rsp_body):
        super(AlipayVaultingQueryResponse, self).__init__()
        self.__vaulting_request_id = None
        self.__normal_url = None
        self.__scheme_url = None
        self.__applink_url = None
        self.__vaulting_status = None
        self.__payment_method_detail = None #type: PaymentMethodDetail
        self.__parse_rsp_body(rsp_body)

    @property
    def vaulting_request_id(self):
        return self.__vaulting_request_id

    @property
    def normal_url(self):
        return self.__normal_url

    @property
    def scheme_url(self):
        return self.__scheme_url

    @property
    def applink_url(self):
        return self.__applink_url

    @property
    def vaulting_status(self):
        return self.__vaulting_status

    @property
    def payment_method_detail(self):
        return self.__payment_method_detail

    def __parse_rsp_body(self, rsp_body):
        rsp_dict = super(AlipayVaultingQueryResponse, self).parse_rsp_body(rsp_body)
        if 'vaultingRequestId' in rsp_dict:
            self.__vaulting_request_id = rsp_dict['vaultingRequestId']
        if 'normalUrl' in rsp_dict:
            self.__normal_url = rsp_dict['normalUrl']
        if 'schemeUrl' in rsp_dict:
            self.__scheme_url = rsp_dict['schemeUrl']
        if 'applinkUrl' in rsp_dict:
            self.__applink_url = rsp_dict['applinkUrl']
        if 'vaultingStatus' in rsp_dict:
            self.__vaulting_status = rsp_dict['vaultingStatus']
        if 'paymentMethodDetail' in rsp_dict:
            self.__payment_method_detail = PaymentMethodDetail.parse_rsp_body(rsp_dict['paymentMethodDetail'])
