import os

from InquirerPy import inquirer
from InquirerPy.base.control import Choice
from InquirerPy.separator import Separator

from yt_music_mixer.yt_music_mixer import main
from yt_music_mixer.playback import shuffle_play


BASE_PATH = os.path.abspath(os.getcwd())


menu_callables = {
    'export': lambda: main(),
    'shuffle': lambda: shuffle_play(BASE_PATH),
}
menu_choices = [
    Choice(name='YouTube Audio Export Tool', value='export'),
    Choice(name='Play Shuffle Mix', value='shuffle'),
    Separator(),
    Choice(name='Exit Script', value=None)
]
selected = inquirer.select(
    message="Please select a module to run for this utility >> ",
    choices=menu_choices,
    default=menu_choices[0]
).execute()

if selected in menu_callables:
    os.system('clear')
    menu_callables[selected]()
else:
    raise SystemExit('No operation specified. Aborting.')
