import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMobileNetworkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network#id DataAzurermMobileNetwork#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network#name DataAzurermMobileNetwork#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network#resource_group_name DataAzurermMobileNetwork#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network#timeouts DataAzurermMobileNetwork#timeouts}
    */
    readonly timeouts?: DataAzurermMobileNetworkTimeouts;
}
export interface DataAzurermMobileNetworkTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network#read DataAzurermMobileNetwork#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMobileNetworkTimeoutsToTerraform(struct?: DataAzurermMobileNetworkTimeoutsOutputReference | DataAzurermMobileNetworkTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMobileNetworkTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMobileNetworkTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermMobileNetworkTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network azurerm_mobile_network}
*/
export declare class DataAzurermMobileNetwork extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_mobile_network";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/mobile_network azurerm_mobile_network} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMobileNetworkConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMobileNetworkConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    get mobileCountryCode(): string;
    get mobileNetworkCode(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get serviceKey(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermMobileNetworkTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMobileNetworkTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermMobileNetworkTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
