import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermVpnGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/vpn_gateway#id DataAzurermVpnGateway#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/vpn_gateway#name DataAzurermVpnGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/vpn_gateway#resource_group_name DataAzurermVpnGateway#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/vpn_gateway#timeouts DataAzurermVpnGateway#timeouts}
    */
    readonly timeouts?: DataAzurermVpnGatewayTimeouts;
}
export interface DataAzurermVpnGatewayBgpSettingsInstance0BgpPeeringAddress {
}
export declare function dataAzurermVpnGatewayBgpSettingsInstance0BgpPeeringAddressToTerraform(struct?: DataAzurermVpnGatewayBgpSettingsInstance0BgpPeeringAddress): any;
export declare class DataAzurermVpnGatewayBgpSettingsInstance0BgpPeeringAddressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVpnGatewayBgpSettingsInstance0BgpPeeringAddress | undefined;
    set internalValue(value: DataAzurermVpnGatewayBgpSettingsInstance0BgpPeeringAddress | undefined);
    get customIps(): string[];
    get defaultIps(): string[];
    get ipConfigurationId(): string;
    get tunnelIps(): string[];
}
export declare class DataAzurermVpnGatewayBgpSettingsInstance0BgpPeeringAddressList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVpnGatewayBgpSettingsInstance0BgpPeeringAddressOutputReference;
}
export interface DataAzurermVpnGatewayBgpSettingsInstance1BgpPeeringAddress {
}
export declare function dataAzurermVpnGatewayBgpSettingsInstance1BgpPeeringAddressToTerraform(struct?: DataAzurermVpnGatewayBgpSettingsInstance1BgpPeeringAddress): any;
export declare class DataAzurermVpnGatewayBgpSettingsInstance1BgpPeeringAddressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVpnGatewayBgpSettingsInstance1BgpPeeringAddress | undefined;
    set internalValue(value: DataAzurermVpnGatewayBgpSettingsInstance1BgpPeeringAddress | undefined);
    get customIps(): string[];
    get defaultIps(): string[];
    get ipConfigurationId(): string;
    get tunnelIps(): string[];
}
export declare class DataAzurermVpnGatewayBgpSettingsInstance1BgpPeeringAddressList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVpnGatewayBgpSettingsInstance1BgpPeeringAddressOutputReference;
}
export interface DataAzurermVpnGatewayBgpSettings {
}
export declare function dataAzurermVpnGatewayBgpSettingsToTerraform(struct?: DataAzurermVpnGatewayBgpSettings): any;
export declare class DataAzurermVpnGatewayBgpSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVpnGatewayBgpSettings | undefined;
    set internalValue(value: DataAzurermVpnGatewayBgpSettings | undefined);
    get asn(): number;
    get bgpPeeringAddress(): string;
    private _instance0BgpPeeringAddress;
    get instance0BgpPeeringAddress(): DataAzurermVpnGatewayBgpSettingsInstance0BgpPeeringAddressList;
    private _instance1BgpPeeringAddress;
    get instance1BgpPeeringAddress(): DataAzurermVpnGatewayBgpSettingsInstance1BgpPeeringAddressList;
    get peerWeight(): number;
}
export declare class DataAzurermVpnGatewayBgpSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVpnGatewayBgpSettingsOutputReference;
}
export interface DataAzurermVpnGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/vpn_gateway#read DataAzurermVpnGateway#read}
    */
    readonly read?: string;
}
export declare function dataAzurermVpnGatewayTimeoutsToTerraform(struct?: DataAzurermVpnGatewayTimeoutsOutputReference | DataAzurermVpnGatewayTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermVpnGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermVpnGatewayTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermVpnGatewayTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/vpn_gateway azurerm_vpn_gateway}
*/
export declare class DataAzurermVpnGateway extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_vpn_gateway";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/vpn_gateway azurerm_vpn_gateway} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermVpnGatewayConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermVpnGatewayConfig);
    private _bgpSettings;
    get bgpSettings(): DataAzurermVpnGatewayBgpSettingsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get scaleUnit(): number;
    private _tags;
    get tags(): cdktf.StringMap;
    get virtualHubId(): string;
    private _timeouts;
    get timeouts(): DataAzurermVpnGatewayTimeoutsOutputReference;
    putTimeouts(value: DataAzurermVpnGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermVpnGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
