import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NginxConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nginx_configuration#id NginxConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nginx_configuration#nginx_deployment_id NginxConfiguration#nginx_deployment_id}
    */
    readonly nginxDeploymentId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nginx_configuration#package_data NginxConfiguration#package_data}
    */
    readonly packageData?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nginx_configuration#root_file NginxConfiguration#root_file}
    */
    readonly rootFile: string;
    /**
    * config_file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nginx_configuration#config_file NginxConfiguration#config_file}
    */
    readonly configFile?: NginxConfigurationConfigFile[] | cdktf.IResolvable;
    /**
    * protected_file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nginx_configuration#protected_file NginxConfiguration#protected_file}
    */
    readonly protectedFile?: NginxConfigurationProtectedFile[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nginx_configuration#timeouts NginxConfiguration#timeouts}
    */
    readonly timeouts?: NginxConfigurationTimeouts;
}
export interface NginxConfigurationConfigFile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nginx_configuration#content NginxConfiguration#content}
    */
    readonly content: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nginx_configuration#virtual_path NginxConfiguration#virtual_path}
    */
    readonly virtualPath: string;
}
export declare function nginxConfigurationConfigFileToTerraform(struct?: NginxConfigurationConfigFile | cdktf.IResolvable): any;
export declare class NginxConfigurationConfigFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NginxConfigurationConfigFile | cdktf.IResolvable | undefined;
    set internalValue(value: NginxConfigurationConfigFile | cdktf.IResolvable | undefined);
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
    private _virtualPath?;
    get virtualPath(): string;
    set virtualPath(value: string);
    get virtualPathInput(): string | undefined;
}
export declare class NginxConfigurationConfigFileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: NginxConfigurationConfigFile[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NginxConfigurationConfigFileOutputReference;
}
export interface NginxConfigurationProtectedFile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nginx_configuration#content NginxConfiguration#content}
    */
    readonly content: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nginx_configuration#virtual_path NginxConfiguration#virtual_path}
    */
    readonly virtualPath: string;
}
export declare function nginxConfigurationProtectedFileToTerraform(struct?: NginxConfigurationProtectedFile | cdktf.IResolvable): any;
export declare class NginxConfigurationProtectedFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NginxConfigurationProtectedFile | cdktf.IResolvable | undefined;
    set internalValue(value: NginxConfigurationProtectedFile | cdktf.IResolvable | undefined);
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
    private _virtualPath?;
    get virtualPath(): string;
    set virtualPath(value: string);
    get virtualPathInput(): string | undefined;
}
export declare class NginxConfigurationProtectedFileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: NginxConfigurationProtectedFile[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NginxConfigurationProtectedFileOutputReference;
}
export interface NginxConfigurationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nginx_configuration#create NginxConfiguration#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nginx_configuration#delete NginxConfiguration#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nginx_configuration#read NginxConfiguration#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nginx_configuration#update NginxConfiguration#update}
    */
    readonly update?: string;
}
export declare function nginxConfigurationTimeoutsToTerraform(struct?: NginxConfigurationTimeoutsOutputReference | NginxConfigurationTimeouts | cdktf.IResolvable): any;
export declare class NginxConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NginxConfigurationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NginxConfigurationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/nginx_configuration azurerm_nginx_configuration}
*/
export declare class NginxConfiguration extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_nginx_configuration";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/nginx_configuration azurerm_nginx_configuration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NginxConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: NginxConfigurationConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _nginxDeploymentId?;
    get nginxDeploymentId(): string;
    set nginxDeploymentId(value: string);
    get nginxDeploymentIdInput(): string | undefined;
    private _packageData?;
    get packageData(): string;
    set packageData(value: string);
    resetPackageData(): void;
    get packageDataInput(): string | undefined;
    private _rootFile?;
    get rootFile(): string;
    set rootFile(value: string);
    get rootFileInput(): string | undefined;
    private _configFile;
    get configFile(): NginxConfigurationConfigFileList;
    putConfigFile(value: NginxConfigurationConfigFile[] | cdktf.IResolvable): void;
    resetConfigFile(): void;
    get configFileInput(): cdktf.IResolvable | NginxConfigurationConfigFile[] | undefined;
    private _protectedFile;
    get protectedFile(): NginxConfigurationProtectedFileList;
    putProtectedFile(value: NginxConfigurationProtectedFile[] | cdktf.IResolvable): void;
    resetProtectedFile(): void;
    get protectedFileInput(): cdktf.IResolvable | NginxConfigurationProtectedFile[] | undefined;
    private _timeouts;
    get timeouts(): NginxConfigurationTimeoutsOutputReference;
    putTimeouts(value: NginxConfigurationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NginxConfigurationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
