class DataFilePartsLookup(object):
    valid_instruments = {
        "em122",
        "em302",
        "em300",
        "3012-p1",
        "3012-l3",
        "3012",
        "em1002",
        "r2sonic2022",
        "em120",
        "swathplus",
        "reson8101",
        "t20p",
        "em124",
        "7101",
        "me70",
        "8125",
        "em710",
        "sea_swathplus",
        "sb2120",
        "em304",
        "em2040",
        "em2040p",
        "em712",
        "sb2112",
        "em3002",
        "em3002d",
        "EM3000",
        "2112",
        "reson7125_400",
        "EM1000",
        "reson8125",
        "em121",
        "7125",
        "r2sonic2024",
        "EM3002",
        "7160",
        "8101",
        "EM1002",
        "em3000",
        "reson7125",
        "t20-p",
        "reson8150",
        "em300d",
        "reson7125_ppk",
        "t50-p",
        "reson7111",
        "hydrosweep",
        "elac3020",
        "reson7125_200",
        "em2040c",
    }
    known_legs = {
        "leg1",
        "leg1and2b",
        "leg2",
        "leg2a",
        "leg3",
        "leg3a",
        "leg3b",
        "leg3c",
        "leg4",
    }
    known_erroneous = {
        # "backscatter", Kevin is tagging surveys with backscatter upstream
        "W00246",
        "W00246",
        "W00247",
        "xyz",
        "DNP",
        "MDACS",
        "used_for_leadline",
        "FS190006",
        "FS190007",
        "Backscatter",
        "Grids",
        "images",
        "xbt",
        # "KM1718_Grids",
    }
    known_regions = {
        "oahu",
        "galway",
        "killary",
        "tralee",
        "BuckIsland_StCroix",
        "Eagle_Island",
        "Galway_Bay",
        "hilo",
        "kaho",
        "kauai",
        "lanai",
        "lanai2",
        "maui",
        "molo",
        "molokai",
        "Nephrops",
        "newport",
        "sandiego",
        "Shoals",
        "Smart_Bay",
        "soundings",
        "StJohn",
        "StThomas",
        "WestPorcupine",
    }
    known_zones = {
        "ZONE_AGH",
        "ZONE_AI",
        "ZONE_AIJ",
        "ZONE_AJK",
        "ZONE_AK",
        "ZONE_ALM",
        "ZONE_AM",
        "ZONE_AMN",
        "ZONE_AN",
        "ZONE_AO",
        "ZONE_AOPQ",
        "ZONE_APQ",
        "ZONE_O",
        "ZONE_P",
        "ZONE_Q",
        "ZONE_R",
        "ZONE1",
        "ZONE10",
        "ZONE2",
        "ZONE3",
        "ZONE4",
        "ZONE75",
        "ZONE78",
        "ZONE9",
        "ZONEG",
        "ZONEH",
        "ZONEI",
        "ZONEJ",
        "ZONEM",
        "ZONEN",
        "3A_deepwater",
        "3B_deepwater",
        "3C_deepwater",
        "3D_deepwater",
        "3E_deepwater",
        "3F_deepwater",
        "3G_deepwater",
        "3H_deepwater",
        "AHI-03-07a",
        "AHI-03-07b",
        "AHI-03-07c",
        "Area_2",
    }
    surveys_with_instrument_in_filenames = {
        "KM0812",
        "KM0620",
        "KM0622",
        "KM0710",
        "KM0810",
        "KM0308",
        "KM0314",
        "KM0317",
        "KM0319",
        "KM0320",
        "KM0321",
        "KM0322",
        "KM0323",
        "KM0324",
        "KM0326",
        "KM0402",
        "KM0403",
        "KM0404",
        "KM0405",
        "KM0407",
        "KM0409",
        "KM0414",
        "KM0510",
        "KM0511",
        "KM0518",
        "KM0601",
        "KM0602",
        "KM0603",
        "KM0604",
        "KM0605",
        "KM0606",
        "KM0607",
        "KM0609",
        "KM0610",
        "KM0611",
        "KM0612",
        "KM0613",
        "KM0614",
        "KM0615",
        "KM0616",
        "KM0617",
        "KM0618",
        "KM0619",
        "KM0621",
        "KM0623",
        "KM0624",
        "KM0625",
        "KM0626",
        "KM0627",
        "KM0628",
        "KM0629",
        "KM0630",
        "KM0631",
        "KM0632",
        "KM0701",
        "KM0703",
        "KM0706",
        "KM0707",
        "KM0708",
        "KM0712",
        "KM0713",
        "KM0714",
        "KM0715",
        "KM0716",
        "KM0718",
        "KM0719",
        "KM0720",
        "KM0721",
        "KM0722",
        "KM0723",
        "KM0801",
        "KM0802",
        "KM0803",
        "KM0805",
        "KM0806",
        "KM0807",
        "KM0808",
        "KM0809",
        "KM0811",
        "KM0813",
        "KM0814",
        "KM0815",
        "KM0816",
        "KM0817",
        "KM0818",
        "KM0819",
        "KM0824",
        "KM0911",
    }
