/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.util.preprocessor;

import com.datapps.linkoopdb.jdbc.util.preprocessor.LineType;
import com.datapps.linkoopdb.jdbc.util.preprocessor.PreprocessorException;

class Line {
    static final String DIRECTIVE_PREFIX = "//#";
    static final String SPACE_CHARS = " \t";
    static final int DIRECTIVE_PREFIX_LENGTH = "//#".length();
    static final int DIRECTIVE_PREFIX_LENGTH_PLUS_ONE = DIRECTIVE_PREFIX_LENGTH + 1;
    static final String HIDE_DIRECTIVE = "//# ";
    int type;
    String sourceText;
    String indent;
    String text;
    String arguments;

    Line(String line) throws PreprocessorException {
        this.setSourceText(line);
    }

    static int indexOfNonTabOrSpace(String line) {
        char ch;
        int pos;
        int len = line.length();
        for (pos = 0; pos < len && ((ch = line.charAt(pos)) == ' ' || ch == '\t'); ++pos) {
        }
        return pos;
    }

    static int indexOfTabOrSpace(String s, int fromIndex) {
        int spos = s.indexOf(32, fromIndex);
        int tpos = s.indexOf(9, fromIndex);
        return tpos != -1 && tpos < spos || spos == -1 ? tpos : spos;
    }

    String getArguments() throws PreprocessorException {
        if (this.arguments == null || this.arguments.length() == 0) {
            throw new PreprocessorException("[" + this.text + "]: has no argument(s)");
        }
        return this.arguments;
    }

    String getSourceText() {
        return this.sourceText;
    }

    void setSourceText(String line) throws PreprocessorException {
        this.sourceText = line;
        int pos = Line.indexOfNonTabOrSpace(line);
        this.indent = line.substring(0, pos);
        if (!(line = line.substring(pos)).startsWith(DIRECTIVE_PREFIX)) {
            this.text = line;
            this.arguments = null;
            this.type = 14;
        } else if (line.length() == DIRECTIVE_PREFIX_LENGTH) {
            this.text = "";
            this.arguments = null;
            this.type = 8;
        } else if (SPACE_CHARS.indexOf(line.charAt(DIRECTIVE_PREFIX_LENGTH)) != -1) {
            this.text = line.substring(DIRECTIVE_PREFIX_LENGTH_PLUS_ONE);
            this.arguments = null;
            this.type = 8;
        } else {
            pos = Line.indexOfTabOrSpace(line, DIRECTIVE_PREFIX_LENGTH_PLUS_ONE);
            if (pos == -1) {
                this.text = line;
                this.arguments = null;
            } else {
                this.text = line.substring(0, pos);
                this.arguments = line.substring(pos + 1).trim();
            }
            Integer oType = (Integer)LineType.directives().get(this.text);
            if (oType == null) {
                throw new PreprocessorException("Unknown directive [" + this.text + "] in [" + line + "]");
            }
            this.type = oType;
        }
    }

    String getIndent() {
        return this.indent;
    }

    String getText() {
        return this.text;
    }

    int getType() {
        return this.type;
    }

    boolean isType(int lineType) {
        return this.type == lineType;
    }

    public String toString() {
        return LineType.labels()[this.type] + "(" + this.type + "): indent [" + this.indent + "] text [" + this.text + (this.arguments == null ? "]" : "] args [" + this.arguments + "]");
    }
}

