# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetNetworkSecurityGroupVnicsResult',
    'AwaitableGetNetworkSecurityGroupVnicsResult',
    'get_network_security_group_vnics',
    'get_network_security_group_vnics_output',
]

@pulumi.output_type
class GetNetworkSecurityGroupVnicsResult:
    """
    A collection of values returned by getNetworkSecurityGroupVnics.
    """
    def __init__(__self__, filters=None, id=None, network_security_group_id=None, network_security_group_vnics=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if network_security_group_id and not isinstance(network_security_group_id, str):
            raise TypeError("Expected argument 'network_security_group_id' to be a str")
        pulumi.set(__self__, "network_security_group_id", network_security_group_id)
        if network_security_group_vnics and not isinstance(network_security_group_vnics, list):
            raise TypeError("Expected argument 'network_security_group_vnics' to be a list")
        pulumi.set(__self__, "network_security_group_vnics", network_security_group_vnics)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetNetworkSecurityGroupVnicsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="networkSecurityGroupId")
    def network_security_group_id(self) -> str:
        return pulumi.get(self, "network_security_group_id")

    @property
    @pulumi.getter(name="networkSecurityGroupVnics")
    def network_security_group_vnics(self) -> Sequence['outputs.GetNetworkSecurityGroupVnicsNetworkSecurityGroupVnicResult']:
        """
        The list of network_security_group_vnics.
        """
        return pulumi.get(self, "network_security_group_vnics")


class AwaitableGetNetworkSecurityGroupVnicsResult(GetNetworkSecurityGroupVnicsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkSecurityGroupVnicsResult(
            filters=self.filters,
            id=self.id,
            network_security_group_id=self.network_security_group_id,
            network_security_group_vnics=self.network_security_group_vnics)


def get_network_security_group_vnics(filters: Optional[Sequence[Union['GetNetworkSecurityGroupVnicsFilterArgs', 'GetNetworkSecurityGroupVnicsFilterArgsDict']]] = None,
                                     network_security_group_id: Optional[str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkSecurityGroupVnicsResult:
    """
    This data source provides the list of Network Security Group Vnics in Oracle Cloud Infrastructure Core service.

    Lists the VNICs in the specified network security group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_network_security_group_vnics = oci.Core.get_network_security_group_vnics(network_security_group_id=test_network_security_group["id"])
    ```


    :param str network_security_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security group.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['networkSecurityGroupId'] = network_security_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getNetworkSecurityGroupVnics:getNetworkSecurityGroupVnics', __args__, opts=opts, typ=GetNetworkSecurityGroupVnicsResult).value

    return AwaitableGetNetworkSecurityGroupVnicsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        network_security_group_id=pulumi.get(__ret__, 'network_security_group_id'),
        network_security_group_vnics=pulumi.get(__ret__, 'network_security_group_vnics'))


@_utilities.lift_output_func(get_network_security_group_vnics)
def get_network_security_group_vnics_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetNetworkSecurityGroupVnicsFilterArgs', 'GetNetworkSecurityGroupVnicsFilterArgsDict']]]]] = None,
                                            network_security_group_id: Optional[pulumi.Input[str]] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNetworkSecurityGroupVnicsResult]:
    """
    This data source provides the list of Network Security Group Vnics in Oracle Cloud Infrastructure Core service.

    Lists the VNICs in the specified network security group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_network_security_group_vnics = oci.Core.get_network_security_group_vnics(network_security_group_id=test_network_security_group["id"])
    ```


    :param str network_security_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security group.
    """
    ...
