"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenApiGatewayToLambda = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const iam = require("aws-cdk-lib/aws-iam");
const defaults = require("@aws-solutions-constructs/core");
const openapi_helper_1 = require("./openapi-helper");
class OpenApiGatewayToLambda extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        (0, openapi_helper_1.CheckOpenApiProps)(props);
        this.apiLambdaFunctions = (0, openapi_helper_1.MapApiIntegrationsToApiFunction)(this, props.apiIntegrations);
        const definition = (0, openapi_helper_1.ObtainApiDefinition)(this, {
            tokenToFunctionMap: this.apiLambdaFunctions,
            apiDefinitionBucket: props.apiDefinitionBucket,
            apiDefinitionKey: props.apiDefinitionKey,
            apiDefinitionAsset: props.apiDefinitionAsset,
            apiJsonDefinition: props.apiDefinitionJson,
            internalTransformTimeout: props.internalTransformTimeout,
            internalTransformMemorySize: props.internalTransformMemorySize
        });
        const specRestApiResponse = defaults.CreateSpecRestApi(this, {
            ...props.apiGatewayProps,
            apiDefinition: definition
        }, props.logGroupProps);
        this.apiGateway = specRestApiResponse.api;
        this.apiGatewayCloudWatchRole = specRestApiResponse.role;
        this.apiGatewayLogGroup = specRestApiResponse.logGroup;
        // Redeploy the API any time a decoupled (non-inline) API definition changes (from asset or s3 object)
        this.apiGateway.latestDeployment?.addToLogicalId(props.apiDefinitionKey ?? props.apiDefinitionAsset?.s3ObjectKey);
        this.apiLambdaFunctions.forEach(apiLambdaFunction => {
            const targetInterface = (0, openapi_helper_1.ExtractFunctionInterface)(apiLambdaFunction);
            // Redeploy the API any time one of the lambda functions changes
            this.apiGateway.latestDeployment?.addToLogicalId(targetInterface.functionArn);
            targetInterface.addPermission(`${id}PermitAPIGInvocation`, {
                principal: new iam.ServicePrincipal('apigateway.amazonaws.com'),
                sourceArn: this.apiGateway.arnForExecuteApi('*')
            });
        });
    }
}
exports.OpenApiGatewayToLambda = OpenApiGatewayToLambda;
_a = JSII_RTTI_SYMBOL_1;
OpenApiGatewayToLambda[_a] = { fqn: "@aws-solutions-constructs/aws-openapigateway-lambda.OpenApiGatewayToLambda", version: "2.78.1" };
//# sourceMappingURL=data:application/json;base64,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